/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Target;
import gnu.mapping.OutPort;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class Package
extends Expression {
    ClassExp firstClass;
    private Vector classes = new Vector(10);
    public Package next;
    public final String name;
    public final String prefix;
    public File directory;

    public Package(String name) {
        this.name = name;
        this.prefix = name.replace('.', '/') + "/";
    }

    @Override
    public void print(OutPort ps) {
        ps.print("Package " + this.name);
    }

    @Override
    public void compile(Compilation comp, Target target) {
        throw new Error("A package cannot be evaluated");
    }

    @Override
    protected void walkChildren(ExpWalker walker) {
        LambdaExp c = this.firstClass;
        while (c != null) {
            ((LambdaExp)c).walk(walker);
            c = c.nextSibling;
        }
    }

    public void addClass(ClassExp classe) {
        classe.nextSibling = this.firstClass;
        this.firstClass = classe;
    }

    void addClass(ClassType c) {
        this.classes.add(c);
    }

    public ClassType findNamedClass(String name) {
        int i = this.classes.size();
        while (--i >= 0) {
            if (!name.equals(((ClassType)this.classes.get(i)).getName())) continue;
            return (ClassType)this.classes.get(i);
        }
        return null;
    }

    public void compileToFiles() throws IOException {
        Compilation comp = new Compilation();
        comp.compile(this);
        Package p = this;
        while (p != null) {
            p.writeClasses();
            p = p.next;
        }
    }

    private void writeClasses() throws IOException {
        for (ClassType clas : this.classes) {
            String name = clas.getName();
            int lastDot = name.lastIndexOf(46);
            if (lastDot != -1) {
                if (!name.substring(0, lastDot).equals(this.name)) {
                    throw new Error("Class generated in the wrong package: " + name + " was found in package " + this.name);
                }
                name = name.substring(lastDot + 1);
            }
            File out = new File(this.directory, name + ".class");
            out.getParentFile().mkdirs();
            clas.writeToFile(out);
        }
    }
}

