/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.LList;
import gnu.lists.Sequence;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Pair
extends LList
implements Externalizable {
    public Object car;
    public Object cdr;

    public Pair(Object carval, Object cdrval) {
        this.car = carval;
        this.cdr = cdrval;
    }

    public Pair() {
    }

    @Override
    public int size() {
        int n = Pair.listLength(this, true);
        if (n >= 0) {
            return n;
        }
        if (n == -1) {
            return Integer.MAX_VALUE;
        }
        throw new RuntimeException("not a true list");
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public int length() {
        int n = 0;
        Object slow = this;
        Object fast = this;
        while (fast != Empty) {
            if (!(fast instanceof Pair)) {
                if (fast instanceof Sequence) {
                    int j = ((Sequence)fast).size();
                    return j >= 0 ? n + j : j;
                }
                return -2;
            }
            Pair fast_pair = fast;
            if (fast_pair.cdr == Empty) {
                return n + 1;
            }
            if (fast == slow && n > 0) {
                return -1;
            }
            if (!(fast_pair.cdr instanceof Pair)) {
                ++n;
                fast = fast_pair.cdr;
                continue;
            }
            if (!(slow instanceof Pair)) {
                return -2;
            }
            slow = ((Pair)slow).cdr;
            fast = ((Pair)fast_pair.cdr).cdr;
            n += 2;
        }
        return n;
    }

    @Override
    public int hashCode() {
        int hash = 1;
        Object list = this;
        while (list instanceof Pair) {
            Pair pair = list;
            Object obj = pair.car;
            hash = 31 * hash + (obj == null ? 0 : obj.hashCode());
            list = pair.cdr;
        }
        if (list != LList.Empty && list != null) {
            hash ^= list.hashCode();
        }
        return hash;
    }

    public static boolean equals(Pair pair1, Pair pair2) {
        if (pair1 == pair2) {
            return true;
        }
        if (pair1 == null || pair2 == null) {
            return false;
        }
        Object x2;
        Object x1;
        while ((x1 = pair1.car) == (x2 = pair2.car) || x1 != null && x1.equals(x2)) {
            x1 = pair1.cdr;
            x2 = pair2.cdr;
            if (x1 == x2) {
                return true;
            }
            if (x1 == null || x2 == null) {
                return false;
            }
            if (!(x1 instanceof Pair) || !(x2 instanceof Pair)) {
                return x1.equals(x2);
            }
            pair1 = (Pair)x1;
            pair2 = (Pair)x2;
        }
        return false;
    }

    @Override
    public Object get(int index) {
        int i;
        Pair pair = this;
        for (i = index; i > 0; --i) {
            if (pair.cdr instanceof Pair) {
                pair = (Pair)pair.cdr;
                continue;
            }
            if (!(pair.cdr instanceof Sequence)) break;
            return ((Sequence)pair.cdr).get(i);
        }
        if (i == 0) {
            return pair.car;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Pair) {
            return Pair.equals(this, (Pair)obj);
        }
        return false;
    }

    public static Pair make(Object car, Object cdr) {
        return new Pair(car, cdr);
    }

    @Override
    public Object[] toArray() {
        int i;
        int len = this.size();
        Object[] arr = new Object[len];
        Sequence rest = this;
        for (i = 0; i < len && rest instanceof Pair; ++i) {
            Pair pair = rest;
            arr[i] = pair.car;
            rest = (Sequence)pair.cdr;
        }
        int prefix = i;
        while (i < len) {
            arr[i] = rest.get(i - prefix);
            ++i;
        }
        return arr;
    }

    @Override
    public Object[] toArray(Object[] arr) {
        int i;
        int alen = arr.length;
        int len = this.length();
        if (len > alen) {
            arr = new Object[len];
            alen = len;
        }
        Sequence rest = this;
        for (i = 0; i < len && rest instanceof Pair; ++i) {
            Pair pair = rest;
            arr[i] = pair.car;
            rest = (Sequence)pair.cdr;
        }
        int prefix = i;
        while (i < len) {
            arr[i] = rest.get(i - prefix);
            ++i;
        }
        if (len < alen) {
            arr[len] = null;
        }
        return arr;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.car);
        out.writeObject(this.cdr);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.car = in.readObject();
        this.cdr = in.readObject();
    }
}

