/*
 * Decompiled with CFR 0.152.
 */
package bossa.link;

import bossa.syntax.ConstantExp;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Pattern;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import bossa.util.Util;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import mlsub.typing.TypeConstructor;
import nice.tools.code.Gen;

public abstract class Alternative
implements Located {
    static final int UNVISITED = 1;
    static final int VISITING = 2;
    static final int VISITED = 3;
    int mark = 1;
    String methodName;
    String fullName;
    Pattern[] patterns;
    private static HashMap alternatives;

    public Alternative(String methodName, String fullName, Pattern[] patterns) {
        this.methodName = methodName;
        this.fullName = fullName;
        this.patterns = patterns;
        this.add();
    }

    public static boolean leq(Alternative a, Alternative b) {
        int i = 0;
        while (i < a.patterns.length) {
            if (!a.patterns[i].leq(b.patterns[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean less(Alternative a, Alternative b) {
        boolean strictly = false;
        int i = 0;
        while (i < a.patterns.length) {
            if (!a.patterns[i].leq(b.patterns[i])) {
                return false;
            }
            if (!b.patterns[i].leq(a.patterns[i])) {
                strictly = true;
            }
            ++i;
        }
        return strictly;
    }

    boolean matches(TypeConstructor[] tags) {
        int i = 0;
        while (i < this.patterns.length) {
            if (!this.patterns[i].matches(tags[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean matchesTypePart(TypeConstructor[] tags, boolean[] isValue) {
        int i = 0;
        while (i < this.patterns.length) {
            if (!isValue[i] && !this.patterns[i].matches(tags[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean matchesValuePart(ConstantExp[] values, boolean[] isValue) {
        int i = 0;
        while (i < this.patterns.length) {
            if (isValue[i] && !this.patterns[i].matchesValue(values[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean containsTypeMatchingValue() {
        int i = 0;
        while (i < this.patterns.length) {
            if (this.patterns[i].atTypeMatchingValue()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public abstract Expression methodExp();

    Expression matchTest(Expression[] parameters, boolean skipFirst) {
        if (parameters.length != this.patterns.length) {
            Internal.error("Incorrect parameters " + Util.map("", ", ", "", parameters) + " for " + this);
        }
        Expression result = QuoteExp.trueExp;
        int index = 0;
        while (index < parameters.length) {
            result = Gen.shortCircuitAnd(result, this.patterns[index].matchTest(parameters[index], index == 0 && skipFirst));
            ++index;
        }
        return result;
    }

    public String toString() {
        return this.methodName + Util.map("(", ", ", ")", this.patterns);
    }

    String printLocated() {
        return this.toString();
    }

    public Pattern[] getPatterns() {
        return this.patterns;
    }

    public static void reset() {
        alternatives = new HashMap();
    }

    private void add() {
        ArrayList<Alternative> l = (ArrayList<Alternative>)alternatives.get(this.fullName);
        if (l == null) {
            l = new ArrayList<Alternative>();
            alternatives.put(this.fullName, l);
        }
        l.add(this);
    }

    public static Stack sortedAlternatives(MethodDeclaration m) {
        List list = (List)alternatives.get(m.getFullName());
        if (list == null) {
            return new Stack();
        }
        return Alternative.sort(list);
    }

    private static Stack sort(List alternatives) {
        Stack sortedAlternatives = new Stack();
        if (alternatives.size() == 0) {
            return sortedAlternatives;
        }
        if (((Alternative)alternatives.get((int)0)).mark != 1) {
            Iterator i = alternatives.iterator();
            while (i.hasNext()) {
                ((Alternative)i.next()).mark = 1;
            }
        }
        Iterator i = alternatives.iterator();
        while (i.hasNext()) {
            Alternative a = (Alternative)i.next();
            if (a.mark != 1) continue;
            Alternative.visit(a, alternatives, sortedAlternatives);
        }
        return sortedAlternatives;
    }

    private static final void visit(Alternative a, List alternatives, Stack sortedAlternatives) {
        switch (a.mark) {
            case 2: {
                User.error("Cycle in alternatives: " + a);
            }
            case 1: {
                a.mark = 2;
                break;
            }
            case 3: {
                return;
            }
        }
        Iterator i = alternatives.iterator();
        while (i.hasNext()) {
            Alternative daughter = (Alternative)i.next();
            if (daughter == a || daughter.mark != 1 || !Alternative.leq(daughter, a)) continue;
            Alternative.visit(daughter, alternatives, sortedAlternatives);
        }
        a.mark = 3;
        sortedAlternatives.push(a);
    }

    public abstract Location location();
}

