/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Arguments;
import bossa.syntax.Constraint;
import bossa.syntax.Definition;
import bossa.syntax.Expression;
import bossa.syntax.FieldAccess;
import bossa.syntax.FormalParameters;
import bossa.syntax.FunSymbol;
import bossa.syntax.LocatedString;
import bossa.syntax.Monotype;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.Util;
import gnu.bytecode.Type;
import java.io.PrintWriter;
import mlsub.typing.FunType;
import mlsub.typing.Polytype;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Types;

public abstract class MethodDeclaration
extends Definition {
    private Polytype type;
    private String syntacticConstraint;
    protected int arity;
    protected FormalParameters parameters;
    private Symbol symbol;
    private gnu.expr.Expression code;

    public MethodDeclaration(LocatedString name, Constraint constraint, Monotype returnType, FormalParameters parameters) {
        super(name, 2);
        this.parameters = parameters;
        this.addChild(parameters);
        if (constraint == null) {
            constraint = Constraint.True;
        }
        this.syntacticConstraint = constraint.toString();
        this.symbol = new Symbol(name, constraint, returnType);
        this.symbol.propagate = 1;
        this.addChild(this.symbol);
        this.arity = parameters.size;
    }

    MethodDeclaration(LocatedString name, mlsub.typing.Constraint cst, mlsub.typing.Monotype[] parameters, mlsub.typing.Monotype returnType) {
        this(name, null, cst, parameters, returnType);
    }

    MethodDeclaration(LocatedString name, FormalParameters formals, mlsub.typing.Constraint cst, mlsub.typing.Monotype[] parameters, mlsub.typing.Monotype returnType) {
        this(name, formals, new Polytype(cst, new FunType(parameters, returnType)));
    }

    MethodDeclaration(LocatedString name, FormalParameters formals, Polytype type) {
        super(name, 1);
        this.parameters = formals;
        this.arity = type.domain().length;
        this.type = type;
        this.symbol = new Symbol(name, type);
    }

    public final Polytype getType() {
        return this.type;
    }

    public final mlsub.typing.Monotype[] getArgTypes() {
        if (this.type == null) {
            this.symbol.resolve();
        }
        return this.type.domain();
    }

    public final mlsub.typing.Monotype getReturnType() {
        return this.type.codomain();
    }

    boolean isIgnored() {
        return false;
    }

    void typedResolve() {
        Polytype type = this.getType();
        if (!mlsub.typing.Constraint.hasBinders(type.getConstraint())) {
            this.parameters.typecheck(type.domain());
            return;
        }
        try {
            Typing.enter();
            try {
                type.getConstraint().enter();
                Typing.implies();
                this.parameters.typecheck(type.domain());
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Typing.leave();
                throw throwable;
            }
            Typing.leave();
            {
            }
        }
        catch (TypingEx e) {
            User.error((Located)this, "The type of method " + this.symbol.name + " is not well formed: " + type + "\n" + e);
        }
    }

    void innerTypecheck() throws TypingEx {
    }

    void typecheck() {
        if (this.isIgnored()) {
            return;
        }
        Polytype type = this.getType();
        if (!mlsub.typing.Constraint.hasBinders(type.getConstraint())) {
            try {
                this.innerTypecheck();
            }
            catch (TypingEx e) {
                User.error((Located)this, "Type error in method " + this.symbol.name);
            }
            return;
        }
        try {
            Typing.enter();
            try {
                type.getConstraint().enter();
                this.innerTypecheck();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                Typing.leave();
                throw throwable;
            }
            Typing.leave();
            {
            }
        }
        catch (TypingEx e) {
            User.error((Located)this, "The type of method " + this.symbol.name + " is not well formed: " + type + "\n" + e);
        }
    }

    void typecheckCompiled() {
    }

    public abstract void printInterface(PrintWriter var1);

    public String toString() {
        if (this.getType() == null) {
            return "method " + this.getName();
        }
        return (this.syntacticConstraint != null ? this.syntacticConstraint : mlsub.typing.Constraint.toString(this.getType().getConstraint())) + String.valueOf(this.getReturnType()) + " " + this.getName().toQuotedString() + "(" + (this.parameters != null ? this.parameters.toString() : Util.map("", ", ", "", this.getType().domain())) + ")";
    }

    public int getArity() {
        return this.arity;
    }

    public FormalParameters formalParameters() {
        return this.parameters;
    }

    public boolean isFieldAccess() {
        return false;
    }

    void checkSpecialRequirements(Expression[] arguments) {
    }

    String explainWhyMatchFails(Arguments arguments) {
        return this.symbol.defaultExplainWhyMatchFails(arguments);
    }

    Symbol getSymbol() {
        return this.symbol;
    }

    public String getFullName() {
        return "NONE";
    }

    protected abstract gnu.expr.Expression computeCode();

    gnu.expr.Expression getCode() {
        return this.getCodeInCallPosition();
    }

    gnu.expr.Expression getConstructorInvocation(boolean omitDefaults) {
        throw new Error("Constructor for " + this + " (" + this.getClass() + ")");
    }

    final gnu.expr.Expression getCodeInCallPosition() {
        if (this.code == null) {
            this.code = this.computeCode();
            if (this.code == null) {
                Internal.error(this, "No code for " + this);
            }
        }
        return this.code;
    }

    public Type javaReturnType() {
        return Types.javaType(this.getReturnType());
    }

    public Type[] javaArgTypes() {
        return Types.javaType(this.getType().domain());
    }

    public void compile() {
    }

    public class Symbol
    extends FunSymbol {
        Symbol(LocatedString name, Constraint constraint, Monotype returnType) {
            super(name, constraint, MethodDeclaration.this.formalParameters(), returnType);
        }

        Symbol(LocatedString name, Polytype type) {
            super(name, Types.addSure(type), MethodDeclaration.this.formalParameters(), MethodDeclaration.this.arity);
        }

        FieldAccess getFieldAccessMethod() {
            if (this.getMethodDeclaration() instanceof FieldAccess) {
                return (FieldAccess)this.getMethodDeclaration();
            }
            return null;
        }

        boolean isIgnored() {
            return this.getMethodDeclaration().isIgnored();
        }

        void checkSpecialRequirements(Expression[] arguments) {
            this.getMethodDeclaration().checkSpecialRequirements(arguments);
        }

        void resolve() {
            if (this.isIgnored()) {
                return;
            }
            if (this.syntacticType != null) {
                super.resolve();
                MethodDeclaration.this.type = this.type;
                this.type = Types.addSure(this.type);
            }
        }

        public Definition getDefinition() {
            return MethodDeclaration.this;
        }

        public MethodDeclaration getMethodDeclaration() {
            return MethodDeclaration.this;
        }

        gnu.expr.Expression compile() {
            return this.getMethodDeclaration().getCode();
        }

        gnu.expr.Expression compileInCallPosition() {
            return this.getMethodDeclaration().getCodeInCallPosition();
        }

        String explainWhyMatchFails(Arguments arguments) {
            return this.getMethodDeclaration().explainWhyMatchFails(arguments);
        }

        String defaultExplainWhyMatchFails(Arguments arguments) {
            return super.explainWhyMatchFails(arguments);
        }

        public String toString() {
            return this.getMethodDeclaration().toString();
        }
    }
}

