/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;

public class PrimType
extends Type {
    private static Field trueBoolean;
    private static Field falseBoolean;
    private static Method int_init;
    private static Method long_init;
    private static Method char_init;
    private static Method float_init;
    private static Method double_init;

    public PrimType(String nam, String sig, int siz, Class reflectClass) {
        super(nam, sig);
        this.size = siz;
        this.reflectClass = reflectClass;
        Type.registerTypeForClass(reflectClass, this);
    }

    protected PrimType(PrimType type) {
        this(type.this_name, type.signature, type.size, type.reflectClass);
    }

    public Object coerceFromObject(Object obj) {
        if (obj.getClass() == this.reflectClass) {
            return obj;
        }
        int sig1 = this.signature == null || this.signature.length() != 1 ? 32 : (int)this.signature.charAt(0);
        switch (sig1) {
            case 66: {
                return new Byte(((Number)obj).byteValue());
            }
            case 83: {
                return new Short(((Number)obj).shortValue());
            }
            case 73: {
                return new Integer(this.intValue(obj));
            }
            case 74: {
                return new Long(this.longValue(obj));
            }
            case 70: {
                return new Float(((Number)obj).floatValue());
            }
            case 68: {
                return new Double(((Number)obj).doubleValue());
            }
        }
        throw new ClassCastException("don't know how to coerce " + obj.getClass().getName() + " to " + this.getName());
    }

    public int intValue(Object value) {
        try {
            return ((Number)value).intValue();
        }
        catch (ClassCastException e) {
            return ((Character)value).charValue();
        }
    }

    public long longValue(Object value) {
        try {
            return ((Number)value).longValue();
        }
        catch (ClassCastException e) {
            return ((Character)value).charValue();
        }
    }

    public char charValue(Object value) {
        return ((Character)value).charValue();
    }

    public static boolean booleanValue(Object value) {
        return !(value instanceof Boolean) || (Boolean)value != false;
    }

    public void emitCoerceFromObject(CodeAttr code) {
        int sig1;
        int n = sig1 = this.signature == null || this.signature.length() != 1 ? 32 : (int)this.signature.charAt(0);
        if (sig1 == 90) {
            code.emitCheckcast(Type.boolean_ctype);
            code.emitInvokeVirtual(Type.booleanValue_method);
        } else if (sig1 == 86) {
            code.emitPop(1);
        } else if (sig1 == 67) {
            code.emitCheckcast(Type.character_type);
            code.emitInvokeVirtual(Type.charValue_method);
        } else {
            code.emitCheckcast(Type.number_type);
            if (sig1 == 73 || sig1 == 83 || sig1 == 66) {
                code.emitInvokeVirtual(Type.intValue_method);
            } else if (sig1 == 74) {
                code.emitInvokeVirtual(Type.longValue_method);
            } else if (sig1 == 68) {
                code.emitInvokeVirtual(Type.doubleValue_method);
            } else if (sig1 == 70) {
                code.emitInvokeVirtual(Type.floatValue_method);
            } else {
                super.emitCoerceFromObject(code);
            }
        }
    }

    public void emitCoerceToObject(CodeAttr code) {
        int sig1 = this.signature == null || this.signature.length() != 1 ? 32 : (int)this.signature.charAt(0);
        switch (sig1) {
            case 90: {
                if (trueBoolean == null) {
                    trueBoolean = Type.boolean_ctype.getDeclaredField("TRUE");
                    falseBoolean = Type.boolean_ctype.getDeclaredField("FALSE");
                }
                code.emitIfIntNotZero();
                code.emitGetStatic(trueBoolean);
                code.emitElse();
                code.emitGetStatic(falseBoolean);
                code.emitFi();
                return;
            }
            case 66: 
            case 73: 
            case 83: {
                if (int_init == null) {
                    int_init = Type.int_ctype.getDeclaredMethod("<init>", new Type[]{Type.int_type});
                }
                code.emitNew(Type.int_ctype);
                code.emitDupX();
                code.emitSwap();
                code.emitInvokeSpecial(int_init);
                return;
            }
            case 74: {
                if (long_init == null) {
                    long_init = Type.long_ctype.getDeclaredMethod("<init>", new Type[]{this});
                }
                code.emitNew(Type.long_ctype);
                code.emitDupX();
                code.emitDupX();
                code.emitPop(1);
                code.emitInvokeSpecial(long_init);
                return;
            }
            case 70: {
                if (float_init == null) {
                    float_init = Type.float_ctype.getDeclaredMethod("<init>", new Type[]{Type.float_type});
                }
                code.emitNew(Type.float_ctype);
                code.emitDupX();
                code.emitSwap();
                code.emitInvokeSpecial(float_init);
                return;
            }
            case 68: {
                if (double_init == null) {
                    double_init = Type.double_ctype.getDeclaredMethod("<init>", new Type[]{Type.double_type});
                }
                code.emitNew(Type.double_ctype);
                code.emitDupX();
                code.emitDupX();
                code.emitPop(1);
                code.emitInvokeSpecial(double_init);
                return;
            }
            case 67: {
                if (char_init == null) {
                    char_init = Type.char_ctype.getDeclaredMethod("<init>", new Type[]{this});
                }
                code.emitNew(Type.char_ctype);
                code.emitDupX();
                code.emitSwap();
                code.emitInvokeSpecial(char_init);
                return;
            }
        }
        throw new Error("unimplemented emitCoerceToObject for " + this);
    }

    public static int compare(PrimType type1, PrimType type2) {
        char sig2;
        char sig1 = type1.signature.charAt(0);
        if (sig1 == (sig2 = type2.signature.charAt(0))) {
            return 0;
        }
        if (sig1 == 'V') {
            return 1;
        }
        if (sig2 == 'V') {
            return -1;
        }
        if (sig1 == 'Z' || sig2 == 'Z') {
            return -3;
        }
        if (sig1 == 'C') {
            return type2.size > 2 ? -1 : -3;
        }
        if (sig2 == 'C') {
            return type1.size > 2 ? 1 : -3;
        }
        if (sig1 == 'D') {
            return 1;
        }
        if (sig2 == 'D') {
            return -1;
        }
        if (sig1 == 'F') {
            return 1;
        }
        if (sig2 == 'F') {
            return -1;
        }
        if (sig1 == 'J') {
            return 1;
        }
        if (sig2 == 'J') {
            return -1;
        }
        if (sig1 == 'I') {
            return 1;
        }
        if (sig2 == 'I') {
            return -1;
        }
        if (sig1 == 'S') {
            return 1;
        }
        if (sig2 == 'S') {
            return -1;
        }
        return -3;
    }

    public int compare(Type other) {
        if (other instanceof PrimType) {
            return PrimType.compare(this, (PrimType)other);
        }
        if (!(other instanceof ClassType)) {
            return -3;
        }
        char sig1 = this.signature.charAt(0);
        String otherName = other.getName();
        switch (sig1) {
            case 'V': {
                return 1;
            }
            case 'D': {
                if (!otherName.equals("java.lang.Double") && !otherName.equals("gnu.math.DFloat")) break;
                return 0;
            }
            case 'I': {
                if (otherName.equals("java.lang.Integer")) {
                    return 0;
                }
                if (!otherName.equals("gnu.math.IntNum")) break;
                return -1;
            }
        }
        if (otherName.equals("java.lang.Object")) {
            return -1;
        }
        return -2;
    }

    public boolean isAssignableTo(Type other) {
        return this == other;
    }
}

