/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.BlockExp;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class ExitExp
extends Expression {
    BlockExp block;
    Expression result;

    public ExitExp(Expression result, BlockExp block) {
        this.result = result;
        this.block = block;
    }

    public ExitExp(BlockExp block) {
        this.result = QuoteExp.voidExp;
        this.block = block;
    }

    public void compile(Compilation comp, Target target) {
        CodeAttr code = comp.getCode();
        Expression res = this.result == null ? QuoteExp.voidExp : this.result;
        res.compileWithPosition(comp, this.block.subTarget);
        code.emitGoto(this.block.exitLabel);
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkExitExp(this);
    }

    protected void walkChildren(ExpWalker walker) {
        this.result = this.result.walk(walker);
    }

    public void print(OutPort out) {
        out.startLogicalBlock("(Exit", false, ")");
        if (this.block == null || this.block.label == null) {
            out.print("<unknown>");
        } else {
            out.print(this.block.label.getName());
        }
        if (this.result != null) {
            out.writeSpaceLinear();
            this.result.print(out);
        }
        out.endLogicalBlock(")");
    }

    public Type getType() {
        return Type.neverReturnsType;
    }
}

