/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.BlockExp;
import gnu.expr.ClassExp;
import gnu.expr.ExitExp;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IfExp;
import gnu.expr.IncrementExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.ObjectExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.ThisExp;
import gnu.expr.TryExp;

public class ExpWalker {
    LambdaExp currentLambda = null;
    Object exitValue = null;

    protected Expression walkExpression(Expression exp) {
        exp.walkChildren(this);
        return exp;
    }

    protected Expression walkApplyExp(ApplyExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkIfExp(IfExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkScopeExp(ScopeExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkLetExp(LetExp exp) {
        return this.walkScopeExp(exp);
    }

    protected Expression walkLambdaExp(LambdaExp exp) {
        return this.walkScopeExp(exp);
    }

    protected Expression walkClassExp(ClassExp exp) {
        return this.walkLambdaExp(exp);
    }

    protected Expression walkObjectExp(ObjectExp exp) {
        return this.walkClassExp(exp);
    }

    protected Expression walkModuleExp(ModuleExp exp) {
        return this.walkLambdaExp(exp);
    }

    protected Expression walkSetExp(SetExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkIncrementExp(IncrementExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkTryExp(TryExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkBeginExp(BeginExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkQuoteExp(QuoteExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkReferenceExp(ReferenceExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkThisExp(ThisExp exp) {
        return this.walkReferenceExp(exp);
    }

    protected Expression walkSynchronizedExp(SynchronizedExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkBlockExp(BlockExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkExitExp(ExitExp exp) {
        return this.walkExpression(exp);
    }

    protected Expression walkFluidLetExp(FluidLetExp exp) {
        return this.walkLetExp(exp);
    }

    public final LambdaExp getCurrentLambda() {
        return this.currentLambda;
    }

    public Expression[] walkExps(Expression[] exps) {
        return this.walkExps(exps, exps.length);
    }

    public Expression[] walkExps(Expression[] exps, int n) {
        int i = 0;
        while (i < n && this.exitValue == null) {
            exps[i] = exps[i].walk(this);
            ++i;
        }
        return exps;
    }

    public void walkDefaultArgs(LambdaExp exp) {
        if (exp.defaultArgs != null) {
            exp.defaultArgs = this.walkExps(exp.defaultArgs);
        }
    }
}

