/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Interpreter;
import gnu.expr.Literal;
import gnu.expr.StackTarget;
import gnu.lists.FString;
import gnu.mapping.Values;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.lang.reflect.Array;

public class LitTable
implements ObjectOutput {
    Compilation comp;
    Object[] valueStack = new Object[20];
    Type[] typeStack = new Type[20];
    int stackPointer;

    public LitTable(Compilation comp) {
        this.comp = comp;
    }

    public void emit() throws IOException {
        Literal init = this.comp.literalsChain;
        while (init != null) {
            this.writeObject(init.value);
            init = init.next;
        }
        Literal init2 = this.comp.literalsChain;
        while (init2 != null) {
            this.emit(init2, true);
            init2 = init2.next;
        }
        this.comp.literalTable = null;
        this.comp.literalsCount = 0;
    }

    void push(Object value, Type type) {
        if (this.stackPointer >= this.valueStack.length) {
            Object[] newValues = new Object[2 * this.valueStack.length];
            Type[] newTypes = new Type[2 * this.typeStack.length];
            System.arraycopy(this.valueStack, 0, newValues, 0, this.stackPointer);
            System.arraycopy(this.typeStack, 0, newTypes, 0, this.stackPointer);
            this.valueStack = newValues;
            this.typeStack = newTypes;
        }
        this.valueStack[this.stackPointer] = value;
        this.typeStack[this.stackPointer] = type;
        ++this.stackPointer;
    }

    void error(String msg) {
        throw new Error(msg);
    }

    public void flush() {
    }

    public void close() {
    }

    public void write(int b) throws IOException {
        this.error("cannot handle call to write(int) when externalizing literal");
    }

    public void writeBytes(String s) throws IOException {
        this.error("cannot handle call to writeBytes(String) when externalizing literal");
    }

    public void write(byte[] b) throws IOException {
        this.error("cannot handle call to write(byte[]) when externalizing literal");
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.error("cannot handle call to write(byte[],int,int) when externalizing literal");
    }

    public void writeBoolean(boolean v) {
        this.push(new Boolean(v), Type.boolean_type);
    }

    public void writeChar(int v) {
        this.push(new Character((char)v), Type.char_type);
    }

    public void writeByte(int v) {
        this.push(new Byte((byte)v), Type.byte_type);
    }

    public void writeShort(int v) {
        this.push(new Short((short)v), Type.short_type);
    }

    public void writeInt(int v) {
        this.push(new Integer(v), Type.int_type);
    }

    public void writeLong(long v) {
        this.push(new Long(v), Type.long_type);
    }

    public void writeFloat(float v) {
        this.push(new Float(v), Type.float_type);
    }

    public void writeDouble(double v) {
        this.push(new Double(v), Type.double_type);
    }

    public void writeUTF(String v) {
        this.push(v, Type.string_type);
    }

    public void writeChars(String v) {
        this.push(v, Type.string_type);
    }

    public void writeObject(Object obj) throws IOException {
        Literal lit = this.comp.findLiteral(obj);
        if ((lit.flags & 3) != 0) {
            if (lit.field == null && obj != null && !(obj instanceof String)) {
                lit.assign(this.comp);
            }
            if ((lit.flags & 2) == 0) {
                lit.flags |= 4;
            }
        } else {
            lit.flags |= 1;
            int oldStack = this.stackPointer;
            if (obj instanceof FString && ((FString)obj).size() < 65535) {
                this.push(obj.toString(), Type.string_type);
            } else if (obj instanceof Externalizable) {
                ((Externalizable)obj).writeExternal(this);
            } else if (obj instanceof Object[]) {
                Object[] arr = (Object[])obj;
                int i = 0;
                while (i < arr.length) {
                    this.writeObject(arr[i]);
                    ++i;
                }
            } else if (obj != null && !(obj instanceof String) && !(lit.type instanceof ArrayType)) {
                if (obj instanceof Integer) {
                    this.push(obj, Type.int_type);
                } else if (obj instanceof Short) {
                    this.push(obj, Type.short_type);
                } else if (obj instanceof Byte) {
                    this.push(obj, Type.byte_type);
                } else if (obj instanceof Long) {
                    this.push(obj, Type.long_type);
                } else if (obj instanceof Double) {
                    this.push(obj, Type.double_type);
                } else if (obj instanceof Float) {
                    this.push(obj, Type.float_type);
                } else if (obj instanceof Character) {
                    this.push(obj, Type.char_type);
                } else {
                    this.error(obj.getClass().getName() + " does not implement Externalizable");
                }
            }
            int nargs = this.stackPointer - oldStack;
            if (nargs == 0) {
                lit.argValues = Values.noArgs;
                lit.argTypes = Type.typeArray0;
            } else {
                lit.argValues = new Object[nargs];
                lit.argTypes = new Type[nargs];
                System.arraycopy(this.valueStack, oldStack, lit.argValues, 0, nargs);
                System.arraycopy(this.typeStack, oldStack, lit.argTypes, 0, nargs);
                this.stackPointer = oldStack;
            }
            lit.flags |= 2;
        }
        this.push(lit, lit.type);
    }

    Method getMethod(ClassType type, String name, Literal literal, boolean isStatic) {
        Type[] argTypes = literal.argTypes;
        Method method = type.getDeclaredMethods();
        int argLength = argTypes.length;
        Method best = null;
        long bestArrayArgs = 0L;
        boolean ambiguous = false;
        Type[] bParameters = null;
        while (method != null) {
            boolean mstatic;
            if (name.equals(method.getName()) && isStatic == (mstatic = method.getStaticFlag())) {
                long arrayArgs = 0L;
                Type[] mParameters = method.getParameterTypes();
                int iarg = 0;
                int iparam = 0;
                block1: while (true) {
                    if (iarg == argLength && iparam == mParameters.length) {
                        if (best == null || bestArrayArgs != 0L && arrayArgs == 0L) {
                            best = method;
                            bParameters = mParameters;
                            bestArrayArgs = arrayArgs;
                            break;
                        }
                        if (arrayArgs != 0L) break;
                        boolean not1 = false;
                        boolean not2 = false;
                        int j = argLength;
                        while (--j >= 0) {
                            int c = bParameters[j].compare(mParameters[j]);
                            if (c != 1) {
                                not2 = true;
                                if (not1) break;
                            }
                            if (c == -1) continue;
                            not1 = true;
                            if (not2) break;
                        }
                        if (not1) {
                            best = method;
                            bParameters = mParameters;
                        }
                        ambiguous = not1 && not2;
                        break;
                    }
                    if (iarg == argLength || iparam == mParameters.length) break;
                    Type aType = argTypes[iarg];
                    Type pType = mParameters[iparam];
                    if (!aType.isSubtype(pType)) {
                        if (!(pType instanceof ArrayType) || iparam >= 64 || aType != Type.int_type && aType != Type.short_type) break;
                        int count = ((Number)literal.argValues[iarg]).intValue();
                        if (count < 0 && type.getName().equals("gnu.math.IntNum")) {
                            count -= Integer.MIN_VALUE;
                        }
                        Type elementType = ((ArrayType)pType).getComponentType();
                        if (count < 0 || iarg + count >= argLength) break;
                        int j = count;
                        while (--j >= 0) {
                            Type t = argTypes[iarg + j + 1];
                            if (elementType instanceof PrimType ? elementType.getSignature() != t.getSignature() : !t.isSubtype(elementType)) break block1;
                        }
                        iarg += count;
                        arrayArgs |= (long)(1 << iparam);
                    }
                    ++iarg;
                    ++iparam;
                }
            }
            method = method.getNext();
        }
        if (ambiguous) {
            return null;
        }
        if (bestArrayArgs != 0L) {
            Object[] args = new Object[bParameters.length];
            Type[] types = new Type[bParameters.length];
            int iarg = 0;
            int iparam = 0;
            while (iarg != argLength) {
                Type aType = argTypes[iarg];
                void pType = bParameters[iparam];
                if ((bestArrayArgs & (long)(1 << iparam)) == 0L) {
                    args[iparam] = literal.argValues[iarg];
                    types[iparam] = literal.argTypes[iarg];
                } else {
                    int count = ((Number)literal.argValues[iarg]).intValue();
                    boolean isIntNum = type.getName().equals("gnu.math.IntNum");
                    if (isIntNum) {
                        count -= Integer.MIN_VALUE;
                    }
                    Type elementType = ((ArrayType)pType).getComponentType();
                    types[iparam] = pType;
                    args[iparam] = Array.newInstance(elementType.getReflectClass(), count);
                    Object[] argValues = literal.argValues;
                    if (isIntNum) {
                        int[] arr = (int[])args[iparam];
                        int j = count;
                        while (j > 0) {
                            arr[count - j] = (Integer)argValues[iarg + j];
                            --j;
                        }
                    } else {
                        int j = count;
                        while (--j >= 0) {
                            Array.set(args[iparam], j, argValues[iarg + 1 + j]);
                        }
                    }
                    Literal arrayLiteral = new Literal(args[iparam], (Type)pType);
                    if (elementType instanceof ObjectType) {
                        arrayLiteral.argValues = (Object[])args[iparam];
                    }
                    args[iparam] = arrayLiteral;
                    iarg += count;
                }
                ++iarg;
                ++iparam;
            }
            literal.argValues = args;
            literal.argTypes = types;
        }
        return best;
    }

    void putArgs(Literal literal, CodeAttr code) {
        Type[] argTypes = literal.argTypes;
        int len = argTypes.length;
        int i = 0;
        while (i < len) {
            Object value = literal.argValues[i];
            if (value instanceof Literal) {
                this.emit((Literal)value, false);
            } else {
                this.comp.compileConstant(value, new StackTarget(argTypes[i]));
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void emitPrimArray(Object value, ArrayType arrayType, CodeAttr code) {
        Type elementType = arrayType.getComponentType();
        int len = Array.getLength(value);
        code.emitPushInt(len);
        code.emitNewArray(elementType);
        char sig = elementType.getSignature().charAt(0);
        int i = 0;
        while (i < len) {
            block17: {
                long ival = 0L;
                float fval = 0.0f;
                double dval = 0.0;
                switch (sig) {
                    case 'J': {
                        ival = ((long[])value)[i];
                        if (ival != 0L) break;
                        break block17;
                    }
                    case 'I': {
                        ival = ((int[])value)[i];
                        if (ival != 0L) break;
                        break block17;
                    }
                    case 'S': {
                        ival = ((short[])value)[i];
                        if (ival != 0L) break;
                        break block17;
                    }
                    case 'C': {
                        ival = ((char[])value)[i];
                        if (ival != 0L) break;
                        break block17;
                    }
                    case 'B': {
                        ival = ((byte[])value)[i];
                        if (ival != 0L) break;
                        break block17;
                    }
                    case 'Z': {
                        long l = ival = ((boolean[])value)[i] ? 1L : 0L;
                        if (ival != 0L) break;
                        break block17;
                    }
                    case 'F': {
                        fval = ((float[])value)[i];
                        if ((double)fval != 0.0) break;
                        break block17;
                    }
                    case 'D': {
                        dval = ((double[])value)[i];
                        if (dval == 0.0) break block17;
                    }
                }
                code.emitDup(arrayType);
                code.emitPushInt(i);
                switch (sig) {
                    case 'B': 
                    case 'C': 
                    case 'I': 
                    case 'S': 
                    case 'Z': {
                        code.emitPushInt((int)ival);
                        break;
                    }
                    case 'J': {
                        code.emitPushLong(ival);
                        break;
                    }
                    case 'F': {
                        code.emitPushFloat(fval);
                        break;
                    }
                    case 'D': {
                        code.emitPushDouble(dval);
                        break;
                    }
                }
                code.emitArrayStore(elementType);
            }
            ++i;
        }
    }

    void emit(Literal literal, boolean ignore) {
        CodeAttr code = this.comp.getCode();
        if (literal.value == null) {
            if (!ignore) {
                code.emitPushNull();
            }
        } else if (literal.value instanceof String) {
            if (!ignore) {
                code.emitPushString(literal.value.toString());
            }
        } else if ((literal.flags & 8) != 0) {
            if (!ignore) {
                code.emitGetStatic(literal.field);
            }
        } else if (literal.value instanceof Object[]) {
            int len = literal.argValues.length;
            Type elementType = ((ArrayType)literal.type).getComponentType();
            code.emitPushInt(len);
            code.emitNewArray(elementType);
            if (literal.field != null) {
                if (!ignore) {
                    code.emitDup(literal.type);
                }
                code.emitPutStatic(literal.field);
            }
            literal.flags |= 8;
            int i = 0;
            while (i < len) {
                Literal el = (Literal)literal.argValues[i];
                if (el.value != null) {
                    code.emitDup(elementType);
                    code.emitPushInt(i);
                    this.emit(el, false);
                    code.emitArrayStore(elementType);
                }
                ++i;
            }
        } else if (literal.type instanceof ArrayType) {
            this.emitPrimArray(literal.value, (ArrayType)literal.type, code);
            if (literal.field != null) {
                if (!ignore) {
                    code.emitDup(literal.type);
                }
                code.emitPutStatic(literal.field);
            }
            literal.flags |= 8;
        } else {
            Method resolveMethod;
            Interpreter interpreter = this.comp.getInterpreter();
            ClassType type = (ClassType)literal.type;
            boolean useDefaultInit = (literal.flags & 4) != 0;
            Method method = null;
            boolean makeStatic = false;
            if (!useDefaultInit) {
                method = this.getMethod(type, "make", literal, true);
                if (method != null) {
                    makeStatic = true;
                } else if (literal.argTypes.length > 0) {
                    method = this.getMethod(type, "<init>", literal, false);
                }
                if (method == null) {
                    useDefaultInit = true;
                }
            }
            if (useDefaultInit) {
                method = this.getMethod(type, "set", literal, false);
            }
            if (method == null && literal.argTypes.length > 0) {
                this.error("no method to construct " + literal.type);
            }
            if (makeStatic) {
                this.putArgs(literal, code);
                code.emitInvokeStatic(method);
            } else if (useDefaultInit) {
                code.emitNew(type);
                code.emitDup(type);
                Method init0 = type.getDeclaredMethod("<init>", 0);
                code.emitInvokeSpecial(init0);
            } else {
                code.emitNew(type);
                code.emitDup(type);
                this.putArgs(literal, code);
                code.emitInvokeSpecial(method);
            }
            Method method2 = resolveMethod = makeStatic ? null : type.getDeclaredMethod("readResolve", 0);
            if (resolveMethod != null) {
                code.emitInvokeVirtual(resolveMethod);
                type.emitCoerceFromObject(code);
            }
            if (literal.field != null) {
                if (!ignore || useDefaultInit && method != null) {
                    code.emitDup(type);
                }
                code.emitPutStatic(literal.field);
            }
            literal.flags |= 8;
            if (useDefaultInit && method != null) {
                if (!ignore) {
                    code.emitDup(type);
                }
                this.putArgs(literal, code);
                code.emitInvokeVirtual(method);
            }
        }
    }
}

