/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.bytecode.VerificationError;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleMethod;
import gnu.expr.Target;
import gnu.lists.LList;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.WrongArguments;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.util.Stack;

public class PrimProcedure
extends MethodProc
implements Inlineable {
    Type retType;
    Type[] argTypes;
    Method method;
    int op_code;
    LambdaExp source;
    Member member;
    private Stack[] parameterCopies;
    private static ClassLoader systemClassLoader = (class$gnu$expr$PrimProcedure == null ? (class$gnu$expr$PrimProcedure = PrimProcedure.class$("gnu.expr.PrimProcedure")) : class$gnu$expr$PrimProcedure).getClassLoader();
    static /* synthetic */ Class class$gnu$expr$PrimProcedure;

    public final int opcode() {
        return this.op_code;
    }

    public Type getReturnType() {
        return this.retType;
    }

    public void setReturnType(Type retType) {
        this.retType = retType;
    }

    public Type getReturnType(Expression[] args) {
        return this.retType;
    }

    public boolean takesVarArgs() {
        return this.method != null && this.method.getName().endsWith("$V");
    }

    public int numArgs() {
        int num = this.argTypes.length;
        if (!this.getStaticFlag()) {
            ++num;
        }
        return this.takesVarArgs() ? num - 1 + -4096 : num + (num << 12);
    }

    public int match(CallContext ctx, Object[] args) {
        int fixArgs;
        ctx.setArgsN(args);
        int nargs = ctx.count;
        boolean takesVarArgs = this.takesVarArgs();
        int mlength = this.minArgs() + (takesVarArgs ? 1 : 0);
        int n = fixArgs = takesVarArgs ? mlength - 1 : mlength;
        if (takesVarArgs) {
            if (nargs < fixArgs) {
                return 0xFFF10000 | fixArgs;
            }
        } else if (nargs != mlength) {
            if (nargs < mlength) {
                return 0xFFF10000 | fixArgs;
            }
            return 0xFFF20000 | fixArgs;
        }
        int arg_count = this.argTypes.length;
        Type elementType = null;
        Object[] restArray = null;
        int this_count = this.getStaticFlag() ? 0 : 1;
        Object[] rargs = new Object[mlength - this_count];
        if (takesVarArgs) {
            Type restType = this.argTypes[arg_count - 1];
            if (restType == Compilation.scmListType) {
                rargs[rargs.length - 1] = LList.makeList(args, fixArgs);
                nargs = fixArgs;
            } else {
                ArrayType restArrayType = (ArrayType)restType;
                elementType = restArrayType.getComponentType();
                Class elementClass = elementType.getReflectClass();
                rargs[rargs.length - 1] = restArray = (Object[])Array.newInstance(elementClass, nargs - fixArgs);
            }
        }
        Object thisValue = this_count != 0 ? this.method.getDeclaringClass().coerceFromObject(ctx.getArgAsObject(0)) : null;
        int i = this_count;
        while (i < nargs) {
            try {
                Type type;
                Object arg = ctx.getArgAsObject(i);
                Type type2 = type = i < fixArgs ? this.argTypes[i - this_count] : elementType;
                if (type != Type.pointer_type) {
                    arg = type.coerceFromObject(arg);
                }
                if (i < fixArgs) {
                    rargs[i - this_count] = arg;
                } else {
                    restArray[i - fixArgs] = arg;
                }
            }
            catch (ClassCastException ex) {
                return 0xFFF40000 | i;
            }
            ++i;
        }
        ctx.value1 = thisValue;
        ctx.value2 = rargs;
        return 0;
    }

    public Object applyV(CallContext ctx) throws Throwable {
        int arg_count = this.argTypes.length;
        boolean is_constructor = this.op_code == 183;
        boolean is_static = this.getStaticFlag();
        try {
            if (this.member == null) {
                Class clas = this.method.getDeclaringClass().getReflectClass();
                Class[] paramTypes = new Class[arg_count];
                int i = arg_count;
                while (--i >= 0) {
                    paramTypes[i] = this.argTypes[i].getReflectClass();
                }
                this.member = is_constructor ? clas.getConstructor(paramTypes) : clas.getMethod(this.method.getName(), paramTypes);
            }
            Object[] rargs = (Object[])ctx.value2;
            if (is_constructor) {
                return ((Constructor)this.member).newInstance(rargs);
            }
            java.lang.reflect.Method meth = (java.lang.reflect.Method)this.member;
            Object result = meth.invoke(ctx.value1, rargs);
            return this.retType.coerceToObject(result);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    public PrimProcedure(java.lang.reflect.Method method, Class thisClass, Class[] parameterClasses, Interpreter interpreter) {
        Type[] parameterTypes = new Type[parameterClasses.length];
        Type[] implParameterTypes = new Type[parameterClasses.length];
        int i = parameterClasses.length;
        while (--i >= 0) {
            Type ptype;
            parameterTypes[i] = ptype = interpreter.getTypeFor(parameterClasses[i]);
            implParameterTypes[i] = ptype.getImplementationType();
        }
        Type returnType = interpreter.getTypeFor(method.getReturnType());
        Type implReturnType = returnType.getImplementationType();
        ClassType thisType = (ClassType)interpreter.getTypeFor(thisClass);
        Method meth = thisType.addMethod(method.getName(), method.getModifiers(), implParameterTypes, implReturnType);
        this.init(meth);
        this.argTypes = parameterTypes;
        this.retType = this.op_code == 183 ? meth.getDeclaringClass() : returnType;
    }

    public PrimProcedure(java.lang.reflect.Method method, Interpreter interpreter) {
        this(method, method.getDeclaringClass(), method.getParameterTypes(), interpreter);
    }

    public PrimProcedure(Method method) {
        this.init(method);
    }

    public PrimProcedure(Method method, Stack[] parameterCopies) {
        this.init(method);
        this.parameterCopies = parameterCopies;
    }

    public PrimProcedure(Method method, Interpreter interpreter) {
        this.init(method);
        Type[] pTypes = method.getParameterTypes();
        int nTypes = pTypes.length;
        this.argTypes = null;
        int i = nTypes;
        while (--i >= 0) {
            Type javaType = pTypes[i];
            Type langType = interpreter.getTypeFor(javaType.getReflectClass());
            if (javaType == langType) continue;
            if (this.argTypes == null) {
                this.argTypes = new Type[nTypes];
                System.arraycopy(pTypes, 0, this.argTypes, 0, nTypes);
            }
            this.argTypes[i] = langType;
        }
        if (this.argTypes == null) {
            this.argTypes = pTypes;
        }
        this.retType = this.op_code == 183 ? method.getDeclaringClass() : interpreter.getTypeFor(method.getReturnType().getReflectClass());
    }

    private boolean isConstructor() {
        return "<init>".equals(this.method.getName());
    }

    private void init(Method method) {
        this.method = method;
        this.argTypes = method.getParameterTypes();
        this.retType = method.getReturnType();
        int flags = method.getModifiers();
        if ((flags & 8) != 0) {
            this.op_code = 184;
        } else {
            ClassType mclass = method.getDeclaringClass();
            if ((mclass.getModifiers() & 0x200) != 0) {
                this.op_code = 185;
            } else if ("<init>".equals(method.getName())) {
                this.op_code = 183;
                this.retType = mclass;
            } else {
                this.op_code = 182;
            }
        }
    }

    public static PrimProcedure specialCall(Method method) {
        PrimProcedure res = new PrimProcedure(method);
        res.op_code = 183;
        return res;
    }

    public PrimProcedure(Method method, LambdaExp source) {
        this(method);
        this.source = source;
    }

    public PrimProcedure(int opcode, Type retType, Type[] argTypes) {
        this.op_code = opcode;
        this.retType = retType;
        this.argTypes = argTypes;
    }

    public static PrimProcedure makeBuiltinBinary(int opcode, Type type) {
        Type[] args = new Type[]{type, type};
        return new PrimProcedure(opcode, type, args);
    }

    public PrimProcedure(int op_code, ClassType classtype, String name, Type retType, Type[] argTypes) {
        this.op_code = op_code;
        if (op_code == 185) {
            classtype.access_flags |= 0x200;
        }
        this.method = classtype.getDeclaredMethod(name, argTypes, retType);
        if (this.method == null) {
            this.method = classtype.addMethod(name, op_code == 184 ? 8 : 0, argTypes, retType);
        } else if (op_code == 184 != this.method.getStaticFlag()) {
            throw new Error("Method " + this.method + " should " + (op_code == 184 ? "" : "not ") + "be static");
        }
        this.retType = retType;
        this.argTypes = argTypes;
    }

    public PrimProcedure(ClassType classtype, Type[] argTypes) {
        this(183, classtype, "<init>", Type.void_type, argTypes);
        this.retType = classtype;
    }

    public final boolean getStaticFlag() {
        return this.method == null || this.method.getStaticFlag() || this.isConstructor();
    }

    public final Type[] getParameterTypes() {
        return this.argTypes;
    }

    public static void compileArgs(Expression[] args, Type thisType, Type[] argTypes, boolean variable, String name, LambdaExp source, Compilation comp) {
        PrimProcedure.compileArgs(args, thisType, argTypes, variable, name, source, comp, source == null ? null : source.parameterCopies);
    }

    public static void compileArgs(Expression[] args, Type thisType, Type[] argTypes, boolean variable, String name, LambdaExp source, Compilation comp, Stack[] parameterCopies) {
        boolean is_static;
        Type arg_type = null;
        CodeAttr code = comp.getCode();
        int skipArg = thisType == Type.void_type ? 1 : 0;
        int arg_count = argTypes.length - skipArg;
        boolean bl = is_static = thisType == null || skipArg != 0;
        int fix_arg_count = variable ? arg_count - (is_static ? 1 : 2) : args.length;
        Declaration argDecl = source == null ? null : source.firstDecl();
        Scope scope = parameterCopies == null ? null : code.pushScope();
        int i = 0;
        while (true) {
            if (variable && i == fix_arg_count) {
                arg_type = argTypes[arg_count - 1 + skipArg];
                code.emitPushInt(args.length - fix_arg_count);
                arg_type = ((ArrayType)arg_type).getComponentType();
                code.emitNewArray(arg_type);
            }
            if (i >= args.length) break;
            if (i >= fix_arg_count) {
                code.emitDup(1);
                code.emitPushInt(i - fix_arg_count);
            } else {
                arg_type = argDecl != null && (is_static || i > 0) ? argDecl.getType() : (is_static ? argTypes[i + skipArg] : (i == 0 ? thisType : argTypes[i - 1]));
            }
            Target target = source == null ? CheckedTarget.getInstance(arg_type, name, i) : CheckedTarget.getInstance(arg_type, source, i);
            args[i].compileNotePosition(comp, target);
            if (parameterCopies != null && parameterCopies[i] != null) {
                Variable value = scope.addVariable(code, target.getType(), argDecl != null ? argDecl.getName() : "l_" + i);
                parameterCopies[i].push(value);
                code.emitDup();
                code.emitStore(value);
            }
            if (i >= fix_arg_count) {
                code.emitArrayStore(arg_type);
            }
            if (argDecl != null && (is_static || i > 0)) {
                argDecl = argDecl.nextDecl();
            }
            ++i;
        }
        if (parameterCopies != null) {
            int i2 = 0;
            while (i2 < arg_count) {
                if (parameterCopies[i2] != null) {
                    parameterCopies[i2].pop();
                }
                ++i2;
            }
        }
        if (scope != null) {
            code.popScope();
        }
    }

    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args;
        String arg_error;
        CodeAttr code = comp.getCode();
        if (this.isConstructor()) {
            ClassType type = this.method.getDeclaringClass();
            code.emitNew(type);
            code.emitDup(type);
        }
        if ((arg_error = WrongArguments.checkArgCount(this, (args = exp.getArgs()).length)) != null) {
            comp.error('e', arg_error);
        }
        try {
            this.compile(this.getStaticFlag() ? null : this.method.getDeclaringClass(), args, comp, target);
        }
        catch (VerificationError e) {
            throw User.error((Located)Location.make(exp), e.getMessage());
        }
    }

    public void compile(Type thisType, Expression[] args, Compilation comp, Target target) {
        CodeAttr code = comp.getCode();
        PrimProcedure.compileArgs(args, thisType, this.argTypes, this.takesVarArgs(), this.getName(), this.source, comp, this.parameterCopies);
        if (this.method == null) {
            code.emitPrimop(this.opcode(), args.length, this.retType);
        } else {
            code.emitInvokeMethod(this.method, this.opcode());
        }
        target.compileFromStack(comp, this.retType);
    }

    public Type getParameterType(int index) {
        int lenTypes;
        if (!this.getStaticFlag()) {
            if (index == 0) {
                return this.method.getDeclaringClass();
            }
            --index;
        }
        if (index < (lenTypes = this.argTypes.length) - 1) {
            return this.argTypes[index];
        }
        boolean varArgs = this.takesVarArgs();
        if (index < lenTypes && !varArgs) {
            return this.argTypes[index];
        }
        return ((ArrayType)this.argTypes[lenTypes - 1]).getComponentType();
    }

    public static PrimProcedure getMethodFor(Procedure pproc, Expression[] args) {
        return PrimProcedure.getMethodFor(pproc, null, args, Interpreter.getInterpreter());
    }

    public static PrimProcedure getMethodFor(Procedure pproc, Declaration decl, Expression[] args, Interpreter interpreter) {
        Class pclass = PrimProcedure.getProcedureClass(pproc);
        if (pclass == null) {
            return null;
        }
        return PrimProcedure.getMethodFor(pclass, pproc.getName(), decl, args, interpreter);
    }

    public static Class getProcedureClass(Object pproc) {
        Class<?> procClass = pproc instanceof ModuleMethod ? ((ModuleMethod)pproc).module.getClass() : pproc.getClass();
        try {
            if (procClass.getClassLoader() == systemClassLoader) {
                return procClass;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static PrimProcedure getMethodFor(Class procClass, String name, Declaration decl, Expression[] args, Interpreter interpreter) {
        try {
            java.lang.reflect.Method[] meths = procClass.getDeclaredMethods();
            java.lang.reflect.Method best = null;
            Class<?>[] bestTypes = null;
            if (name == null) {
                return null;
            }
            String mangledName = decl == null || decl.field == null ? Compilation.mangleName(name) : decl.field.getName();
            String mangledNameV = mangledName + "$V";
            int i = meths.length;
            while (--i >= 0) {
                boolean variable;
                java.lang.reflect.Method meth = meths[i];
                int mods = meth.getModifiers();
                if ((mods & 9) != 9 && (decl == null || decl.base == null)) continue;
                String mname = meth.getName();
                if (mname.equals("apply") || mname.equals(mangledName)) {
                    variable = false;
                } else {
                    if (!mname.equals("apply$V") && !mname.equals(mangledNameV)) continue;
                    variable = true;
                }
                Class<?>[] ptypes = meth.getParameterTypes();
                if (variable ? ptypes.length - 1 > args.length : ptypes.length != args.length) continue;
                if (best != null) {
                    return null;
                }
                best = meth;
                bestTypes = ptypes;
            }
            if (best != null) {
                PrimProcedure prproc = new PrimProcedure(best, procClass, bestTypes, interpreter);
                prproc.setName(name);
                return prproc;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        return null;
    }

    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        name = this.getVerboseName();
        this.setName(name);
        return name;
    }

    public String getVerboseName() {
        StringBuffer buf = new StringBuffer(100);
        if (this.method == null) {
            buf.append("<op ");
            buf.append(this.op_code);
            buf.append('>');
        } else {
            buf.append(this.method.getDeclaringClass().getName());
            buf.append('.');
            buf.append(this.method.getName());
        }
        buf.append('(');
        int i = 0;
        while (i < this.argTypes.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.argTypes[i].getName());
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append(this.retType.getName());
        buf.append(' ');
        buf.append(this.getVerboseName());
        return buf.toString();
    }

    public void print(PrintWriter ps) {
        ps.print("#<primitive procedure ");
        ps.print(this.toString());
        ps.print('>');
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

