/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.Dimensions;
import gnu.math.NamedUnit;
import gnu.math.Unit;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public class BaseUnit
extends NamedUnit
implements Externalizable {
    String dimension;
    static int base_count = 0;
    int index;
    private static final String unitName = "(name)";

    public String getDimension() {
        return this.dimension;
    }

    public BaseUnit() {
        this.name = unitName;
        this.index = Integer.MAX_VALUE;
        this.dims = Dimensions.Empty;
    }

    protected void init() {
        this.base = this;
        this.scale = 1.0;
        this.dims = new Dimensions(this);
        super.init();
        this.index = base_count++;
    }

    public BaseUnit(String name) {
        this.name = name;
        this.init();
    }

    public BaseUnit(String name, String dimension) {
        this.name = name;
        this.dimension = dimension;
        this.init();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Unit unit() {
        return this;
    }

    public static BaseUnit lookup(String name, String dimension) {
        if ((name = name.intern()) == unitName && dimension == null) {
            return Unit.Empty;
        }
        int hash = name.hashCode();
        int index = (hash & Integer.MAX_VALUE) % Unit.table.length;
        NamedUnit unit = Unit.table[index];
        while (unit != null) {
            if (unit.name == name && unit instanceof BaseUnit) {
                BaseUnit bunit = (BaseUnit)unit;
                if (bunit.dimension == dimension) {
                    return bunit;
                }
            }
            unit = unit.chain;
        }
        return null;
    }

    public static BaseUnit make(String name, String dimension) {
        BaseUnit old = BaseUnit.lookup(name, dimension);
        return old == null ? new BaseUnit(name, dimension) : old;
    }

    public static int compare(BaseUnit unit1, BaseUnit unit2) {
        int code = unit1.name.compareTo(unit2.name);
        if (code != 0) {
            return code;
        }
        String dim1 = unit1.dimension;
        String dim2 = unit2.dimension;
        if (dim1 == dim2) {
            return 0;
        }
        if (dim1 == null) {
            return -1;
        }
        if (dim2 == null) {
            return 1;
        }
        return dim1.compareTo(dim2);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.dimension);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.dimension = (String)in.readObject();
    }

    public Object readResolve() throws ObjectStreamException {
        BaseUnit unit = BaseUnit.lookup(this.name, this.dimension);
        if (unit != null) {
            return unit;
        }
        this.init();
        return this;
    }
}

