/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.DQuantity;
import gnu.math.Quantity;
import gnu.math.Unit;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public class NamedUnit
extends Unit
implements Externalizable {
    String name;
    double scale;
    Unit base;
    NamedUnit chain;

    public NamedUnit() {
    }

    public NamedUnit(String name, DQuantity value) {
        this.name = name.intern();
        this.scale = value.factor;
        this.base = value.unt;
        this.init();
    }

    public NamedUnit(String name, double factor, Unit base) {
        this.name = name;
        this.base = base;
        this.scale = factor;
        this.init();
    }

    protected void init() {
        this.factor = this.scale * this.base.factor;
        this.dims = this.base.dims;
        this.name = this.name.intern();
        int hash = this.name.hashCode();
        int index = (hash & Integer.MAX_VALUE) % Unit.table.length;
        this.chain = Unit.table[index];
        Unit.table[index] = this;
    }

    public String getName() {
        return this.name;
    }

    public static NamedUnit lookup(String name) {
        name = name.intern();
        int hash = name.hashCode();
        int index = (hash & Integer.MAX_VALUE) % Unit.table.length;
        NamedUnit unit = Unit.table[index];
        while (unit != null) {
            if (unit.name == name) {
                return unit;
            }
            unit = unit.chain;
        }
        return null;
    }

    public static NamedUnit lookup(String name, double scale, Unit base) {
        name = name.intern();
        int hash = name.hashCode();
        int index = (hash & Integer.MAX_VALUE) % Unit.table.length;
        NamedUnit unit = Unit.table[index];
        while (unit != null) {
            if (unit.name == name && unit.scale == scale && unit.base == base) {
                return unit;
            }
            unit = unit.chain;
        }
        return null;
    }

    public static NamedUnit make(String name, double scale, Unit base) {
        NamedUnit old = NamedUnit.lookup(name, scale, base);
        return old == null ? new NamedUnit(name, scale, base) : old;
    }

    public static NamedUnit make(String name, Quantity value) {
        double scale;
        if (value instanceof DQuantity) {
            scale = ((DQuantity)value).factor;
        } else {
            if (value.imValue() != 0.0) {
                throw new ArithmeticException("defining " + name + " using complex value");
            }
            scale = value.re().doubleValue();
        }
        Unit base = value.unit();
        NamedUnit old = NamedUnit.lookup(name, scale, base);
        return old == null ? new NamedUnit(name, scale, base) : old;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeDouble(this.scale);
        out.writeObject(this.base);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.scale = in.readDouble();
        this.base = (Unit)in.readObject();
    }

    public Object readResolve() throws ObjectStreamException {
        NamedUnit unit = NamedUnit.lookup(this.name, this.scale, this.base);
        if (unit != null) {
            return unit;
        }
        this.init();
        return this;
    }
}

