/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import java.util.Map;
import mlsub.typing.TypeConstructor;
import mlsub.typing.lowlevel.Element;
import mlsub.typing.lowlevel.Kind;

public abstract class Monotype
implements Element {
    static final Monotype[] zeroMonotypes = new Monotype[0];

    public final boolean isConcrete() {
        return false;
    }

    public boolean isRigid() {
        return false;
    }

    public static final boolean isRigid(Monotype[] ms) {
        if (ms == null) {
            return true;
        }
        int i = 0;
        while (i < ms.length) {
            if (!ms[i].isRigid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    abstract Monotype substitute(Map var1);

    static final Monotype[] substitute(Map map2, Monotype[] ms) {
        if (ms == null) {
            return null;
        }
        Monotype[] res = new Monotype[ms.length];
        int i = ms.length - 1;
        while (i >= 0) {
            res[i] = ms[i].substitute(map2);
            --i;
        }
        return res;
    }

    public Monotype equivalent() {
        return this;
    }

    public TypeConstructor head() {
        return null;
    }

    public Monotype[] domain() {
        return null;
    }

    abstract void tag(int var1);

    static final void tag(Monotype[] monotypes, int variance) {
        if (monotypes == null) {
            return;
        }
        int i = 0;
        while (i < monotypes.length) {
            monotypes[i].tag(variance);
            ++i;
        }
    }

    abstract Monotype canonify();

    static final Monotype[] canonify(Monotype[] monotypes) {
        if (monotypes == null) {
            return null;
        }
        Monotype[] res = new Monotype[monotypes.length];
        int i = 0;
        while (i < monotypes.length) {
            res[i] = monotypes[i].canonify();
            ++i;
        }
        return res;
    }

    public String toString(boolean isNull, String suffix) {
        String res = this.toString();
        if (isNull) {
            res = "?" + res;
        }
        if (suffix != null) {
            res = res + suffix;
        }
        return res;
    }

    public abstract void setKind(Kind var1);

    public abstract Kind getKind();

    public abstract void setId(int var1);

    public abstract int getId();
}

