/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing.lowlevel;

import java.io.Serializable;
import mlsub.typing.lowlevel.BitMatrix;
import mlsub.typing.lowlevel.InternalError;
import mlsub.typing.lowlevel.Separator;

public class BitVector
implements Cloneable,
Serializable {
    private static final int BITS_PER_UNIT = 6;
    private static final int MASK = 63;
    private long bits0;
    private long[] bits1;
    public static final int UNDEFINED_INDEX = Integer.MIN_VALUE;

    private int length() {
        if (this.bits1 == null) {
            return 1;
        }
        return this.bits1.length;
    }

    private static int subscript(int bitIndex) {
        return bitIndex >> 6;
    }

    private static int bitIndex(int subscript) {
        return (subscript << 6) + 63;
    }

    public BitVector() {
        this(64);
    }

    public BitVector(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException(Integer.toString(nbits));
        }
        if (nbits <= 64) {
            this.bits0 = 0L;
            this.bits1 = null;
        } else {
            if (nbits + 63 < 0) {
                System.out.println("Wraparoud");
                nbits = 2147483584;
            }
            int length = BitVector.subscript(nbits + 63);
            this.bits1 = new long[length];
        }
    }

    private void ensureCapacity(int nth) {
        int required = BitVector.subscript(nth) + 1;
        if (required == 1) {
            return;
        }
        if (required > this.length()) {
            int request = Math.max(2 * this.length(), required);
            if (this.bits1 == null) {
                this.bits1 = new long[request];
                this.bits1[0] = this.bits0;
            } else {
                long[] newBits = new long[request];
                System.arraycopy(this.bits1, 0, newBits, 0, this.bits1.length);
                this.bits1 = newBits;
            }
        }
    }

    public void set(int bit) {
        if (bit < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(bit));
        }
        this.ensureCapacity(bit);
        if (this.bits1 == null) {
            this.bits0 |= 1L << bit;
        } else {
            int n = BitVector.subscript(bit);
            this.bits1[n] = this.bits1[n] | 1L << (bit & 0x3F);
        }
    }

    public final void clear(int bit) {
        if (bit < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(bit));
        }
        this.ensureCapacity(bit);
        if (this.bits1 == null) {
            this.bits0 &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            int n = BitVector.subscript(bit);
            this.bits1[n] = this.bits1[n] & (1L << (bit & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public final boolean get(int bit) {
        if (bit < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(bit));
        }
        if (this.bits1 == null) {
            if (bit <= 63) {
                return (this.bits0 & 1L << bit) != 0L;
            }
            return false;
        }
        int n = BitVector.subscript(bit);
        if (n < this.bits1.length) {
            return (this.bits1[n] & 1L << (bit & 0x3F)) != 0L;
        }
        return false;
    }

    public final void and(BitVector set) {
        int n;
        if (this.bits1 == null) {
            this.bits0 = set.bits1 == null ? (this.bits0 &= set.bits0) : (this.bits0 &= set.bits1[0]);
            return;
        }
        if (this == set) {
            return;
        }
        if (set.bits1 == null) {
            this.bits0 = this.bits1[0] & set.bits0;
            this.bits1 = null;
            return;
        }
        int bitsLength = this.length();
        int setLength = set.length();
        int i = n = Math.min(bitsLength, setLength);
        while (i-- > 0) {
            int n2 = i;
            this.bits1[n2] = this.bits1[n2] & set.bits1[i];
        }
        while (n < bitsLength) {
            this.bits1[n] = 0L;
            ++n;
        }
    }

    public final void andNot(BitVector set) {
        int n;
        if (this == set) {
            this.clearAll();
            return;
        }
        if (this.bits1 == null) {
            this.bits0 = set.bits1 == null ? (this.bits0 &= set.bits0 ^ 0xFFFFFFFFFFFFFFFFL) : (this.bits0 &= set.bits1[0] ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        if (set.bits1 == null) {
            this.bits1[0] = this.bits1[0] & (set.bits0 ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        int bitsLength = this.length();
        int setLength = set.length();
        int i = n = Math.min(bitsLength, setLength);
        while (i-- > 0) {
            int n2 = i;
            this.bits1[n2] = this.bits1[n2] & (set.bits1[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    private long getW(int i) {
        if (this.bits1 == null) {
            return this.bits0;
        }
        return this.bits1[i];
    }

    private void setW(int i, long w) {
        if (this.bits1 == null) {
            this.bits0 = w;
        } else {
            this.bits1[i] = w;
        }
    }

    private void andW(int i, long w) {
        if (this.bits1 == null) {
            this.bits0 &= w;
        } else {
            int n = i;
            this.bits1[n] = this.bits1[n] & w;
        }
    }

    private void orW(int i, long w) {
        if (this.bits1 == null) {
            this.bits0 |= w;
        } else {
            int n = i;
            this.bits1[n] = this.bits1[n] | w;
        }
    }

    private void xorW(int i, long w) {
        if (this.bits1 == null) {
            this.bits0 ^= w;
        } else {
            int n = i;
            this.bits1[n] = this.bits1[n] ^ w;
        }
    }

    public final void andNot(int from, BitVector set) {
        int n = Math.min(this.length(), set.length());
        int i = BitVector.subscript(from);
        if (i < n) {
            this.andW(i, (set.getW(i) ^ 0xFFFFFFFFFFFFFFFFL) & -1L << (from & 0x3F));
            ++i;
            while (i < n) {
                int n2 = i;
                this.bits1[n2] = this.bits1[n2] & (set.getW(i) ^ 0xFFFFFFFFFFFFFFFFL);
                ++i;
            }
        }
    }

    public final void andNotOr(int from, BitVector set1, BitVector set2) {
        int bitsLength = this.length();
        int set1Length = set1.length();
        int set2Length = set2.length();
        int n = Math.min(bitsLength, set1Length);
        int i = BitVector.subscript(from);
        if (i < n) {
            this.andW(i, set1.getW(i) & -1L << (from & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL | (i < set2Length ? set2.getW(i) : 0L));
            ++i;
            while (i < n) {
                int n2 = i;
                this.bits1[n2] = this.bits1[n2] & (set1.getW(i) ^ 0xFFFFFFFFFFFFFFFFL | (i < set2Length ? set2.getW(i) : 0L));
                ++i;
            }
        }
    }

    public final void andNotOr(BitVector set1, BitVector set2) {
        this.andNotOr(0, set1, set2);
    }

    public final void andNotAnd(BitVector set1, BitVector set2) {
        int n = Math.min(this.length(), Math.min(set1.length(), set2.length()));
        int i = 0;
        while (i < n) {
            this.andW(i, set1.getW(i) & set2.getW(i) ^ 0xFFFFFFFFFFFFFFFFL);
            ++i;
        }
    }

    public final void andNotAndOr(BitVector S1, BitVector S2, BitVector S3) {
        int bits2length;
        int n = this.length();
        int bits1length = S1.length();
        if (bits1length < n) {
            n = bits1length;
        }
        if ((bits2length = S2.length()) < n) {
            n = bits2length;
        }
        if (n <= 1) {
            this.andW(0, S1.getW(0) & S2.getW(0) ^ 0xFFFFFFFFFFFFFFFFL | S3.getW(0));
        } else {
            int bits3length = S3.length();
            if (bits3length > n) {
                bits3length = n;
            }
            int i = 0;
            while (i < bits3length) {
                int n2 = i;
                this.bits1[n2] = this.bits1[n2] & (S1.bits1[i] & S2.bits1[i] ^ 0xFFFFFFFFFFFFFFFFL | S3.getW(i));
                ++i;
            }
            int i2 = bits3length;
            while (i2 < n) {
                int n3 = i2;
                this.bits1[n3] = this.bits1[n3] & (S1.bits1[i2] & S2.bits1[i2] ^ 0xFFFFFFFFFFFFFFFFL);
                ++i2;
            }
        }
    }

    public final void or(BitVector set) {
        if (this == set) {
            return;
        }
        int setLength = set.nonZeroLength();
        if (setLength > 1) {
            this.ensureCapacity(BitVector.bitIndex(setLength - 1));
            int i = setLength;
            while (i-- > 0) {
                int n = i;
                this.bits1[n] = this.bits1[n] | set.bits1[i];
            }
        } else {
            this.orW(0, set.getW(0));
        }
    }

    public final void orNotIn(BitVector set1, BitVector set2) {
        if (this == set1) {
            return;
        }
        int set1Length = set1.nonZeroLength();
        int set2Length = set2.length();
        if (set1Length > 0) {
            this.ensureCapacity(BitVector.bitIndex(set1Length - 1));
        }
        int i = set1Length;
        while (i-- > 0) {
            if (i < set2Length) {
                this.orW(i, set1.getW(i) & (set2.getW(i) ^ 0xFFFFFFFFFFFFFFFFL));
                continue;
            }
            this.orW(i, set1.getW(i));
        }
    }

    public final void orAnd(BitVector set1, BitVector set2) {
        if (this == set1 || this == set2) {
            return;
        }
        int setLength = Math.min(set1.nonZeroLength(), set2.nonZeroLength());
        if (setLength > 0) {
            this.ensureCapacity(BitVector.bitIndex(setLength - 1));
        }
        int i = setLength;
        while (i-- > 0) {
            this.orW(i, set1.getW(i) & set2.getW(i));
        }
    }

    private int nonZeroLength() {
        if (this.bits1 == null) {
            return 1;
        }
        int n = this.bits1.length;
        while (n > 1 && this.bits1[n - 1] == 0L) {
            --n;
        }
        return n;
    }

    public final void xor(BitVector set) {
        int setLength = set.length();
        if (setLength > 0) {
            this.ensureCapacity(BitVector.bitIndex(setLength - 1));
        }
        int i = setLength;
        while (i-- > 0) {
            this.xorW(i, set.getW(i));
        }
    }

    public final int hashCode() {
        long h = 1234L;
        int i = this.length();
        while (--i >= 0) {
            h ^= this.getW(i) * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public final int size() {
        return this.length() << 6;
    }

    public final boolean equals(Object obj) {
        block6: {
            int n;
            int setLength;
            BitVector set;
            block5: {
                if (obj == null || !(obj instanceof BitVector)) {
                    return false;
                }
                if (this == obj) {
                    return true;
                }
                set = (BitVector)obj;
                int bitsLength = this.length();
                setLength = set.length();
                int i = n = Math.min(bitsLength, setLength);
                while (i-- > 0) {
                    if (this.getW(i) == set.getW(i)) continue;
                    return false;
                }
                if (bitsLength <= n) break block5;
                int i2 = bitsLength;
                while (i2-- > n) {
                    if (this.bits1[i2] == 0L) continue;
                    return false;
                }
                break block6;
            }
            if (setLength <= n) break block6;
            int i = setLength;
            while (i-- > n) {
                if (set.bits1[i] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public final Object clone() {
        BitVector result = null;
        try {
            result = (BitVector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("this shouldn't happen, since we are Cloneable");
        }
        if (this.bits1 == null) {
            result.bits0 = this.bits0;
        } else {
            int n = this.nonZeroLength();
            if (n <= 1) {
                result.bits0 = this.bits1[0];
            } else {
                result.bits1 = new long[n];
                System.arraycopy(this.bits1, 0, result.bits1, 0, n);
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Separator sep = new Separator(", ");
        buffer.append('{');
        int limit = this.size();
        int i = 0;
        while (i < limit) {
            if (this.get(i)) {
                buffer.append(sep).append(i);
            }
            ++i;
        }
        buffer.append('}');
        return buffer.toString();
    }

    public final int bitCount() {
        int cnt = 0;
        int bitsLength = this.length();
        int i = 0;
        while (i < bitsLength) {
            long chunk = this.getW(i);
            while (chunk != 0L) {
                chunk &= chunk - 1L;
                ++cnt;
            }
            ++i;
        }
        return cnt;
    }

    public final int bitCount(int n) {
        int cnt = 0;
        int maxChunk = BitVector.subscript(n);
        if (maxChunk >= this.length()) {
            return this.bitCount();
        }
        int i = 0;
        while (i < maxChunk) {
            long chunk = this.getW(i);
            while (chunk != 0L) {
                chunk &= chunk - 1L;
                ++cnt;
            }
            ++i;
        }
        long lastChunk = this.getW(maxChunk) & (1L << (n & 0x3F)) - 1L;
        while (lastChunk != 0L) {
            lastChunk &= lastChunk - 1L;
            ++cnt;
        }
        return cnt;
    }

    private static int chunkLowestSetBit(long chunk) {
        int bit = 0;
        if (((chunk &= -chunk) & 0xFFFFFFFF00000000L) != 0L) {
            bit += 32;
        }
        if ((chunk & 0xFFFF0000FFFF0000L) != 0L) {
            bit += 16;
        }
        if ((chunk & 0xFF00FF00FF00FF00L) != 0L) {
            bit += 8;
        }
        if ((chunk & 0xF0F0F0F0F0F0F0F0L) != 0L) {
            bit += 4;
        }
        if ((chunk & 0xCCCCCCCCCCCCCCCCL) != 0L) {
            bit += 2;
        }
        if ((chunk & 0xAAAAAAAAAAAAAAAAL) != 0L) {
            ++bit;
        }
        return bit;
    }

    public final int getLowestSetBit() {
        if (this.bits1 == null) {
            if (this.bits0 != 0L) {
                return BitVector.chunkLowestSetBit(this.bits0);
            }
        } else {
            int n = this.bits1.length;
            int i = 0;
            while (i < n) {
                long chunk = this.bits1[i];
                if (chunk != 0L) {
                    return (i << 6) + BitVector.chunkLowestSetBit(chunk);
                }
                ++i;
            }
        }
        return Integer.MIN_VALUE;
    }

    public final int getLowestClearedBit() {
        int n = this.length();
        int i = 0;
        while (i < n) {
            long chunk = this.getW(i);
            if (chunk != -1L) {
                return (i << 6) + BitVector.chunkLowestSetBit(chunk ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++i;
        }
        return i << 6;
    }

    public final int getLowestSetBit(int pos) {
        int n = this.length();
        int i = BitVector.subscript(pos);
        if (i >= n) {
            return Integer.MIN_VALUE;
        }
        long chunk = this.getW(i) & -1L << (pos & 0x3F);
        while (chunk == 0L) {
            if (++i >= n) {
                return Integer.MIN_VALUE;
            }
            chunk = this.bits1[i];
        }
        return (i << 6) + BitVector.chunkLowestSetBit(chunk);
    }

    public int getNextBit(int i) {
        return this.getLowestSetBit(i + 1);
    }

    public final int getLowestSetBitNotIn(BitVector set) {
        int n = this.length();
        int setLength = set.length();
        int i = 0;
        while (i < n) {
            long chunk = this.getW(i);
            if (i < setLength) {
                chunk &= set.getW(i) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (chunk != 0L) {
                return (i << 6) + BitVector.chunkLowestSetBit(chunk);
            }
            ++i;
        }
        return Integer.MIN_VALUE;
    }

    public final int getLowestSetBitAnd(BitVector set) {
        int n = this.length();
        int setLength = set.length();
        int result = 0;
        int i = 0;
        while (i < n) {
            long chunk = this.getW(i);
            if (i >= setLength) {
                return Integer.MIN_VALUE;
            }
            if ((chunk &= set.getW(i)) != 0L) {
                return result + BitVector.chunkLowestSetBit(chunk);
            }
            result += 64;
            ++i;
        }
        return Integer.MIN_VALUE;
    }

    public final int getLowestSetBitAndNotIn(BitVector set, BitVector exclude) {
        int n = this.length();
        int setLength = set.length();
        int excludeLength = exclude.length();
        int result = 0;
        int i = 0;
        while (i < n) {
            long chunk = this.getW(i);
            if (i < setLength) {
                chunk &= set.getW(i);
            } else {
                return Integer.MIN_VALUE;
            }
            if (i < excludeLength) {
                chunk &= exclude.getW(i) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (chunk != 0L) {
                return result + BitVector.chunkLowestSetBit(chunk);
            }
            result += 64;
            ++i;
        }
        return Integer.MIN_VALUE;
    }

    public final boolean includedIn(BitVector set) {
        int setLength;
        if (this == set) {
            return true;
        }
        int bitsLength = this.nonZeroLength();
        if (bitsLength > (setLength = set.nonZeroLength())) {
            return false;
        }
        int i = 0;
        while (i < bitsLength) {
            if ((this.getW(i) & (set.getW(i) ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final void clearAll() {
        this.bits0 = 0L;
        this.bits1 = null;
    }

    public boolean isEmpty() {
        int n = this.length();
        int i = 0;
        while (i < n) {
            if (this.getW(i) != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final void bitCopy(int src, int dest) {
        if (this.get(src)) {
            this.set(dest);
            this.clear(src);
        } else {
            this.clear(dest);
        }
    }

    public final void bitMerge(int src, int dest) {
        if (this.get(src)) {
            this.set(dest);
        }
    }

    public final void truncate(int newSize) {
        int newlength;
        int i = BitVector.subscript(newSize);
        if (this.bits1 == null) {
            if (i == 0) {
                this.bits0 &= (1L << (newSize & 0x3F)) - 1L;
            }
            return;
        }
        int bitsLength = this.nonZeroLength();
        if (i < bitsLength) {
            this.andW(i, (1L << (newSize & 0x3F)) - 1L);
        }
        if ((newlength = Math.min(bitsLength, i + 1)) < this.bits1.length) {
            long[] newBits = new long[newlength];
            System.arraycopy(this.bits1, 0, newBits, 0, newlength);
            this.bits1 = newBits;
        }
    }

    public final void fill(int n) {
        this.ensureCapacity(n - 1);
        int maxChunk = BitVector.subscript(n);
        int i = 0;
        while (i < maxChunk) {
            this.setW(i, -1L);
            ++i;
        }
        if (maxChunk < this.length()) {
            this.orW(maxChunk, (1L << (n & 0x3F)) - 1L);
        }
    }

    public final void fillNot(int n) {
        int maxChunk = BitVector.subscript(n);
        if (maxChunk >= this.length()) {
            this.clearAll();
        } else {
            int i = 0;
            while (i < maxChunk) {
                this.setW(i, 0L);
                ++i;
            }
            this.andW(maxChunk, -1L << (n & 0x3F));
        }
    }

    public final void addProduct(BitMatrix M, BitVector v) {
        int n = M.size();
        int i = v.getLowestSetBit();
        while (i >= 0) {
            this.or(M.getRow(i));
            i = v.getLowestSetBit(i + 1);
        }
    }

    public final void slowaddProduct(BitMatrix M, BitVector v) {
        int n = M.size();
        int i = 0;
        while (i < n) {
            if (v.get(i)) {
                this.or(M.getRow(i));
            }
            ++i;
        }
    }
}

