/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import bossa.syntax.MonoSymbol;
import bossa.util.Internal;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.ConstructorExp;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.expr.ThisExp;
import gnu.mapping.Procedure;
import nice.lang.inline.BoolNotOp;
import nice.lang.inline.CompOp;
import nice.lang.inline.Instanceof;
import nice.lang.inline.ReferenceOp;
import nice.lang.inline.Return;
import nice.lang.inline.ShortCircuitOp;
import nice.tools.code.GetFieldProc;
import nice.tools.code.Inline;
import nice.tools.code.IsOfClassProc;
import nice.tools.code.Strings;

public class Gen {
    private static final Expression equals = new QuoteExp(new PrimProcedure(Type.pointer_type.getDeclaredMethod("equals", 1)));

    public static Expression instanceOfExp(Expression value, Type ct) {
        return Inline.inline(Instanceof.instance, value, new QuoteExp(ct));
    }

    public static Expression isOfClass(Expression value, Type ct) {
        return Inline.inline(new IsOfClassProc(ct), value);
    }

    public static Expression isNullExp(Expression value) {
        return Inline.inline(ReferenceOp.create("=="), value, QuoteExp.nullExp);
    }

    public static Expression referenceEqualsExp(Expression value1, Expression value2) {
        return Inline.inline(ReferenceOp.create("=="), value1, value2);
    }

    public static Expression boolNotExp(Expression value) {
        return Inline.inline(BoolNotOp.instance, value);
    }

    public static Expression integerComparison(String kind, Expression value1, long value2) {
        char type = value1.getType().getSignature().charAt(0);
        if (type == 'J') {
            return Inline.inline(CompOp.create("l" + kind), value1, new QuoteExp(new Long(value2), Type.long_type));
        }
        if (type == 'B' || type == 'S' || type == 'I' || type == 'C') {
            return Inline.inline(CompOp.create("i" + kind), value1, new QuoteExp(new Long(value2), Type.int_type));
        }
        throw Internal.error("not an integer type");
    }

    public static Expression shortCircuitAnd(Expression value1, Expression value2) {
        return Inline.inline(ShortCircuitOp.create("&&"), value1, value2);
    }

    public static Expression stringEquals(String value1, Expression value2) {
        return new ApplyExp(equals, new Expression[]{new QuoteExp(value1, Type.string_type), value2});
    }

    public static LambdaExp createMethod(String bytecodeName, Type[] argTypes, Type retType, MonoSymbol[] args) {
        return Gen.createMethod(bytecodeName, argTypes, retType, args, true, false);
    }

    public static LambdaExp createMethod(String bytecodeName, Type[] argTypes, Type retType, MonoSymbol[] args, boolean toplevel) {
        return Gen.createMethod(bytecodeName, argTypes, retType, args, toplevel, false);
    }

    public static LambdaExp createMethod(String bytecodeName, Type[] argTypes, Type retType, MonoSymbol[] args, boolean toplevel, boolean member) {
        LambdaExp res = new LambdaExp();
        Gen.createMethod(res, bytecodeName, argTypes, retType, args, toplevel, member, false);
        return res;
    }

    public static ConstructorExp createConstructor(Declaration thisDecl, Type[] argTypes, MonoSymbol[] args) {
        ConstructorExp res = new ConstructorExp(thisDecl);
        Gen.createMethod(res, "<init>", argTypes, Type.void_type, args, true, false, true);
        return res;
    }

    public static ConstructorExp createCustomConstructor(ClassType classType, Type[] argTypes, MonoSymbol[] args) {
        ConstructorExp res = new ConstructorExp(classType);
        Gen.createMethod(res, "<init>", argTypes, Type.void_type, args, true, false, true);
        return res;
    }

    private static void createMethod(LambdaExp lexp, String bytecodeName, Type[] argTypes, Type retType, MonoSymbol[] args, boolean toplevel, boolean member, boolean constructor) {
        bytecodeName = Strings.escape(bytecodeName);
        int arity = args == null ? 0 : args.length;
        lexp.setReturnType(retType);
        lexp.setName(bytecodeName);
        lexp.max_args = member ? arity - 1 : arity;
        lexp.min_args = lexp.max_args;
        lexp.forceGeneration();
        if (toplevel) {
            lexp.setCanCall(true);
        }
        if (member) {
            lexp.setClassMethod(true);
        }
        int n = 0;
        while (n < arity) {
            boolean isThis = member && n == 0;
            String parameterName = args[n].getName() == null ? "anonymous_" + n : args[n].getName().toString();
            Declaration d = isThis ? new Declaration(parameterName) : lexp.addDeclaration(parameterName);
            if (argTypes != null) {
                d.setType(argTypes[n]);
            }
            d.noteValue(null);
            args[n].setDeclaration(d, isThis);
            ++n;
        }
    }

    public static LambdaExp createMemberMethod(String bytecodeName, Type receiver, Type[] argTypes, Type retType, Expression[] params) {
        LambdaExp lexp = new LambdaExp();
        bytecodeName = Strings.escape(bytecodeName);
        int arity = 1 + (argTypes == null ? 0 : argTypes.length);
        lexp.setReturnType(retType);
        lexp.setName(bytecodeName);
        lexp.min_args = lexp.max_args = arity - 1;
        lexp.forceGeneration();
        lexp.setCanCall(true);
        lexp.setClassMethod(true);
        int n = 0;
        while (n < arity) {
            Declaration d;
            boolean isThis = n == 0;
            String parameterName = "anonymous_" + n;
            if (isThis) {
                d = new Declaration(parameterName);
                d.context = lexp;
                d.setType(receiver);
                params[n] = new ThisExp(d);
            } else {
                d = lexp.addDeclaration(parameterName);
                d.setType(argTypes[n - 1]);
                params[n] = new ReferenceExp(d);
            }
            d.noteValue(null);
            d.setCanRead(true);
            d.setCanWrite(true);
            ++n;
        }
        return lexp;
    }

    public static void setMethodBody(LambdaExp method, Expression body) {
        method.body = body;
    }

    public static ReferenceExp referenceTo(LambdaExp lambda) {
        Declaration decl = new Declaration(lambda.getName());
        decl.noteValue(lambda);
        decl.setFlag(18432);
        decl.setProcedureDecl(true);
        return new ReferenceExp(decl);
    }

    public static LambdaExp dereference(Expression ref) {
        return (LambdaExp)((ReferenceExp)ref).getBinding().getValue();
    }

    public static Expression returnVoid() {
        return Inline.inline(Return.instance);
    }

    public static Expression returnValue(Expression value) {
        return Inline.inline(Return.instance, value);
    }

    public static void store(Compilation comp, Expression destination, Target target) {
        if (destination instanceof ReferenceExp) {
            ((ReferenceExp)destination).getBinding().compileStore(comp);
            return;
        }
        CodeAttr code = comp.getCode();
        ApplyExp apply = (ApplyExp)destination;
        GetFieldProc fieldProc = (GetFieldProc)((QuoteExp)apply.getFunction()).getValue();
        Field field = fieldProc.getField();
        apply.getArgs()[0].compile(comp, field.getDeclaringClass());
        code.emitSwap();
        code.emitPutField(field);
    }

    public static LambdaExp wrapInLambda(Procedure proc) {
        int numArgs = proc.minArgs();
        LambdaExp lambda = new LambdaExp();
        lambda.min_args = lambda.max_args = numArgs;
        Expression[] args = new Expression[numArgs];
        int i = 0;
        while (i < numArgs) {
            Declaration decl = lambda.addDeclaration("param__" + i, Type.pointer_type);
            args[i] = new ReferenceExp(decl);
            ++i;
        }
        lambda.body = new ApplyExp(proc, args);
        return lambda;
    }
}

