/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import bossa.modules.Package;
import bossa.util.Internal;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.ParameterizedType;
import gnu.bytecode.Type;
import gnu.bytecode.TypeVariable;
import java.util.HashSet;
import mlsub.typing.Constraint;
import mlsub.typing.FunType;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeVar;
import mlsub.typing.Polytype;
import mlsub.typing.TypeSymbol;
import nice.tools.code.Types;

public class Import {
    private static HashSet strictPackages = new HashSet();

    public static Polytype type(Method m) {
        boolean constructor = m.isConstructor();
        ClassType declaringClass = m.getDeclaringClass();
        Type[] paramTypes = m.getFullParameterTypes();
        TypeVariable[] methodTypeParameters = m.getTypeParameters();
        TypeVariable[] typeParameters = null;
        TypeSymbol[] niceTP = null;
        if (m.getStaticFlag()) {
            if (methodTypeParameters != null) {
                typeParameters = new TypeVariable[methodTypeParameters.length];
                int i = methodTypeParameters.length;
                while (--i >= 0) {
                    typeParameters[i] = methodTypeParameters[i];
                }
                niceTP = Import.makeTP(typeParameters);
            }
        } else {
            TypeVariable[] classTypeParameters = declaringClass.getParameters();
            int nParams = classTypeParameters == null ? 0 : classTypeParameters.length;
            if ((nParams += methodTypeParameters == null ? 0 : methodTypeParameters.length) > 0) {
                typeParameters = new TypeVariable[nParams];
                if (methodTypeParameters != null) {
                    int i = methodTypeParameters.length;
                    while (--i >= 0) {
                        typeParameters[--nParams] = methodTypeParameters[i];
                    }
                }
                if (classTypeParameters != null) {
                    int i = classTypeParameters.length;
                    while (--i >= 0) {
                        typeParameters[--nParams] = classTypeParameters[i];
                    }
                }
                niceTP = Import.makeTP(typeParameters);
            }
        }
        int n = 0;
        try {
            Monotype retType;
            int i;
            Monotype[] params;
            if (m.getStaticFlag() || constructor) {
                params = new Monotype[paramTypes.length];
            } else {
                params = new Monotype[paramTypes.length + 1];
                params[n++] = Types.monotype(declaringClass.thisType(), true, typeParameters, niceTP);
            }
            boolean strictImport = Package.currentCompilation.strictJavaTypes;
            boolean nonNullArgs = strictPackages.contains(m.getDeclaringClass().getPackageName());
            if (strictImport || nonNullArgs) {
                i = 0;
                while (i < paramTypes.length) {
                    params[n++] = Types.monotype(paramTypes[i], true, typeParameters, niceTP, true);
                    ++i;
                }
            } else {
                i = 0;
                while (i < paramTypes.length) {
                    params[n++] = Types.monotype(paramTypes[i], false, typeParameters, niceTP, true);
                    ++i;
                }
            }
            if (constructor) {
                retType = Types.monotype(declaringClass.thisType(), true, typeParameters, niceTP);
            } else if (strictImport) {
                Type returnType = m.getFullReturnType();
                if (m.getStaticFlag()) {
                    retType = Types.monotype(returnType, true, typeParameters, niceTP, true);
                } else {
                    Type classType = declaringClass.thisType();
                    retType = returnType.getName() != null && returnType.getName().equals(classType.getName()) ? Types.monotype(returnType, true, typeParameters, niceTP) : (returnType instanceof ParameterizedType && classType instanceof ParameterizedType && ((ParameterizedType)returnType).main.getName() != null && ((ParameterizedType)returnType).main.getName().equals(((ParameterizedType)classType).main.getName()) ? Types.monotype(returnType, true, typeParameters, niceTP) : (returnType instanceof ArrayType ? Types.monotype(returnType, true, typeParameters, niceTP, true) : Types.monotype(returnType, typeParameters, niceTP)));
                }
            } else {
                retType = Types.monotype(m.getFullReturnType(), true, typeParameters, niceTP, true);
            }
            Constraint cst = niceTP == null ? null : new Constraint(niceTP, null);
            return new Polytype(cst, new FunType(params, retType));
        }
        catch (Types.ParametricClassException e) {
            Internal.warning("Java method " + m + " was ignored.\nReason: " + e);
            return null;
        }
        catch (Types.NotIntroducedClassException e) {
            Internal.warning("Java method " + m + " was ignored.\nReason: " + e);
            return null;
        }
    }

    private static TypeSymbol[] makeTP(TypeVariable[] vars) {
        TypeSymbol[] res = new TypeSymbol[vars.length];
        int i = 0;
        while (i < vars.length) {
            res[i] = new MonotypeVar(vars[i].getName());
            ++i;
        }
        return res;
    }

    static void reset() {
        strictPackages.clear();
    }

    public static void addStrictPackage(String name) {
        strictPackages.add(name);
    }
}

