/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import bossa.syntax.LocatedString;
import bossa.syntax.Monotype;
import bossa.syntax.Node;
import bossa.syntax.PrimitiveType;
import bossa.util.Internal;
import bossa.util.Location;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ObjectType;
import gnu.bytecode.ParameterizedType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.TypeVariable;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import java.util.HashMap;
import mlsub.typing.BadSizeEx;
import mlsub.typing.Constraint;
import mlsub.typing.FunType;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeVar;
import mlsub.typing.NullnessKind;
import mlsub.typing.Polytype;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Import;
import nice.tools.code.SpecialArray;
import nice.tools.code.SpecialTypes;
import nice.tools.code.TupleType;
import nice.tools.code.TypeImport;

public final class Types {
    private static HashMap tcToGBType;
    private static Expression zeroInt;
    private static Expression zeroFloat;
    private static Expression zeroChar;

    public static void set(TypeConstructor tc, Type type) {
        tcToGBType.put(tc, type);
    }

    private static void set(mlsub.typing.Monotype m, Type type) {
        tcToGBType.put(m, type);
    }

    public static Type get(TypeConstructor tc) {
        return (Type)tcToGBType.get(tc);
    }

    public static Type get(mlsub.typing.Monotype m) {
        return (Type)tcToGBType.get(m);
    }

    public static Type javaType(TypeConstructor tc) {
        Type res = Types.get(tc);
        if (res == null) {
            return Type.pointer_type;
        }
        return res;
    }

    public static void setBytecodeType(mlsub.typing.Monotype m) {
        TypeConstructor rigidTC;
        TypeConstructor tc;
        if ((m = Types.equivalent(m)) instanceof mlsub.typing.TupleType) {
            Types.setBytecodeType(((mlsub.typing.TupleType)m).getComponents());
        }
        if ((tc = m.head()) == null) {
            return;
        }
        if (tc == PrimitiveType.arrayTC) {
            rigidTC = tc;
        } else {
            if (Types.get(tc) != null) {
                return;
            }
            rigidTC = Typing.lowestInstance(tc);
            if (rigidTC == null) {
                return;
            }
        }
        if (rigidTC == PrimitiveType.arrayTC) {
            mlsub.typing.Monotype param = ((MonotypeConstructor)m).getTP()[0];
            Types.setBytecodeType(param);
            Types.set(m, (Type)SpecialTypes.array(Types.javaTypeOrNull(param)));
        } else {
            Types.set(tc, Types.get(rigidTC));
        }
    }

    public static void setBytecodeType(mlsub.typing.Monotype[] ms) {
        int i = 0;
        while (i < ms.length) {
            Types.setBytecodeType(ms[i]);
            ++i;
        }
    }

    /*
     * Loose catch block
     */
    public static void setBytecodeType(Polytype t) {
        block8: {
            block9: {
                Constraint cst = t.getConstraint();
                if (!Constraint.hasBinders(cst)) break block9;
                Typing.enter();
                Constraint.enter(cst);
                Types.setBytecodeType(t.getMonotype());
                Object var4_2 = null;
                try {
                    Typing.leave();
                }
                catch (TypingEx e2) {}
                break block8;
                {
                    catch (TypingEx e) {
                        Object var4_3 = null;
                        try {
                            Typing.leave();
                        }
                        catch (TypingEx e2) {}
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    try {
                        Typing.leave();
                    }
                    catch (TypingEx e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            Types.setBytecodeType(t.getMonotype());
        }
    }

    public static Type javaType(mlsub.typing.Monotype m) {
        Type res = Types.javaTypeOrNull(m);
        if (res != null) {
            return res;
        }
        return Type.pointer_type;
    }

    private static Type javaTypeOrNull(mlsub.typing.Monotype m) {
        Type res = Types.rawJavaType(Types.equivalent(m));
        if (res == null) {
            return null;
        }
        boolean maybe = Types.isMaybe(m.equivalent());
        if (maybe) {
            return Types.equivalentObjectType(res);
        }
        return res;
    }

    private static Type rawJavaType(mlsub.typing.Monotype m) {
        Type res = Types.get(m);
        if (res != null) {
            return res;
        }
        if (m instanceof mlsub.typing.TupleType) {
            return new TupleType(Types.javaType(((mlsub.typing.TupleType)m).getComponents()));
        }
        if (m instanceof FunType) {
            return Compilation.typeProcedure;
        }
        if (m == TopMonotype.instance) {
            return Type.pointer_type;
        }
        if (!(m instanceof MonotypeConstructor)) {
            return null;
        }
        MonotypeConstructor mc = (MonotypeConstructor)m;
        TypeConstructor tc = mc.getTC();
        if (tc == PrimitiveType.arrayTC) {
            return SpecialTypes.array(Types.javaTypeOrNull(mc.getTP()[0]));
        }
        return Types.javaType(tc);
    }

    public static Type[] javaType(mlsub.typing.Monotype[] ms) {
        if (ms == null) {
            return null;
        }
        Type[] res = new Type[ms.length];
        int i = 0;
        while (i < ms.length) {
            res[i] = Types.javaType(ms[i]);
            ++i;
        }
        return res;
    }

    public static Type javaType(Polytype t) {
        return Types.javaType(t.getMonotype());
    }

    public static Type lowestCommonSupertype(mlsub.typing.Monotype[] types) {
        Type res = Types.javaType(types[0]);
        int i = 1;
        while (res != null && i < types.length) {
            res = Type.lowestCommonSuperType(res, Types.javaType(types[i]));
            ++i;
        }
        if (res == null) {
            return Type.pointer_type;
        }
        return res;
    }

    static Type lowestCommonSupertype(Type[] types) {
        Type res = types[0];
        int i = 1;
        while (res != null && i < types.length) {
            res = Type.lowestCommonSuperType(res, types[i]);
            ++i;
        }
        if (res == null) {
            return Type.pointer_type;
        }
        return res;
    }

    public static Type lowestUpperBound(Expression[] exps) {
        if (exps.length == 0) {
            return Type.pointer_type;
        }
        Type res = Type.neverReturnsType;
        int i = 0;
        while (i < exps.length) {
            if ((res = Type.lowestCommonSuperType(res, exps[i].getType())) == null) {
                return Type.pointer_type;
            }
            ++i;
        }
        return res;
    }

    public static Type componentType(ArrayType type, int rank) {
        if (type instanceof TupleType) {
            return ((TupleType)type).componentTypes[rank];
        }
        return type.getComponentType();
    }

    public static TypeConstructor typeConstructor(Type javaType) throws NotIntroducedClassException {
        TypeConstructor tc = Node.getGlobalTypeScope().globalLookup(javaType.getName(), null);
        if (tc == null) {
            Internal.warning(javaType + " is not known");
            throw new NotIntroducedClassException(tc);
        }
        if (tc.getId() == -1) {
            throw new NotIntroducedClassException(tc);
        }
        return tc;
    }

    public static mlsub.typing.Monotype[] monotype(Type[] javaTypes, TypeVariable[] typeVariables, TypeSymbol[] niceTypeVariables) throws ParametricClassException, NotIntroducedClassException {
        int len = javaTypes.length;
        mlsub.typing.Monotype[] res = new mlsub.typing.Monotype[len];
        int i = 0;
        while (i < len) {
            res[i] = Types.monotype(javaTypes[i], typeVariables, niceTypeVariables);
            ++i;
        }
        return res;
    }

    public static mlsub.typing.Monotype monotype(Type javaType, boolean sure) throws ParametricClassException, NotIntroducedClassException {
        return Types.monotype(javaType, sure, null, null);
    }

    public static mlsub.typing.Monotype monotype(Type javaType, boolean sure, TypeVariable[] typeVariables, TypeSymbol[] niceTypeVariables) throws ParametricClassException, NotIntroducedClassException {
        return Types.monotype(javaType, sure, typeVariables, niceTypeVariables, false);
    }

    public static mlsub.typing.Monotype monotype(Type javaType) throws ParametricClassException, NotIntroducedClassException {
        return Types.monotype(javaType, null, null);
    }

    public static mlsub.typing.Monotype monotype(Type javaType, TypeVariable[] typeVariables, TypeSymbol[] niceTypeVariables) throws ParametricClassException, NotIntroducedClassException {
        mlsub.typing.Monotype res = Types.getMonotype(javaType, typeVariables, niceTypeVariables);
        if (javaType instanceof ObjectType && !(javaType instanceof TypeVariable)) {
            return Monotype.maybe(res);
        }
        return res;
    }

    public static mlsub.typing.Monotype monotype(Type javaType, boolean sure, TypeVariable[] typeVariables, TypeSymbol[] niceTypeVariables, boolean arraySure) throws ParametricClassException, NotIntroducedClassException {
        mlsub.typing.Monotype res = Types.getMonotype(javaType, typeVariables, niceTypeVariables, arraySure);
        if (javaType instanceof ObjectType && !(javaType instanceof TypeVariable)) {
            if (sure) {
                return Monotype.sure(res);
            }
            return Monotype.maybe(res);
        }
        return res;
    }

    private static mlsub.typing.Monotype getMonotype(Type javaType, TypeVariable[] typeVariables, TypeSymbol[] niceTypeVariables) throws ParametricClassException, NotIntroducedClassException {
        return Types.getMonotype(javaType, typeVariables, niceTypeVariables, false);
    }

    private static mlsub.typing.Monotype getMonotype(Type javaType, TypeVariable[] typeVariables, TypeSymbol[] niceTypeVariables, boolean arraySure) throws ParametricClassException, NotIntroducedClassException {
        if (javaType.isVoid()) {
            return PrimitiveType.voidType;
        }
        if (javaType == SpecialTypes.intType) {
            return PrimitiveType.intType;
        }
        if (javaType == SpecialTypes.booleanType) {
            return PrimitiveType.boolType;
        }
        if (javaType == SpecialTypes.charType) {
            return PrimitiveType.charType;
        }
        if (javaType == SpecialTypes.byteType) {
            return PrimitiveType.byteType;
        }
        if (javaType == SpecialTypes.shortType) {
            return PrimitiveType.shortType;
        }
        if (javaType == SpecialTypes.longType) {
            return PrimitiveType.longType;
        }
        if (javaType == SpecialTypes.floatType) {
            return PrimitiveType.floatType;
        }
        if (javaType == SpecialTypes.doubleType) {
            return PrimitiveType.doubleType;
        }
        if (javaType instanceof ArrayType) {
            if (arraySure) {
                return new MonotypeConstructor(PrimitiveType.arrayTC, new mlsub.typing.Monotype[]{Types.monotype(((ArrayType)javaType).getComponentType(), true, typeVariables, niceTypeVariables, true)});
            }
            return new MonotypeConstructor(PrimitiveType.arrayTC, new mlsub.typing.Monotype[]{Types.monotype(((ArrayType)javaType).getComponentType(), typeVariables, niceTypeVariables)});
        }
        if (javaType instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)javaType;
            try {
                return new MonotypeConstructor(Types.typeConstructor(p.main), Types.monotype(p.parameters, typeVariables, niceTypeVariables));
            }
            catch (BadSizeEx ex) {
                throw new ParametricClassException(javaType.toString());
            }
        }
        if (javaType instanceof TypeVariable) {
            if (typeVariables != null) {
                int i = 0;
                while (i < typeVariables.length) {
                    if (typeVariables[i] == javaType) {
                        return (mlsub.typing.Monotype)((Object)niceTypeVariables[i]);
                    }
                    ++i;
                }
            }
            Internal.warning("Type variable " + javaType.getName() + " is not known");
            throw new NotIntroducedClassException(null);
        }
        if (javaType == Type.pointer_type) {
            return TopMonotype.instance;
        }
        return Types.getMonotype(javaType.getName());
    }

    private static mlsub.typing.Monotype getMonotype(String name) throws ParametricClassException, NotIntroducedClassException {
        if (name.endsWith("[]")) {
            name = name.substring(0, name.length() - 2);
            return new MonotypeConstructor(PrimitiveType.arrayTC, new mlsub.typing.Monotype[]{Types.getMonotype(name)});
        }
        TypeConstructor tc = Node.getGlobalTypeScope().globalLookup(name, null);
        if (tc == null) {
            Internal.warning(name + " is not known");
            throw new NotIntroducedClassException(tc);
        }
        if (tc.variance != null && tc.arity() != 0) {
            throw new ParametricClassException(tc.toString());
        }
        if (tc.getId() == -1) {
            throw new NotIntroducedClassException(tc);
        }
        return new MonotypeConstructor(tc, null);
    }

    public static final Type type(LocatedString name) {
        return Types.type(name.toString(), name.location());
    }

    public static final Type type(String s, Location loc) {
        if (s.length() == 0) {
            return null;
        }
        if (s.charAt(0) == '[') {
            Type res = Types.type(s.substring(1), loc);
            if (res == null) {
                return null;
            }
            return SpecialArray.create(res);
        }
        if (s.equals("void")) {
            return SpecialTypes.voidType;
        }
        if (s.equals("boolean")) {
            return SpecialTypes.booleanType;
        }
        if (s.equals("byte")) {
            return SpecialTypes.byteType;
        }
        if (s.equals("short")) {
            return SpecialTypes.shortType;
        }
        if (s.equals("int")) {
            return SpecialTypes.intType;
        }
        if (s.equals("long")) {
            return SpecialTypes.longType;
        }
        if (s.equals("char")) {
            return SpecialTypes.charType;
        }
        if (s.equals("float")) {
            return SpecialTypes.floatType;
        }
        if (s.equals("double")) {
            return SpecialTypes.doubleType;
        }
        return TypeImport.lookup(s, loc);
    }

    public static final Type typeRepresentationToBytecode(String type, Location loc) {
        if (type.charAt(0) == '[') {
            Type res = Types.typeRepresentationToBytecode(type.substring(1), loc);
            if (res == null) {
                return null;
            }
            return SpecialArray.create(res);
        }
        TypeConstructor sym = Node.getGlobalTypeScope().globalLookup(type, loc);
        return Types.get(sym);
    }

    public static Type equivalentObjectType(Type t) {
        if (t instanceof ObjectType) {
            return (ObjectType)t;
        }
        if (t == Type.boolean_type) {
            return Type.boolean_ctype;
        }
        if (t == Type.double_type || t == Type.float_type || t == Type.long_type || t == Type.int_type || t == Type.short_type || t == Type.byte_type) {
            return Type.number_type;
        }
        if (t == Type.char_type) {
            return Type.char_ctype;
        }
        if (t == Type.void_type) {
            return Type.void_type;
        }
        Internal.error("Equivalent type for " + t + " is not defined yet");
        return null;
    }

    public static Expression defaultValue(mlsub.typing.Monotype m) {
        if (!(m instanceof MonotypeConstructor)) {
            return QuoteExp.nullExp;
        }
        TypeConstructor tc = Types.rawType(m).head();
        if (tc == null) {
            return QuoteExp.nullExp;
        }
        if (tc == PrimitiveType.intTC || tc == PrimitiveType.byteTC || tc == PrimitiveType.shortTC || tc == PrimitiveType.longTC) {
            return zeroInt;
        }
        if (tc == PrimitiveType.floatTC || tc == PrimitiveType.doubleTC) {
            return zeroFloat;
        }
        if (tc == PrimitiveType.boolTC) {
            return QuoteExp.falseExp;
        }
        if (tc == PrimitiveType.charTC) {
            return zeroChar;
        }
        return QuoteExp.nullExp;
    }

    public static boolean isVoid(mlsub.typing.Monotype m) {
        return Types.equivalent(m).head() == PrimitiveType.voidTC;
    }

    public static boolean isVoid(Polytype t) {
        return Types.isVoid(t.getMonotype());
    }

    public static boolean isPrimitive(TypeConstructor tc) {
        return Types.javaType(tc) instanceof PrimType;
    }

    public static boolean isMaybe(mlsub.typing.Monotype m) {
        return m instanceof MonotypeConstructor && ((MonotypeConstructor)m).getTC() == PrimitiveType.maybeTC;
    }

    public static boolean isSure(mlsub.typing.Monotype m) {
        return m instanceof MonotypeConstructor && ((MonotypeConstructor)m).getTC() == PrimitiveType.sureTC;
    }

    public static mlsub.typing.Monotype equivalent(mlsub.typing.Monotype m) {
        return Types.rawType(m).equivalent();
    }

    public static void setMarkedKind(mlsub.typing.Monotype m) {
        m.setKind(NullnessKind.instance);
    }

    public static void makeMarkedType(MonotypeVar m) {
        m.setPersistentKind(NullnessKind.instance);
    }

    public static mlsub.typing.Monotype rawType(mlsub.typing.Monotype m) {
        if (!((m = m.equivalent()) instanceof MonotypeConstructor)) {
            return m;
        }
        return ((MonotypeConstructor)m).getTP()[0];
    }

    public static mlsub.typing.Monotype rawType(MonotypeConstructor mc) {
        return mc.getTP()[0];
    }

    public static mlsub.typing.Monotype[] domain(mlsub.typing.Monotype type) {
        return Types.rawType(type).domain();
    }

    public static mlsub.typing.Monotype[] domain(Polytype type) {
        return Types.rawType(type.getMonotype()).domain();
    }

    public static mlsub.typing.Monotype codomain(Polytype type) {
        return ((FunType)Types.rawType(type.getMonotype())).codomain();
    }

    public static mlsub.typing.Monotype getTypeParameter(Polytype type, int rank) {
        type.simplify();
        return Types.getTypeParameter(type.getMonotype(), rank);
    }

    public static mlsub.typing.Monotype getTypeParameter(mlsub.typing.Monotype type, int rank) {
        if (!((type = Types.rawType(type)) instanceof MonotypeConstructor)) {
            return null;
        }
        mlsub.typing.Monotype[] parameters = ((MonotypeConstructor)type).getTP();
        if (parameters.length <= rank) {
            return null;
        }
        return parameters[rank];
    }

    public static Polytype addSure(Polytype type) {
        return new Polytype(type.getConstraint(), Monotype.sure(type.getMonotype()));
    }

    public static void reset() {
        tcToGBType = new HashMap();
        TypeImport.stringToReflectClass = new HashMap();
        Import.reset();
    }

    static {
        zeroInt = new QuoteExp(new Integer(0));
        zeroFloat = new QuoteExp(new Float(0.0));
        zeroChar = new QuoteExp(new Character('\u0000'));
    }

    public static class NotIntroducedClassException
    extends Exception {
        public TypeSymbol symbol;

        NotIntroducedClassException(TypeSymbol symbol) {
            this.symbol = symbol;
        }
    }

    public static class ParametricClassException
    extends Exception {
        ParametricClassException(String message) {
            super(message);
        }
    }
}

