/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.compiler;

import bossa.modules.Compilation;
import bossa.modules.Exit;
import bossa.modules.Package;
import bossa.util.Internal;
import bossa.util.Location;
import bossa.util.UserError;
import gnu.mapping.WrongType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.List;
import nice.tools.code.TypeImport;
import nice.tools.compiler.StatusCodeListener;
import nice.tools.compiler.dispatch;

public class fun {
    public static final String versionNumber = "0.9.6";
    public static final String buildDate = "2004.02.23, 14:52:08 UTC";
    public static final String javaVersion = "1.4.2_02";
    public static final int OK = 0;
    public static final int BUG = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 3;

    public static boolean worse(int status, int than) {
        if (than == OK) {
            return true;
        }
        if (than == BUG) {
            return false;
        }
        if (than == ERROR) {
            return false;
        }
        if (than == WARNING) {
            return status == BUG || status == ERROR;
        }
        return false;
    }

    public static void setStatusCode(StatusCodeListener this_, int status) {
        if (dispatch.worse(status, this_.statusCode)) {
            this_.statusCode = status;
        }
    }

    public static void bug(StatusCodeListener this_, String stackTrace, String url) {
        dispatch.setStatusCode(this_, BUG);
    }

    public static void error(StatusCodeListener this_, Location location, String message) {
        dispatch.setStatusCode(this_, ERROR);
    }

    public static void warning(StatusCodeListener this_, Location location, String message) {
        dispatch.setStatusCode(this_, WARNING);
    }

    public static List load(Compilation compilation, String mainPackage) {
        Throwable uncaughtException = null;
        try {
            Package.currentCompilation = compilation;
            if (compilation.runtimeFile == null) {
                compilation.runtimeFile = dispatch.getNiceRuntime();
            }
            TypeImport.setRuntime(compilation.runtimeFile);
            bossa.modules.dispatch.setMainPackage(compilation, mainPackage);
            return nice.lang.dispatch.flatten(mlsub.compilation.dispatch.load(compilation));
        }
        catch (UserError e) {
            String string;
            Internal.warning("user error only caught in main");
            try {
                string = (String)nice.lang.dispatch.notNull(e.message);
            }
            catch (ClassCastException classCastException) {
                throw WrongType.make(classCastException, "nice.tools.code.EnsureTypeProc", -3);
            }
            compilation.listener.error(e.location, string);
        }
        catch (ExceptionInInitializerError e) {
            uncaughtException = e.getException();
        }
        catch (Throwable e) {
            uncaughtException = e;
        }
        if (uncaughtException != null) {
            StringWriter stackTrace = new StringWriter(500);
            uncaughtException.printStackTrace(new PrintWriter(stackTrace));
            compilation.listener.bug(stackTrace.toString(), "http://sourceforge.net/tracker/?func=add&group_id=12788&atid=112788");
            throw uncaughtException;
        }
        throw new Exit();
    }

    public static void fail(String msg) {
        nice.lang.dispatch.print("Native compilation with gcj failed");
        if (msg != null) {
            nice.lang.dispatch.println(nice.lang.dispatch.$$002b(": ", msg));
        } else {
            System.out.println();
        }
    }

    public static void compileWithGcj(String gcj, String pkg, String output, String jar) {
        block7: {
            if (gcj == null) {
                dispatch.fail("gcj was not found in the path");
                return;
            }
            try {
                Process p = Runtime.getRuntime().exec(new String[]{gcj, "--classpath=", nice.lang.dispatch.$$002b(nice.lang.dispatch.$$002b("--main=", pkg), ".fun"), "-o", output, jar});
                p.waitFor();
                if (p.exitValue() == 0) break block7;
                dispatch.fail(null);
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                try {
                    String line = in.readLine();
                    while (line != null) {
                        nice.lang.dispatch.println(line);
                        line = in.readLine();
                    }
                }
                catch (IOException ex) {
                }
            }
            catch (IOException e) {
                dispatch.fail(e.getMessage());
            }
            catch (SecurityException e) {
                dispatch.fail(e.getMessage());
            }
        }
    }

    public static void produceNativeProgram(String nativeCompiler, String pkg, String output, String jar) {
        dispatch.compileWithGcj(nativeCompiler, pkg, output, jar);
    }

    public static String getNiceRuntime() {
        String file;
        String resource = "/nice/tools/compiler/fun.class";
        URL classUrl = Class.forName("nice.tools.compiler.dispatch").getResource(resource);
        if (classUrl == null) {
            return null;
        }
        try {
            file = (String)nice.lang.dispatch.notNull(classUrl.getFile());
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, "nice.tools.code.EnsureTypeProc", -3);
        }
        try {
            return file.substring(file.indexOf(":") + 1, file.indexOf("!"));
        }
        catch (StringIndexOutOfBoundsException e) {
            return file.substring(0, file.indexOf(resource));
        }
    }

    public static void compile(Compilation compilation, String mainPackage, String nativeProgram, String nativeCompiler, boolean editorMode) {
        Throwable uncaughtException = null;
        try {
            Package.currentCompilation = compilation;
            Location.editorMode = editorMode;
            if (compilation.runtimeFile == null) {
                compilation.runtimeFile = dispatch.getNiceRuntime();
            }
            TypeImport.setRuntime(compilation.runtimeFile);
            bossa.modules.dispatch.setMainPackage(compilation, mainPackage);
            mlsub.compilation.dispatch.make(compilation);
            String jar = compilation.output;
            if (nativeProgram != null && jar != null) {
                dispatch.produceNativeProgram(nativeCompiler, mainPackage, nativeProgram, jar);
            }
        }
        catch (Exit e) {
        }
        catch (UserError e) {
            String string;
            Internal.warning("user error only caught in main");
            try {
                string = (String)nice.lang.dispatch.notNull(e.message);
            }
            catch (ClassCastException classCastException) {
                throw WrongType.make(classCastException, "nice.tools.code.EnsureTypeProc", -3);
            }
            compilation.listener.error(e.location, string);
        }
        catch (ExceptionInInitializerError e) {
            uncaughtException = e.getException();
        }
        catch (Throwable e) {
            uncaughtException = e;
        }
        if (uncaughtException != null) {
            StringWriter stackTrace = new StringWriter(500);
            nice.lang.dispatch.printStackTraceWithSourceInfo(uncaughtException, new PrintWriter(stackTrace));
            compilation.listener.bug(stackTrace.toString(), "http://sourceforge.net/tracker/?func=add&group_id=12788&atid=112788");
        }
    }
}

