/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.testsuite.output;

import java.io.Writer;
import nice.tools.testsuite.TestCase;
import nice.tools.testsuite.TestNice;
import nice.tools.testsuite.TestSuite;
import nice.tools.testsuite.output.AbstractOutput;

public class TextOutput
extends AbstractOutput {
    private String _indentSign = "  ";
    private int _indent = 0;

    public TextOutput(Writer out) {
        super(out);
    }

    private String indent() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this._indent) {
            buf.append(this._indentSign);
            ++i;
        }
        return buf.toString();
    }

    public void startApplication() {
        this.logAndFlush("run test engine");
        ++this._indent;
    }

    public void endApplication() {
        --this._indent;
        this.log("test engine finished");
        this.log("");
        this.log("number of testcases: " + TestNice.getTotalTestCases());
        this.log("  successes  : " + TestNice.getTestCasesSucceeded());
        this.log("  regressions: " + TestNice.getTestCasesFailed());
        this.log("  warnings   : " + TestNice.getTestCasesWarning());
        this.log("  known bugs : " + TestNice.getTestCasesKnownBug());
        if (TestNice.getTestCasesFixed() > 0) {
            this.log("  FIXES :-)) : " + TestNice.getTestCasesFixed());
        }
        this.logAndFlush("");
    }

    public void startTestSuite(TestSuite testSuite) {
        this.logAndFlush("testsuite: " + testSuite.getFile());
        ++this._indent;
    }

    public void endTestSuite() {
        --this._indent;
    }

    public void startTestCase(TestCase testCase) {
        this.mark();
        this.log("testcase");
        ++this._indent;
    }

    public void endTestCase(boolean pass) {
        if (pass) {
            this.reset();
        } else {
            this.logAndFlush("fail");
        }
        --this._indent;
    }

    protected String getIndent() {
        return this.indent();
    }
}

