/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Constraint;
import bossa.syntax.Expression;
import bossa.syntax.FormalParameters;
import bossa.syntax.FunExp;
import bossa.syntax.FunSymbol;
import bossa.syntax.LocatedString;
import bossa.syntax.MonoSymbol;
import bossa.syntax.Monotype;
import bossa.syntax.Statement;
import bossa.syntax.VarSymbol;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import bossa.util.Util;
import gnu.bytecode.Type;
import gnu.expr.BeginExp;
import gnu.expr.Declaration;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import mlsub.typing.Polytype;
import nice.tools.code.Types;

public class Block
extends Statement {
    ArrayList locals = new ArrayList();
    Statement[] statements;
    boolean isBreakTarget = false;

    public Block(List statements) {
        this.statements = this.cutInBlocks(statements);
        if (this.statements != null && this.statements.length > 0 && this.statements[0] != null) {
            this.setLocation(this.statements[0].location());
        }
    }

    Block(Statement[] statements) {
        this.statements = statements;
    }

    public Statement last() {
        return this.statements[this.statements.length - 1];
    }

    public static LocalValue createLocalVariable(LocatedString name, Monotype type, boolean constant, Expression value) {
        if (type == null && value == null) {
            User.error((Located)name, "A local variable requires a type or a default value");
        }
        if (constant && type == null) {
            return new LocalConstant(name, value);
        }
        return new LocalVariable(name, type, constant, value);
    }

    private Statement[] cutInBlocks(List statements) {
        Object s;
        ArrayList res = new ArrayList();
        ListIterator i = statements.listIterator();
        while (i.hasNext()) {
            s = i.next();
            if (s instanceof LocalValue) {
                LocalValue decl = (LocalValue)s;
                do {
                    this.locals.add(decl);
                } while ((decl = decl.next) != null);
                continue;
            }
            if (s instanceof LocalDeclaration) {
                this.locals.add(s);
                continue;
            }
            res.add(s);
            break;
        }
        this.locals.trimToSize();
        while (i.hasNext()) {
            s = i.next();
            if (s instanceof LocalDeclaration) {
                Block end = new Block(statements.subList(i.previousIndex(), statements.size()));
                end.setLocation(((LocalDeclaration)s).location());
                res.add(end);
                break;
            }
            res.add(s);
        }
        res.trimToSize();
        return res.toArray(new Statement[res.size()]);
    }

    public gnu.expr.Expression generateCode() {
        gnu.expr.Expression body = this.statements.length != 0 ? new BeginExp() : QuoteExp.voidExp;
        gnu.expr.Expression res = this.addLocals(this.locals.iterator(), body);
        if (this.statements.length != 0) {
            ((BeginExp)body).setExpressions(Statement.compile(this.statements));
        }
        return res;
    }

    private gnu.expr.Expression addLocals(Iterator vars, gnu.expr.Expression body) {
        if (!vars.hasNext()) {
            return body;
        }
        LocalDeclaration local = (LocalDeclaration)vars.next();
        gnu.expr.Expression[] eVal = new gnu.expr.Expression[1];
        LetExp res = new LetExp(eVal);
        eVal[0] = local.compile(res);
        res.setBody(this.addLocals(vars, body));
        local.location().write(res);
        return res;
    }

    public String toString() {
        return "{\n" + Util.map("", ";\n", ";\n", this.locals) + Util.map("", "\n", "\n", this.statements) + "}\n";
    }

    public static class LocalFunction
    extends LocalDeclaration {
        FunSymbol left;
        FormalParameters parameters;

        public static LocalFunction make(LocatedString name, Monotype returnType, FormalParameters parameters, Statement body) {
            FunExp value = new FunExp(Constraint.True, parameters.getMonoSymbols(), body);
            FunSymbol symbol = new FunSymbol(name, Constraint.True, parameters, returnType);
            symbol.syntacticType.getMonotype().nullness = (byte)2;
            return new LocalFunction(symbol, value, parameters);
        }

        private LocalFunction(FunSymbol symbol, Expression value, FormalParameters parameters) {
            this.value = value;
            this.left = symbol;
            this.parameters = parameters;
        }

        String getName() {
            return this.left.name.toString();
        }

        VarSymbol getSymbol() {
            return this.left;
        }

        Type getBytecodeType() {
            return Types.javaType(this.left.type);
        }

        Polytype inferredReturnType() {
            return ((FunExp)this.value).inferredReturnType();
        }

        mlsub.typing.Monotype declaredReturnType() {
            return nice.tools.typing.Types.result(this.left.getType());
        }
    }

    public static class LocalConstant
    extends LocalValue {
        MonoSymbol left;

        public LocalConstant(LocatedString name, Expression value) {
            this.value = value;
            this.left = new Symbol(name, null);
            this.last = this;
        }

        String getName() {
            return this.left.name.toString();
        }

        VarSymbol getSymbol() {
            return this.left;
        }

        Type getBytecodeType() {
            return Types.javaType(this.left.type);
        }

        public void addNext(LocatedString name, Expression value) {
            if (value == null) {
                User.error((Located)name, "A local constant requires a type or a default value");
            }
            this.last = this.last.next = new LocalConstant(name, value);
        }

        public String toString() {
            return "let " + super.display();
        }

        static class Symbol
        extends MonoSymbol {
            Symbol(LocatedString name, Monotype type) {
                super(name, type);
            }

            boolean isAssignable() {
                return false;
            }
        }
    }

    public static class LocalVariable
    extends LocalValue {
        Symbol left;

        public LocalVariable(LocatedString name, Monotype type, boolean constant, Expression value) {
            this.value = value;
            this.left = new Symbol(name, type, constant);
            this.last = this;
        }

        String getName() {
            return this.left.name.toString();
        }

        VarSymbol getSymbol() {
            return this.left;
        }

        Type getBytecodeType() {
            return Types.javaType(this.left.type);
        }

        gnu.expr.Expression initValue() {
            if (this.value == null) {
                return QuoteExp.undefined_exp;
            }
            return this.value.generateCode();
        }

        int getIndex() {
            return this.left.index;
        }

        void setIndex(int i) {
            this.left.index = i;
        }

        public void addNext(LocatedString name, Expression value) {
            if (this.left.syntacticType == null && value == null) {
                User.error((Located)name, "A local variable requires a type or a default value");
            }
            this.last = this.last.next = new LocalVariable(name, this.left.syntacticType, !this.left.isAssignable(), value);
        }

        public String display() {
            if (this.left.constant) {
                return "let " + super.display();
            }
            return "var " + super.display();
        }

        static class Symbol
        extends MonoSymbol {
            int index = -1;
            boolean constant;

            Symbol(LocatedString name, Monotype type, boolean constant) {
                super(name, type);
                this.constant = constant;
            }

            boolean isAssignable() {
                return !this.constant || this.index != -1;
            }
        }
    }

    public static abstract class LocalValue
    extends LocalDeclaration {
        LocalValue next;
        LocalValue last = this;

        public abstract void addNext(LocatedString var1, Expression var2);

        public String toString() {
            StringBuffer res = new StringBuffer();
            LocalValue v = this;
            while (true) {
                res.append(v.display());
                v = v.next;
                if (v == null) break;
                res.append(',');
            }
            return res.toString();
        }
    }

    static abstract class LocalDeclaration
    extends Statement {
        Expression value;

        LocalDeclaration() {
        }

        abstract String getName();

        abstract VarSymbol getSymbol();

        abstract Type getBytecodeType();

        gnu.expr.Expression initValue() {
            return this.value.generateCode();
        }

        public Location location() {
            return this.getSymbol().name.location();
        }

        gnu.expr.Expression compile(LetExp let) {
            Declaration decl = let.addDeclaration(this.getName(), this.getBytecodeType());
            decl.noteValue(null);
            if (!this.getSymbol().isAssignable()) {
                decl.setFlag(16384);
            }
            if (this.value == null) {
                decl.setFlag(0x200000);
            }
            this.getSymbol().setDeclaration(decl);
            return this.initValue();
        }

        public gnu.expr.Expression generateCode() {
            Internal.error("Should not be called");
            return null;
        }

        public String display() {
            if (this.value == null) {
                return this.getSymbol().toString();
            }
            return this.getSymbol().toString() + '=' + this.value;
        }
    }
}

