/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.LocatedString;
import bossa.syntax.LoopStmt;
import bossa.syntax.Statement;
import gnu.expr.BlockExp;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;

public class LabeledStmt
extends Statement {
    private LocatedString label;
    private Statement statement;
    private LoopStmt loop;
    BlockExp block;

    public LabeledStmt(LocatedString label, Statement statement) {
        this.label = label;
        this.statement = statement;
    }

    public LabeledStmt(LocatedString label, Statement statement, LoopStmt loop) {
        this(label, statement);
        this.loop = loop;
    }

    public String name() {
        return this.label.toString();
    }

    public LocatedString getLabel() {
        return this.label;
    }

    public Statement getStatement() {
        return this.statement;
    }

    LoopStmt getLoop() {
        if (this.loop != null) {
            return this.loop;
        }
        if (this.statement instanceof LoopStmt) {
            return (LoopStmt)this.statement;
        }
        return null;
    }

    public Expression generateCode() {
        if (this.statement == null) {
            return QuoteExp.voidExp;
        }
        BlockExp res = this.block = new BlockExp();
        this.block.setBody(this.statement.generateCode());
        this.block = null;
        return res;
    }
}

