/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.link.Dispatch;
import bossa.syntax.Alike;
import bossa.syntax.AtomicConstraint;
import bossa.syntax.Constraint;
import bossa.syntax.Contract;
import bossa.syntax.DefaultMethodImplementation;
import bossa.syntax.Definition;
import bossa.syntax.FormalParameters;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodContainer;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Monotype;
import bossa.syntax.Node;
import bossa.syntax.Statement;
import bossa.syntax.UserOperator;
import bossa.syntax.VarSymbol;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import mlsub.typing.Domain;
import mlsub.typing.ImplementsCst;
import mlsub.typing.Interface;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeConstructorLeqCst;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Gen;
import nice.tools.typing.Types;

public class NiceMethod
extends UserOperator {
    private boolean isOverride;
    private Location returnTypeLocation;
    private List homonyms;
    private List specializedMethods = null;

    public static Definition create(MethodContainer c, LocatedString name, Constraint constraint, Monotype returnType, FormalParameters params, Statement body, Contract contract, boolean isOverride) {
        MonotypeConstructor thisType;
        TypeConstructor tc;
        boolean hasAlike = returnType.containsAlike() || params.containsAlike();
        MethodContainer.Constraint thisConstraint = c.classConstraint;
        TypeSymbol[] thisBinders = c.getBinders();
        int thisBindersLen = thisBinders == null ? 0 : thisBinders.length;
        TypeSymbol container = c.getTypeSymbol();
        Interface itf = null;
        if (container instanceof TypeConstructor) {
            tc = (TypeConstructor)container;
        } else {
            itf = (Interface)container;
            tc = itf.associatedTC();
        }
        if (constraint == Constraint.True) {
            constraint = new Constraint(new ArrayList(thisBindersLen + (hasAlike ? 1 : 0)), new ArrayList((hasAlike ? 1 : 0) + (thisConstraint == null ? 0 : thisConstraint.getAtoms().size())));
        }
        constraint.addBinders(thisBinders);
        if (thisConstraint != null) {
            constraint.addAtoms(thisConstraint.getAtoms());
        }
        if (hasAlike || tc == null) {
            TypeConstructor alikeTC = new TypeConstructor("Alike", c.variance, false, false);
            constraint.addFirstBinder(alikeTC);
            mlsub.typing.AtomicConstraint atom = itf != null ? new ImplementsCst(alikeTC, itf) : new TypeConstructorLeqCst(alikeTC, tc);
            constraint.addAtom(AtomicConstraint.create(atom));
            thisType = new MonotypeConstructor(alikeTC, c.getTypeParameters());
            if (hasAlike) {
                HashMap<Object, TypeConstructor> map2 = new HashMap<Object, TypeConstructor>();
                map2.put(Alike.id, alikeTC);
                returnType = returnType.substitute(map2);
                params.substitute(map2);
            }
        } else {
            thisType = new MonotypeConstructor(tc, c.getTypeParameters());
        }
        params.addThis(Monotype.create(Monotype.sure(thisType)));
        if (body == null) {
            return new NiceMethod(name, constraint, returnType, params, contract, isOverride);
        }
        return WithDefault.create(name, constraint, returnType, params, body, contract, isOverride);
    }

    public NiceMethod(LocatedString name, Constraint constraint, Monotype returnType, FormalParameters parameters, Contract contract, boolean isOverride) {
        super(name, constraint, returnType, parameters, contract);
        this.isOverride = isOverride;
        this.returnTypeLocation = returnType.location();
        Dispatch.register(this);
    }

    public boolean isMain() {
        if (!this.name.toString().equals("main") || this.arity != 1) {
            return false;
        }
        return this.getType().domain()[0].toString().equals("java.lang.String[]");
    }

    void resolve() {
        super.resolve();
        if (this.isOverride || !this.module.interfaceFile()) {
            this.homonyms = Node.getGlobalScope().lookup(this.getName());
            if (this.homonyms.size() == 1) {
                this.homonyms = null;
            } else {
                this.homonyms.remove(this.getSymbol());
            }
        }
    }

    void typedResolve() {
        this.findSpecializedMethods();
        if (this.isOverride && this.specializedMethods == null) {
            User.error((Located)this, "This method does not override any other method");
        }
        if (!this.inInterfaceFile() && !this.isOverride && this.specializedMethods != null) {
            MethodDeclaration parent = (MethodDeclaration)this.specializedMethods.get(0);
            boolean sameResult = this.getReturnType().toString().equals(parent.getReturnType().toString());
            if (sameResult) {
                User.warning(this, "This method overrides " + parent + "\nYou should make this explicit, either by omitting the return type" + "\nor by using the 'override' keyword");
            } else {
                User.warning(this, "This method overrides " + parent + "\nYou should make this explicit by using the 'override' keyword");
            }
        }
        super.typedResolve();
    }

    public Iterator listSpecializedMethods() {
        return this.specializedMethods == null ? null : this.specializedMethods.iterator();
    }

    public boolean specializesMethods() {
        return this.specializedMethods != null;
    }

    void findSpecializedMethods() {
        if (this.homonyms == null) {
            return;
        }
        Domain ourDomain = Types.domain(this.getType());
        ListIterator i = this.homonyms.listIterator();
        while (i.hasNext()) {
            Domain itsDomain;
            VarSymbol s = (VarSymbol)i.next();
            MethodDeclaration d = s.getMethodDeclaration();
            if (d == null || d.isIgnored() || d.getArity() != this.getArity() || !Typing.smaller(ourDomain, itsDomain = Types.domain(s.getType()), true) || Types.typeParameterDispatch(this.getType(), s.getType())) continue;
            if (this.module.interfaceFile()) {
                this.addSpecializedMethod(d);
                continue;
            }
            if (!Types.covariantSpecialization(this.getType(), s.getType())) {
                User.error((Located)(this.returnTypeLocation != null ? this.returnTypeLocation : this.location()), "The return type is less precise than the original return type of method\n" + d + "\ndefined in:\n" + d.location());
            }
            if (Typing.smaller(itsDomain, ourDomain)) {
                if (this.module != d.module) continue;
                User.error((Located)this, "This method has a domain identical to " + d + ", which is defined at " + d.location());
            }
            this.addSpecializedMethod(d);
        }
        this.homonyms = null;
    }

    private void addSpecializedMethod(MethodDeclaration method) {
        if (this.specializedMethods == null) {
            this.specializedMethods = new ArrayList(5);
        }
        this.specializedMethods.add(method);
    }

    public String getFullName() {
        return this.module.getName() + '.' + this.name + ':' + this.getType();
    }

    protected Expression computeCode() {
        return this.module.getDispatchMethod(this);
    }

    public final LambdaExp getLambda() {
        return Gen.dereference(this.getCode());
    }

    public void compile() {
    }

    public void printInterface(PrintWriter s) {
        if (this.specializedMethods != null) {
            s.print("override ");
        }
        s.print(super.toString() + ";\n");
    }

    public static class WithDefault
    extends NiceMethod {
        DefaultMethodImplementation implementation;

        public static Definition create(LocatedString name, Constraint constraint, Monotype returnType, FormalParameters parameters, Statement body, Contract contract, boolean isOverride) {
            if (body == null) {
                return new NiceMethod(name, constraint, returnType, parameters, contract, isOverride);
            }
            return new DefaultMethodImplementation(name, constraint, returnType, parameters, contract, isOverride, body);
        }

        public WithDefault(LocatedString name, Constraint constraint, Monotype returnType, FormalParameters parameters, Contract contract, boolean isOverride, DefaultMethodImplementation impl) {
            super(name, constraint, returnType, parameters, contract, isOverride);
            this.implementation = impl;
        }

        void innerTypecheck() throws TypingEx {
            super.innerTypecheck();
            this.implementation.innerTypecheck();
        }

        protected Expression computeCode() {
            this.code = super.computeCode();
            this.implementation.getRefExp();
            return this.code;
        }
    }
}

