/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.util.Located;
import bossa.util.Location;
import bossa.util.UserError;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;

public abstract class Statement
implements Located {
    public static final Statement[] noStatements = new Statement[0];
    Location loc;

    Statement() {
    }

    Statement(Location location) {
        this.setLocation(location);
    }

    abstract Expression generateCode();

    static Expression[] compile(Statement[] statements) {
        Expression[] res = new Expression[statements.length];
        for (int i = 0; i < statements.length; ++i) {
            Statement s = statements[i];
            if (s == null) {
                res[i] = QuoteExp.voidExp;
                continue;
            }
            try {
                res[i] = s.generateCode();
            }
            catch (UserError e) {
                if (e.location == null) {
                    e.location = s.location();
                }
                throw e;
            }
            if (s.location() == null) continue;
            s.location().write(res[i]);
        }
        return res;
    }

    public Location location() {
        return this.loc;
    }

    public void setLocation(Location l) {
        this.loc = l;
    }
}

