/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class CheckContract
extends Expression {
    public static final Expression result = new ResultExp();
    private Expression[] pre;
    private Expression[] post;
    private Expression body;

    public CheckContract(Expression[] pre, Expression[] post, Expression body) {
        this.pre = pre;
        this.post = post;
        this.body = body;
    }

    public void compile(Compilation comp, Target target) {
        int i;
        CodeAttr code = comp.getCode();
        ClassExp currentClass = (ClassExp)comp.topLambda;
        code.preparePostcondition(currentClass.getAssertionEnabledField(), this.post.length > 0);
        if (this.pre.length > 0) {
            code.startPrecondition();
            for (i = 0; i < this.pre.length; ++i) {
                this.pre[i].compileWithPosition(comp, Target.Ignore);
            }
            code.endPrecondition();
        }
        this.body.compileWithPosition(comp, target);
        if (this.post.length > 0) {
            code.startPostcondition();
            for (i = 0; i < this.post.length; ++i) {
                this.post[i].compileWithPosition(comp, Target.Ignore);
            }
            code.endPostcondition();
        } else {
            code.pushRetType();
        }
    }

    protected void walkChildren(ExpWalker walker) {
        walker.walkExps(this.pre);
        if (walker.exitValue != null) {
            return;
        }
        this.body = this.body.walk(walker);
        if (walker.exitValue != null) {
            return;
        }
        walker.walkExps(this.post);
    }

    public void print(OutPort ps) {
        ps.print("(Check ...)");
    }

    private static class ResultExp
    extends Expression {
        private ResultExp() {
        }

        public void compile(Compilation comp, Target target) {
            CodeAttr code = comp.getCode();
            code.loadResult();
        }

        public void print(OutPort ps) {
            ps.print("(Result)");
        }
    }
}

