/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.ScopeExp;
import gnu.text.SourceMessages;

public class Parser {
    public boolean immediate;
    protected ScopeExp current_scope;
    protected String current_filename;
    protected int current_line;
    protected int current_column;
    protected SourceMessages messages;

    public Parser(SourceMessages messages) {
        this.messages = messages;
    }

    public Expression parse(Object input) {
        throw new Error("unimeplemented parse");
    }

    public Interpreter getInterpreter() {
        return Interpreter.getInterpreter();
    }

    public LambdaExp currentLambda() {
        return this.current_scope.currentLambda();
    }

    public ModuleExp currentModule() {
        return this.current_scope.currentModule();
    }

    public void mustCompileHere() {
        ScopeExp exp = this.current_scope;
        while (exp != null) {
            if (exp instanceof ModuleExp) {
                ((ModuleExp)exp).mustCompile = true;
                return;
            }
            exp = exp.outer;
        }
        return;
    }

    public ScopeExp currentScope() {
        return this.current_scope;
    }

    public void push(ScopeExp scope) {
        scope.outer = this.current_scope;
        if (!(scope instanceof ModuleExp)) {
            this.mustCompileHere();
        }
        this.current_scope = scope;
    }

    public void pop(ScopeExp scope) {
        this.current_scope = scope.outer;
    }

    public final void pop() {
        this.pop(this.current_scope);
    }

    public Declaration lookup(String name, int namespace) {
        Interpreter interp = this.getInterpreter();
        ScopeExp scope = this.current_scope;
        while (scope != null) {
            Declaration decl = scope.lookup(name, interp, namespace);
            if (decl != null) {
                return decl;
            }
            scope = scope.outer;
        }
        return null;
    }

    public SourceMessages getMessages() {
        return this.messages;
    }

    public void setMessages(SourceMessages messages) {
        this.messages = messages;
    }

    public void error(char severity, String message) {
        this.messages.error(severity, this.current_filename, this.current_line, this.current_column, message);
    }

    public void error(char severity, Declaration decl, String msg1, String msg2) {
        String filename = this.current_filename;
        int line = this.current_line;
        int column = this.current_column;
        int decl_line = decl.getLine();
        if (decl_line > 0) {
            filename = decl.getFile();
            line = decl_line;
            column = decl.getColumn();
        }
        this.messages.error(severity, filename, line, column, msg1 + decl.getName() + msg2);
    }

    public final String getFile() {
        return this.current_filename;
    }

    public final int getLine() {
        return this.current_line;
    }

    public final int getColumn() {
        return this.current_column;
    }

    public void setFile(String filename) {
        this.current_filename = filename;
    }

    public void setLine(int line) {
        this.current_line = line;
    }

    public void setColumn(int column) {
        this.current_column = column;
    }

    public void setLine(String filename, int line, int column) {
        this.current_filename = filename;
        this.current_line = line;
        this.current_column = column;
    }
}

