
#line 3 "lex.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 31
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,int len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 128
#define YY_END_OF_BUFFER 129
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[359] =
    {   0,
        0,    0,  129,  127,  106,   56,  105,   84,  127,   85,
       50,   83,   86,  127,   57,   58,   79,   77,   49,   78,
       52,   80,  109,  122,  104,   48,   94,   76,   95,  102,
      126,   60,   61,   88,  126,  126,  126,  126,  126,  126,
      126,  126,  126,  126,  126,  126,  126,  126,  126,  126,
       62,   87,   63,   89,  106,  105,    2,   93,    0,  108,
        0,   69,   98,   74,    0,  107,    0,   82,   66,   59,
       90,   64,   91,   65,   53,    0,  125,    0,    1,   81,
       67,  125,  109,  122,    0,    0,    0,    0,  103,  100,
       96,   55,   92,   54,   97,  101,  126,   73,  126,  126,

      126,  126,  126,  126,   10,  126,  126,  126,  126,  126,
      126,  126,  126,   11,  126,  126,  126,  126,  126,  126,
      126,  126,  126,  126,  126,  126,  126,  126,  126,  126,
      126,  126,   75,   99,    0,    2,  108,  107,   70,   51,
        0,   68,  124,  125,    0,    0,  125,    0,  114,    0,
      110,    0,  118,   71,   72,  126,  126,  126,  126,  126,
      126,  126,  126,  126,  126,  126,  126,  126,    9,  126,
      126,  126,   24,  126,  126,  126,  126,  126,  126,  126,
      126,  126,  126,  126,  126,  126,  126,   19,  126,  126,
      126,  126,  126,  125,    0,    0,  117,    0,  117,    0,

      113,    0,  113,    0,  121,    0,  121,  118,    3,   23,
      126,   16,  126,  126,  126,  126,   12,   34,  126,  126,
      126,   28,   40,   39,  126,  126,  126,   22,  126,  126,
      126,  126,   26,  126,  126,  126,  126,  126,  126,  126,
       36,  126,  126,  126,   35,  126,  123,    0,  116,  117,
        0,    0,  117,    0,  112,  113,    0,    0,  113,  121,
        0,  120,  121,  121,    0,    0,  118,  118,   14,   20,
        4,  126,  126,  126,  126,   37,  126,  126,  126,  126,
      126,  126,   44,  126,  126,  126,  126,  126,  126,  126,
      126,   21,  126,   33,    8,  117,    0,    0,  113,    0,

        0,  121,  121,  121,    0,  121,  121,    0,  121,  126,
      126,  126,   47,  126,    5,   42,  126,  126,   46,  126,
       18,  126,    6,   27,   32,   13,   31,  126,  115,  111,
        0,  119,  126,   17,  126,  126,  126,  126,  126,  126,
       38,  126,   15,  126,    7,  126,  126,   25,  126,  126,
       43,   41,   45,   29,  126,  126,   30,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
       22,   22,   22,   22,   22,   23,   23,   24,   25,   26,
       27,   28,   29,    1,   30,   30,   30,   30,   31,   30,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       33,   34,   35,   36,   32,    1,   37,   38,   39,   40,

       41,   42,   43,   44,   45,   32,   46,   47,   48,   49,
       50,   51,   32,   52,   53,   54,   55,   56,   57,   58,
       59,   32,   60,   61,   62,   63,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[64] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    3,    1,    3,    4,    1,    5,
        5,    5,    5,    1,    1,    1,    1,    1,    1,    5,
        5,    6,    1,    1,    1,    1,    5,    5,    5,    5,
        5,    5,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    7,
        1,    1,    1
    } ;

static yyconst flex_int16_t yy_base[371] =
    {   0,
        0,   62,  603,  604,  604,  604,  604,  575,   59,  604,
      604,  574,   57,   57,  604,  604,   56,   58,  604,   54,
       54,   73,   97,   81,  576,  604,   52,   67,   69,  604,
        0,  604,  604,  572,  543,   36,   61,   66,   74,   89,
      550,   82,  559,   58,   68,   86,   89,  546,  544,  549,
      604,   98,  604,  604,  147,  154,  604,  604,  123,  604,
      130,  604,  604,  604,  126,  604,  131,  565,  604,  604,
      604,  604,  604,  604,  604,  573,  146,  150,  604,  563,
      604,  158,  170,  182,  199,  132,  164,  571,  604,  561,
      604,  604,  604,  604,  604,  560,    0,  604,  532,  535,

      543,  109,  534,  540,    0,  528,  525,  144,  532,  531,
      525,  527,  525,    0,  523,  519,  524,  524,  520,  531,
      163,  158,  520,  157,  522,  514,  169,  520,  513,  518,
      517,  516,  604,  604,  223,  604,  201,  163,  604,  604,
      211,  604,  542,  216,  220,  228,  232,  224,  238,  240,
      246,  499,  247,  604,  604,  508,  510,  519,  514,  515,
      217,  516,  511,  503,  509,  508,  495,  506,  500,  506,
      506,  493,    0,  501,  482,  486,  492,  485,  492,  489,
      480,  497,  479,  227,  478,  490,  489,    0,  471,  487,
      477,  486,  478,  244,  506,  269,  273,  260,  277,  286,

      289,  295,  301,  319,  294,    0,  325,  329,    0,    0,
      477,    0,  478,  467,  475,  464,    0,    0,  467,  468,
      475,    0,    0,  461,  477,  461,  459,    0,  470,  465,
      468,  458,    0,  455,  455,  460,  455,  463,  461,  460,
        0,  441,  449,  436,    0,  433,  604,  306,  449,  331,
      292,  308,  337,  343,  446,  353,  356,  359,  366,  352,
      401,  444,  377,  375,    0,    0,  383,  333,    0,    0,
        0,  412,  413,  405,  418,    0,  412,  409,  401,  403,
      414,  412,    0,  401,  400,  404,  408,  402,  389,  398,
      401,    0,  399,    0,    0,  255,  421,  376,  314,  416,

      382,  392,  400,  358,  414,  405,  404,  369,    0,  374,
      374,  366,    0,  360,    0,    0,  345,  317,    0,  322,
        0,  303,    0,    0,    0,    0,    0,  296,  604,  604,
      410,  604,  389,    0,  274,  256,  263,  258,  236,  222,
        0,  209,    0,  197,    0,  188,  186,    0,  174,  165,
        0,    0,    0,    0,  146,  126,    0,  604,  465,  472,
      475,  478,  479,  140,  483,  488,  491,  496,  101,   85
    } ;

static yyconst flex_int16_t yy_def[371] =
    {   0,
      358,    1,  358,  358,  358,  358,  358,  358,  359,  358,
      358,  358,  358,  360,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      361,  358,  358,  358,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      358,  358,  358,  358,  358,  358,  358,  358,  359,  358,
      359,  358,  358,  358,  360,  358,  360,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  362,  358,  358,
      358,  358,  358,  358,  358,  358,  361,  358,  361,  361,

      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  358,  358,  358,  358,  359,  360,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      358,  363,  362,  358,  358,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  358,  358,  358,  358,  358,  358,  358,

      358,  358,  358,  358,  363,  364,  365,  366,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  367,
      364,  358,  365,  368,  369,  370,  366,  267,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  358,  358,  358,  358,  358,

      358,  367,  302,  358,  358,  368,  306,  369,  370,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  358,  358,
      370,  358,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
      361,  361,  361,  361,  361,  361,  361,    0,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358
    } ;

static yyconst flex_int16_t yy_nxt[668] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
       24,   24,   24,   25,   26,   27,   28,   29,   30,   31,
       31,   31,   32,    4,   33,   34,   35,   36,   37,   38,
       39,   40,   41,   31,   42,   31,   31,   31,   43,   31,
       44,   45,   46,   47,   48,   49,   50,   31,   31,   51,
       52,   53,   54,   55,   60,   56,   63,   66,   57,   68,
       73,   76,   71,   77,   77,   77,   77,   90,   91,   92,
       74,   75,   69,   64,   72,  100,   79,  101,   70,  309,
       67,   80,   61,   93,   94,   95,   96,  102,   82,   81,

       84,   84,   84,   84,  121,  308,  104,  118,  122,  119,
      103,   85,  120,   78,   82,  105,   83,   83,   83,   84,
      106,   85,  107,  114,  133,  109,  123,   85,   60,  115,
      116,  108,  126,  110,   86,  137,   66,   85,  111,  124,
      127,  138,  125,  112,  261,  128,   87,  129,  135,  148,
      135,  149,  149,  136,   88,  135,   61,  135,  134,   67,
      136,  159,  160,   61,   67,   77,   77,   77,   77,  141,
      141,  141,  141,   66,  357,  143,   85,  144,  144,  144,
      144,  150,  165,  151,  151,  151,   85,   82,   85,   83,
       83,   83,   84,  183,  180,  356,   67,  166,   85,   82,

       85,   84,   84,   84,   84,   78,   60,  178,  184,  355,
       85,  181,   85,  146,  354,  146,  179,  145,  147,  147,
      147,  147,   85,  187,  135,  353,  135,  188,  352,  136,
      141,  141,  141,  141,   61,  144,  144,  144,  144,  196,
      196,  196,  196,  197,  197,  351,   85,  147,  147,  147,
      147,  147,  147,  147,  147,  199,   85,  149,  149,  201,
      201,  201,  350,  203,  207,  151,  151,  151,  200,  214,
      215,  237,  194,  349,   85,  145,  204,  208,  200,  248,
      248,  238,  348,  198,   85,  200,  204,  208,  196,  196,
      196,  196,  197,  197,  249,  200,  250,  250,  347,  202,

      252,  346,  252,  200,  345,  253,  253,  200,  201,  201,
      201,  298,  298,  200,  254,  254,  254,  200,  255,  204,
      256,  256,  256,  344,  260,  248,  248,  253,  253,  204,
      194,  204,  198,  258,  260,  258,  251,  341,  259,  259,
      259,  204,  262,  266,  204,  266,  207,  266,  202,  266,
      250,  250,  340,  206,  204,  264,  253,  253,  339,  268,
      257,  200,  254,  254,  254,  264,  266,  296,  266,  268,
      338,  200,  256,  256,  256,  301,  301,  301,  259,  259,
      259,  337,  303,  204,  265,  259,  259,  259,  331,  266,
      251,  266,  303,  204,  358,  298,  298,  358,  331,  358,

      207,  301,  301,  301,  299,  307,  358,  264,  358,  336,
      335,  206,  257,  268,  266,  307,  266,  264,  266,  358,
      266,  358,  303,  268,  266,  342,  266,  334,  333,  343,
      304,  332,  303,  330,  265,  307,  265,  296,  329,  328,
      327,  326,  325,  299,  324,  307,  323,  322,  321,  320,
      319,  206,  318,  317,  316,  315,  314,  313,  312,  311,
      310,  305,  304,  300,  265,   59,  297,   59,   59,   59,
       59,   59,   65,  295,   65,   65,   65,   65,   65,   97,
       97,  153,  153,  205,  294,  205,  263,  263,  293,  263,
      267,  267,  267,  302,  292,  302,  291,  302,  306,  290,

      306,  289,  306,  288,  287,  286,  285,  284,  283,  282,
      281,  280,  279,  278,  277,  276,  275,  274,  273,  272,
      271,  270,  269,  247,  246,  245,  244,  243,  242,  241,
      240,  239,  236,  235,  234,  233,  232,  231,  230,  229,
      228,  227,  226,  225,  224,  223,  222,  221,  220,  219,
      218,  217,  216,  213,  212,  211,  210,  209,  206,  195,
      193,  192,  191,  190,  189,  186,  185,  182,  177,  176,
      175,  174,  173,  172,  171,  170,  169,  168,  167,  164,
      163,  162,  161,  158,  157,  156,  155,  154,  152,  142,
      140,  139,  132,  131,  130,  117,  113,   99,   98,   89,

       62,   58,  358,    3,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358
    } ;

static yyconst flex_int16_t yy_chk[668] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    2,    9,    2,   13,   14,    2,   17,
       20,   21,   18,   21,   21,   21,   21,   27,   27,   27,
       20,   20,   17,   13,   18,   36,   22,   36,   17,  370,
       14,   22,    9,   28,   28,   29,   29,   37,   24,   22,

       24,   24,   24,   24,   45,  369,   38,   44,   45,   44,
       37,   24,   44,   21,   23,   38,   23,   23,   23,   23,
       39,   24,   39,   42,   52,   40,   46,   23,   59,   42,
       42,   39,   47,   40,   23,   61,   65,   23,   40,   46,
       47,   67,   46,   40,  364,   47,   23,   47,   55,   86,
       55,   86,   86,   55,   23,   56,   59,   56,   52,   65,
       56,  102,  102,   61,   67,   77,   77,   77,   77,   78,
       78,   78,   78,  138,  356,   82,   77,   82,   82,   82,
       82,   87,  108,   87,   87,   87,   77,   83,   82,   83,
       83,   83,   83,  124,  122,  355,  138,  108,   82,   84,

       83,   84,   84,   84,   84,   77,  137,  121,  124,  350,
       83,  122,   84,   85,  349,   85,  121,   82,   85,   85,
       85,   85,   84,  127,  135,  347,  135,  127,  346,  135,
      141,  141,  141,  141,  137,  144,  144,  144,  144,  145,
      145,  145,  145,  148,  148,  344,  144,  146,  146,  146,
      146,  147,  147,  147,  147,  149,  144,  149,  149,  150,
      150,  150,  342,  151,  153,  151,  151,  151,  149,  161,
      161,  184,  141,  340,  194,  144,  151,  153,  149,  198,
      198,  184,  339,  148,  194,  296,  151,  153,  196,  196,
      196,  196,  197,  197,  199,  296,  199,  199,  338,  150,

      200,  337,  200,  197,  336,  200,  200,  199,  201,  201,
      201,  251,  251,  197,  202,  202,  202,  199,  203,  201,
      203,  203,  203,  335,  205,  248,  248,  252,  252,  201,
      196,  203,  197,  204,  205,  204,  199,  328,  204,  204,
      204,  203,  207,  208,  299,  208,  208,  268,  201,  268,
      250,  250,  322,  205,  299,  207,  253,  253,  320,  208,
      203,  250,  254,  254,  254,  207,  260,  248,  260,  208,
      318,  250,  256,  256,  256,  257,  257,  257,  258,  258,
      258,  317,  260,  256,  207,  259,  259,  259,  304,  264,
      250,  264,  260,  256,  263,  298,  298,  267,  304,  267,

      267,  301,  301,  301,  254,  264,  302,  263,  302,  314,
      312,  260,  256,  267,  303,  264,  303,  263,  307,  306,
      307,  306,  302,  267,  331,  333,  331,  311,  310,  333,
      308,  305,  302,  300,  264,  306,  263,  298,  297,  293,
      291,  290,  289,  301,  288,  306,  287,  286,  285,  284,
      282,  302,  281,  280,  279,  278,  277,  275,  274,  273,
      272,  262,  261,  255,  306,  359,  249,  359,  359,  359,
      359,  359,  360,  246,  360,  360,  360,  360,  360,  361,
      361,  362,  362,  363,  244,  363,  365,  365,  243,  365,
      366,  366,  366,  367,  242,  367,  240,  367,  368,  239,

      368,  238,  368,  237,  236,  235,  234,  232,  231,  230,
      229,  227,  226,  225,  224,  221,  220,  219,  216,  215,
      214,  213,  211,  195,  193,  192,  191,  190,  189,  187,
      186,  185,  183,  182,  181,  180,  179,  178,  177,  176,
      175,  174,  172,  171,  170,  169,  168,  167,  166,  165,
      164,  163,  162,  160,  159,  158,  157,  156,  152,  143,
      132,  131,  130,  129,  128,  126,  125,  123,  120,  119,
      118,  117,  116,  115,  113,  112,  111,  110,  109,  107,
      106,  104,  103,  101,  100,   99,   96,   90,   88,   80,
       76,   68,   50,   49,   48,   43,   41,   35,   34,   25,

       12,    8,    3,  358,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358,  358,  358,  358,
      358,  358,  358,  358,  358,  358,  358
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lex.l"
#line 2 "lex.l"
/* $Header: /local/src/CVS/nickle/lex.l,v 1.76 2004/06/17 20:30:47 keithp Exp $ */

/*
 * Copyright © 1988-2004 Keith Packard and Bart Massey.
 * All Rights Reserved.  See the file COPYING in this directory
 * for licensing information.
 */

#include	"nickle.h"
#include	"gram.h"
#include	"ref.h"
#include	<strings.h>
#include	<errno.h>
#ifdef HAVE_LIBREADLINE
#include	<readline/readline.h>
#include	<readline/history.h>
#endif
    
typedef struct _lexInput {
    DataType		data;
    struct _lexInput	*next;
    Value		file;
    Atom		name;
    int			lineno;
    Bool		at_bol;
    Bool		at_eof;
    Bool		interactive;
} LexInput;

LexInput    *lexInput;
extern int  ignorenl;
extern int  notCommand;
extern int  seeComment;
#define	    FILE_END_CHAR	-2
    
static void lexInputMark (void *object)
{
    LexInput *lex = object;
    
    MemReference (lex->next);
    MemReference (lex->file);
}

static DataType lexInputType = {
    lexInputMark, 0, "lexInputType"
};

void
NewLexInput (Value file, Atom name, Bool after, Bool interactive)
{
    ENTER ();
    LexInput	*lex;

    lex = MemAllocate (&lexInputType, sizeof (*lex));
    lex->file = file;
    lex->name = name;
    lex->lineno = 0;
    lex->at_bol = True;
    lex->at_eof = False;
    lex->interactive = interactive;
    if (after)
    {
	LexInput **prev;
	
	for (prev = &lexInput; *prev; prev = &(*prev)->next)
	    ;
	lex->next = 0;
	*prev = lex;
    } else {
	lex->next = lexInput;
	lexInput = lex;
    }
    EXIT ();
}

ReferencePtr	LexInputReference;

void
LexInit (void)
{
    ENTER ();

    LexInputReference = NewReference ((void **) &lexInput);
    MemAddRoot (LexInputReference);
    EXIT ();
}

Atom
LexFileName (void)
{
    if (lexInput)
	return lexInput->name;
    return AtomId ("<initialization>");
}

int
LexFileLine (void)
{
    if (lexInput)
	return lexInput->lineno;
    return 0;
}

Bool
LexInteractive (void)
{
    if (lexInput)
	return lexInput->interactive;
    return False;
}

Bool
LexResetInteractive (void)
{
    while (lexInput->next && !lexInput->interactive)
    {
	FileClose (lexInput->file);
	lexInput = lexInput->next;
    }
    if (lexInput->interactive)
	return True;
    return False;
}

Bool
LexFile (char *s, Bool complain, Bool after)
{
    Value	f;
    int		err;

    f = FileFopen (s, "r", &err);
    if (f == 0) {
	if (complain)
	    (void) FilePrintf (FileStderr, "%s: %s\n",
			       s, FileGetErrorMessage (err));
	return False;
    }
    (void) NewLexInput(f, AtomId (s), after, False);
    return True;
}

static int
LexGetChar (void)
{
    int	    c;

    for (;;)
    {
	c = FileInput (lexInput->file);
	if (c >= 0)
	    return c;
	if (c == FileBlocked)
	    ThreadsRun (0, lexInput->file);
	else
	{
	    if (!lexInput->next)
		return FileEOF;
	    lexInput->at_eof = True;
	    return '\n';
	}
    }
}

#ifdef HAVE_LIBREADLINE
static int
ReadlineGetChar (FILE *f)
{
    return LexGetChar ();
}
#endif

static Value
prompt (void)
{
    Value	v;
    
    if (ignorenl)
	v = lookupVar (0, "prompt2");
    else if (CurrentFrame)
	v = lookupVar (0, "prompt3");
    else
	v = lookupVar (0, "prompt");
    return v;
}

static int
LexGetInteractiveChar (void)
{
#ifdef HAVE_LIBREADLINE
    static char	*line, *line_base;
    int	    c;

    if (!line)
    {
	char    *p;
	Value	v;

	v = prompt ();
	p = StrzPart (prompt (), "invalid prompt");
	if (!p)
	    p = "??? ";
	for (;;)
	{
	    FileFlush (FileStdout, False);
	    if (FileStdout->file.flags & FileOutputBlocked)
		ThreadsRun (0, FileStdout);
	    else
		break;
	}
	rl_getc_function = ReadlineGetChar;
	rl_inhibit_completion = 1;
	line_base = readline (p);
	line = line_base;
	if (!line)
	    return FileEOF;
	add_history (line_base);
    }
    c = (*line++) & 0xff;
    if (!c)
    {
	c = '\n';
	free (line_base);
	line = 0;
    }
    return c;
#else
    if (lexInput->at_bol)
    {
	Value	v = prompt ();
	Print (FileStdout, v, 's', 0, 0, 0, ' ');
	FileFlush (FileStdout, True);
    }
    return LexGetChar ();
#endif
}

#undef YY_INPUT
#define YY_NO_UNPUT

static int yy_input (char *buf, int max_size)
{
    int	    c;
    int	    result = 0;
    
    if (lexInput->at_bol) { lexInput->lineno++; }
    while (result < max_size) {
	if (lexInput->at_eof)
	{
	    FileClose (lexInput->file);
	    lexInput = lexInput->next;
	}
	if (lexInput->interactive)
	    c = LexGetInteractiveChar ();
	else
	    c = LexGetChar ();
	lexInput->at_bol = False;
	if (c < 0) 
	    break;
	buf[result++] = c;
	if (c == '\n')
	{
	    lexInput->at_bol = True;
	    break;
	}
    }
    return result;
}

#define YY_INPUT(buf,result,max_size) ((result) = yy_input (buf, max_size))
    
#ifndef FLEX_SCANNER
#undef		input
#undef		unput
int input (void)
{
    char    buf[1];
    int	    r;

    YY_INPUT(buf, r, 1);
    if (r == 0)
	return 0;
    return buf[0];
}

void unput (char c)
{
    if (c == '\n')
	lexInput->lineno--;
    FileUnput (lexInput->file, c);
}
#endif

#line 1000 "lex.c"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

    static void yyunput (int c,char *buf_ptr  );
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 295 "lex.l"

#line 1156 "lex.c"

	if ( (yy_init) )
		{
		(yy_init) = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 359 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 604 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 296 "lex.l"
{   
		    if (seeComment) 
		    {
			yylval.value = lexdoc ();
			return COMMENT_CONST;
		    }
		    else
			skipcomment (); 
		}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 305 "lex.l"
skipline();
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 306 "lex.l"
{ yylval.class = class_auto; return AUTO; }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 307 "lex.l"
{ yylval.class = class_const; return CONST; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 308 "lex.l"
{ yylval.class = class_global; return GLOBAL; }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 309 "lex.l"
{ yylval.class = class_static; return STATIC; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 310 "lex.l"
{ yylval.type = typePrim[rep_func]; return FUNCTION; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 311 "lex.l"
{ yylval.ints = WHILE; return WHILE; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 312 "lex.l"
{ yylval.ints = FOR; return FOR; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 313 "lex.l"
{ yylval.ints = DO; return DO; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 314 "lex.l"
{ yylval.ints = IF; return IF; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 315 "lex.l"
{ yylval.ints = ELSE; return ELSE; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 316 "lex.l"
{ yylval.ints = SWITCH; return SWITCH; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 317 "lex.l"
{ yylval.ints = BREAK; return BREAK; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 318 "lex.l"
{ yylval.ints = CONTINUE; return CONTINUE; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 319 "lex.l"
{ yylval.ints = CASE; return CASE; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 320 "lex.l"
{ yylval.ints = DEFAULT; return DEFAULT; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 321 "lex.l"
{ yylval.ints = RETURNTOK; return RETURNTOK; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 322 "lex.l"
{ yylval.ints = TRY; return TRY; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 323 "lex.l"
{ yylval.ints = CATCH; return CATCH; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 324 "lex.l"
{ yylval.ints = TWIXT; return TWIXT; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 326 "lex.l"
{ yylval.type = typePoly; return POLY; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 327 "lex.l"
{ yylval.type = typePrim[rep_bool]; return BOOL; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 328 "lex.l"
{ yylval.type = typePrim[rep_integer]; return INTEGER; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 329 "lex.l"
{ yylval.type = typePrim[rep_rational]; return RATIONAL; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 330 "lex.l"
{ yylval.type = typePrim[rep_float]; return REAL; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 331 "lex.l"
{ yylval.type = typePrim[rep_string]; return STRING; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 332 "lex.l"
{ yylval.type = typePrim[rep_file]; return FILET; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 333 "lex.l"
{ yylval.type = typePrim[rep_semaphore]; return SEMAPHORE; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 334 "lex.l"
{ yylval.type = typePrim[rep_continuation]; return CONTINUATION; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 335 "lex.l"
{ yylval.type = typePrim[rep_thread]; return THREAD; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 336 "lex.l"
{ yylval.ints = STRUCT; return STRUCT; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 337 "lex.l"
{ yylval.ints = UNION; return UNION; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 338 "lex.l"
{ yylval.ints = ENUM; return ENUM; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 339 "lex.l"
{ yylval.type = typePrim[rep_void]; return VOID; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 340 "lex.l"
{ yylval.value = TrueVal; return BOOLVAL; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 341 "lex.l"
{ yylval.value = FalseVal; return BOOLVAL; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 343 "lex.l"
{ yylval.ints = TYPEDEF; return TYPEDEF; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 344 "lex.l"
{ yylval.ints = FUNC; return FUNC; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 345 "lex.l"
{ yylval.ints = FORK; return FORK; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 346 "lex.l"
{ yylval.ints = NAMESPACE; return NAMESPACE; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 347 "lex.l"
{ yylval.ints = IMPORT; return IMPORT; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 348 "lex.l"
{ yylval.ints = EXCEPTION; return EXCEPTION; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 349 "lex.l"
{ yylval.ints = RAISE; return RAISE; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 350 "lex.l"
{ yylval.publish = publish_protected; return PROTECTED; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 351 "lex.l"
{ yylval.publish = publish_public; return PUBLIC; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 352 "lex.l"
{ yylval.publish = publish_extend; return EXTEND; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 353 "lex.l"
{ yylval.ints = SEMI; return SEMI; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 354 "lex.l"
{ yylval.ints = COMMA; return COMMA; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 355 "lex.l"
{ yylval.ints = DOLLAR; return DOLLAR; }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 356 "lex.l"
{ yylval.ints = DOTDOTDOT; return DOTDOTDOT; }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 357 "lex.l"
{ yylval.ints = DOT; return DOT; }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 358 "lex.l"
{ yylval.ints = ARROW; return ARROW; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 359 "lex.l"
{ yylval.ints = DARROW; return DARROW; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 360 "lex.l"
{ yylval.value = Void; return VOIDVAL; }
	YY_BREAK
case 56:
/* rule 56 can match eol */
YY_RULE_SETUP
#line 361 "lex.l"
{ 
		    if (lexInput->at_eof) { strcpy (yytext, "EOF"); yylval.ints = ENDFILE; return ENDFILE; }
		    if (!ignorenl) { yylval.ints = NL; return NL; } 
		}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 365 "lex.l"
{ yylval.ints = OP; ++ignorenl; return OP; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 366 "lex.l"
{ yylval.ints = CP; --ignorenl; return CP; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 367 "lex.l"
{ yylval.ints = STAROS; ++ignorenl; return STAROS; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 368 "lex.l"
{ yylval.ints = OS; ++ignorenl; return OS; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 369 "lex.l"
{ yylval.ints = CS; --ignorenl; return CS; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 370 "lex.l"
{ yylval.ints = OC; ++ignorenl; return OC; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 371 "lex.l"
{ yylval.ints = CC; --ignorenl; return CC; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 372 "lex.l"
{ yylval.ints = ASSIGNPLUS; return ASSIGNPLUS; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 373 "lex.l"
{ yylval.ints = ASSIGNMINUS; return ASSIGNMINUS; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 374 "lex.l"
{ yylval.ints = ASSIGNTIMES; return ASSIGNTIMES; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 375 "lex.l"
{ yylval.ints = ASSIGNDIVIDE; return ASSIGNDIVIDE; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 376 "lex.l"
{ yylval.ints = ASSIGNDIV; return ASSIGNDIV; }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 377 "lex.l"
{ yylval.ints = ASSIGNMOD; return ASSIGNMOD; }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 378 "lex.l"
{ yylval.ints = ASSIGNPOW; return ASSIGNPOW; }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 379 "lex.l"
{ yylval.ints = ASSIGNSHIFTL; return ASSIGNSHIFTL; }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 380 "lex.l"
{ yylval.ints = ASSIGNSHIFTR; return ASSIGNSHIFTR; }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 381 "lex.l"
{ yylval.ints = ASSIGNLXOR; return ASSIGNLXOR; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 382 "lex.l"
{ yylval.ints = ASSIGNLAND; return ASSIGNLAND; }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 383 "lex.l"
{ yylval.ints = ASSIGNLOR; return ASSIGNLOR; }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 384 "lex.l"
{ yylval.ints = ASSIGN; return ASSIGN; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 386 "lex.l"
{ yylval.ints = PLUS; return PLUS; }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 387 "lex.l"
{ yylval.ints = MINUS; return MINUS; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 388 "lex.l"
{ yylval.ints = TIMES; return TIMES; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 389 "lex.l"
{ yylval.ints = DIVIDE; return DIVIDE; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 390 "lex.l"
{ yylval.ints = DIV; return DIV; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 391 "lex.l"
{ yylval.ints = STARSTAR; return STARSTAR; }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 392 "lex.l"
{ yylval.ints = MOD; return MOD; }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 393 "lex.l"
{ yylval.ints = BANG; return BANG; }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 394 "lex.l"
{ yylval.ints = POUND; return POUND; }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 395 "lex.l"
{ yylval.ints = LAND; return LAND; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 396 "lex.l"
{ yylval.ints = LOR; return LOR; }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 397 "lex.l"
{ yylval.ints = LXOR; return LXOR; }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 398 "lex.l"
{ yylval.ints = LNOT; return LNOT; }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 399 "lex.l"
{ yylval.ints = INC; return INC; }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 400 "lex.l"
{ yylval.ints = DEC; return DEC; }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 401 "lex.l"
{ yylval.ints = EQ; return EQ; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 402 "lex.l"
{ yylval.ints = NE; return NE; }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 403 "lex.l"
{ yylval.ints = LT; return LT; }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 404 "lex.l"
{ yylval.ints = GT; return GT; }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 405 "lex.l"
{ yylval.ints = LE; return LE; }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 406 "lex.l"
{ yylval.ints = GE; return GE; }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 407 "lex.l"
{ yylval.ints = AND; return AND; }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 408 "lex.l"
{ yylval.ints = OR; return OR; }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 409 "lex.l"
{ yylval.ints = SHIFTL; return SHIFTL; }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 410 "lex.l"
{ yylval.ints = SHIFTR; return SHIFTR; }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 411 "lex.l"
{ yylval.ints = QUEST; return QUEST; }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 412 "lex.l"
{ yylval.ints = COLONCOLON; return COLONCOLON; }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 413 "lex.l"
{ yylval.ints = COLON; return COLON; }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 414 "lex.l"
;
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 415 "lex.l"
;
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 416 "lex.l"
{
			ENTER ();
			char	 *s;
			long	len = yyleng - 1;
			int	c;
			s = yytext + 1;
			s = StringNextChar (s, &c, &len);
			if (c == '\\')
			{
			    if (!(s = StringNextChar (s, &c, &len)))
				c = 0;
			    else if ('0' <= c && c <= '7')
			    {
				int	ch;
				char    *ps = s;
				c = c - '0';
				while ((s = StringNextChar (s, &ch, &len)) &&
				       '0' <= ch && ch <= '7')
				{
				    c = (c << 3) | (ch - '0');
				    ps = s;
				}
				s = ps;
			    }
			    else
				c = lexEscape (c);
			}
			yylval.value = NewInt (c);
			EXIT ();
			REFERENCE (yylval.value);
			return CHAR_CONST;
		}
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 448 "lex.l"
{
			ENTER ();
			char	*d, *s;
			int	c;
			long	len = yyleng - 2;

			yylval.value = NewString (len);
			d = StringChars (&yylval.value->string);
			s = yytext + 1;
			while ((s = StringNextChar (s, &c, &len)))
			{
			    if (c == '\\')
			    {
				if (!(s = StringNextChar (s, &c, &len)))
				    break;
				if ('0' <= c && c <= '7')
				{
				    int	    ch;
    				    char    *ps = s;
				    long    plen = len;
				    c = c - '0';
				    while ((s = StringNextChar (s, &ch, &len)) &&
					   '0' <= ch && ch <= '7')
				    {
					c = (c << 3) | (ch - '0');
					ps = s;
					plen = len;
				    }
				    s = ps;
				    len = plen;
				}
				else
				    c = lexEscape (c);
			    }
			    d += StringPutChar (c, d);
			}
			*d = '\0';
			yylval.value->string.length = d - StringChars(&yylval.value->string);
			EXIT ();
			REFERENCE (yylval.value);
			return STRING_CONST;
		}
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 490 "lex.l"
{
		yylval.value = atov(yytext+1, 8);
		if (yytext[1] == '\0')
		    return TEN_NUM;
	        else
		    return OCTAL0_NUM;
		}
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 497 "lex.l"
{
		yylval.value = atov(yytext+2, 8);
		return OCTAL_NUM;
		}
	YY_BREAK
case 111:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 501 "lex.l"
{
		yylval.value = aetov(yytext+2, 8);
		return OCTAL_FLOAT;
		}
	YY_BREAK
case 112:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 505 "lex.l"
{
		yylval.value = atov(yytext+2, 8);
		return OCTAL_NUM;
		}
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 509 "lex.l"
{
		yylval.value = aetov (yytext+2, 8);
		return OCTAL_FLOAT;
		}
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 513 "lex.l"
{
		yylval.value = atov(yytext+2, 2);
		return BINARY_NUM;
		}
	YY_BREAK
case 115:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 517 "lex.l"
{
		yylval.value = aetov(yytext+2, 2);
		return BINARY_FLOAT;
		}
	YY_BREAK
case 116:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 521 "lex.l"
{
		yylval.value = atov(yytext+2, 2);
		return BINARY_NUM;
		}
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 525 "lex.l"
{
		yylval.value = aetov (yytext+2, 2);
		return BINARY_FLOAT;
		}
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 529 "lex.l"
{
		yylval.value = atov(yytext+2, 16);
		return HEX_NUM;
		}
	YY_BREAK
case 119:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 533 "lex.l"
{
		yylval.value = aetov(yytext+2, 16);
		return HEX_FLOAT;
		}
	YY_BREAK
case 120:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 537 "lex.l"
{
		yylval.value = atov(yytext+2, 16);
		return HEX_NUM;
		}
	YY_BREAK
case 121:
YY_RULE_SETUP
#line 541 "lex.l"
{
		yylval.value = aetov (yytext+2, 16);
		return HEX_FLOAT;
		}
	YY_BREAK
case 122:
YY_RULE_SETUP
#line 545 "lex.l"
{
		yylval.value = atov(yytext, 10);
		return TEN_NUM;
		}
	YY_BREAK
case 123:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 3;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 549 "lex.l"
{
		yylval.value = aetov(yytext, 10);
		return TEN_FLOAT;
		}
	YY_BREAK
case 124:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 553 "lex.l"
{
		yylval.value = atov(yytext, 10);
		return TEN_NUM;
		}
	YY_BREAK
case 125:
YY_RULE_SETUP
#line 557 "lex.l"
{
		yylval.value = aetov (yytext, 10);
		return TEN_FLOAT;
		}
	YY_BREAK
case 126:
YY_RULE_SETUP
#line 561 "lex.l"
{
	        CommandPtr	c;
		SymbolPtr	symbol;
		yylval.atom = AtomId (yytext);
		if (!notCommand && (c = CommandFind (CurrentCommands, yylval.atom)))
		{
		    if (c->names)
			return NAMECOMMAND;
		    return COMMAND;
		}
		if (LexNamespace)
		    symbol = NamespaceFindName (LexNamespace, yylval.atom, False);
	        else
		    symbol = NamespaceFindName (CurrentNamespace, yylval.atom, True);
		if (symbol)
		{
		    switch (symbol->symbol.class) {
		    case class_namespace:
			return NAMESPACENAME;
		    case class_typedef:
			return TYPENAME;
		    default:
			break;
		    }
		}
		return NAME;
		}
	YY_BREAK
case 127:
YY_RULE_SETUP
#line 588 "lex.l"
FilePrintf (FileStderr, "character \\%o ignored\n", *yytext & 0xff);
	YY_BREAK
case 128:
YY_RULE_SETUP
#line 589 "lex.l"
ECHO;
	YY_BREAK
#line 2068 "lex.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 359 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 359 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 358);

	return yy_is_jam ? 0 : yy_current_state;
}

    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param str a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yy_str )
{
    
	return yy_scan_bytes(yy_str,strlen(yy_str) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * bytes, int  len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void yyset_lineno (int  line_number )
{
    
    yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  in_str )
{
        yyin = in_str ;
}

void yyset_out (FILE *  out_str )
{
        yyout = out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  bdebug )
{
        yy_flex_debug = bdebug ;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
    	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
    	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#undef YY_NEW_FILE
#undef YY_FLUSH_BUFFER
#undef yy_set_bol
#undef yy_new_buffer
#undef yy_set_interactive
#undef yytext_ptr
#undef YY_DO_BEFORE_ACTION

#ifdef YY_DECL_IS_OURS
#undef YY_DECL_IS_OURS
#undef YY_DECL
#endif
#line 589 "lex.l"



int
lexEscape (int c)
{
    switch (c) {
    case '0':
	return '\0';
	break;
    case 'b':
	return '\b';
	break;
    case 'n':
	return '\n';
	break;
    case 'r':
	return '\r';
	break;
    case 't':
	return '\t';
	break;
    case 'f':
	return '\f';
	break;
    case 'v':
	return '\v';
	break;
    default:
	return c;
    }
}


Value
lexdoc (void)
{
    int	    c;
    Value   s = NewStrString ("");

    c = input();
    if (lexInput->at_eof)
    {
bail:	
        yyerror ("Missing */ at end of file");
        return Void;
    }
    for (;;) {
	Bool skip = False;
	while (c != EOF && c != '*')
	{
	    if (skip && c != ' ' && c != '\t')
		skip = False;
	    if (!skip)
		s = Plus (s, NewCharString (c));
	    if (c == '\n')
		skip = True;
	    c = input();
	    if (c == EOF || lexInput->at_eof)
		goto bail;
	}
	c = input();
	if (c == EOF || lexInput->at_eof)
	    goto bail;
	if (c == '/')
	    break;
	if (!skip)
	    s = Plus (s, NewCharString ('*'));
    }
    return s;
}

void
skipcomment (void)
{
    int	c;

    c = input();
    if (lexInput->at_eof)
    {
bail:	
        yyerror ("Missing */ at end of file");
        return;
    }
    for (;;) {
	while (c != EOF && c != '*')
	{
	    c = input();
	    if (c == EOF || lexInput->at_eof)
		goto bail;
	}
	c = input();
	if (c == EOF || lexInput->at_eof)
	    goto bail;
	if (c == '/')
	    return;
    }
}

void
skipline (void)
{
    int	    c;

    do {
	c = input();
    } while (c != EOF && c != '\n');
}

Value
atov (char *s, int base)
{
    ENTER ();
    Value	result;
    Value	b;
    char	c;
    int		i;

    b = NewInt (base);
    result = NewInt (0);
    for (;;) {
	c = *s++;
	if ('0' <= c  && c <= '9')
	    i = c - '0';
	else if ('a' <= c && c <= 'z')
	    i = c - 'a' + 10;
	else if ('A' <= c && c <= 'Z')
	    i = c - 'A' + 10;
	else
	    break;
	if (i >= base)
	    break;
	result = Plus (NewInt (i), Times (result, b));
    }
    RETURN (result);
}

Value
aetov (char *s, int base)
{
    ENTER ();
    char    *int_part, *frac_part, *rep_part, *exp_part, *next;
    int	    sign, frac_len, rep_len, esign;
    Value   v, sv;

    int_part = s;
    sign = 1;
    if (*int_part == '+')
	int_part++;
    else if (*int_part == '-') {
	int_part++;
	sign = -1;
    }
    next = int_part;
    frac_part = strchr (next, '.');
    frac_len = -1;
    rep_part = 0;
    rep_len = 0;
    esign = 1;
    if (frac_part) {
	frac_part++;
	next = frac_part;
	rep_part = strchr (next, '{');
	if (rep_part)
	{
	    frac_len = rep_part - frac_part;
	    rep_part++;
	    next = strchr (rep_part, '}');
	    if (!next)
		RETURN (Void);	    /* "can't" happen */
	    rep_len = next - rep_part;
	    next = next + 1;
	}
    }
    exp_part = strchr (next, 'e');
    if (!exp_part)
	exp_part = strchr (next, 'E');
    if (exp_part) {
	if (frac_len < 0)
	    frac_len = exp_part - frac_part;
	exp_part++;
	if (*exp_part == '+')
	    exp_part++;
	else if (*exp_part == '-') {
	    esign = -1;
	    exp_part++;
	}
    } else if (frac_len < 0 && frac_part)
	frac_len = strlen(frac_part);
    v = atov (int_part, base);
    if (frac_part)
    {
	v = Plus (v, Divide (atov (frac_part, base),
				 Pow (NewInt (base),
				       NewInt (frac_len))));
    }
    if (rep_part)
    {
	Value	rep;
	
	rep = Divide (atov (rep_part, base), Minus (Pow (NewInt (base),
						       NewInt (rep_len)),
						  One));
	if (frac_len)
	    rep = Divide (rep, Pow (NewInt (base),
				    NewInt (frac_len)));
	v = Plus (v, rep);
    }
    if (exp_part) 
    {
	sv = Pow (NewInt (base), atov (exp_part, base));
	if (esign > 0)
	    v = Times (v, sv);
	else
	    v = Divide (v, sv);
    }
    if (sign == -1)
	v = Negate (v);
    RETURN (v);
}


