/*
 *  Nikwi Deluxe
 *  Copyright (C) 2006  Kostas Michalopoulos
 *  
 *  A game by Kostas "Bad Sector" Michalopoulos
 *  email: badsector@slashstone.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
** Nikwi Engine - Tiles
*/

#include "nikwi.h"

TileClass	**tileClass;
uint		tileClasses;

//Tile
Tile::Tile(uint code)
{
	tclass = findTileClass(code);
	state = new SpriteState(tclass->sprite);
}

Tile::~Tile()
{
	delete state;
}

//Globals
void initTiles()
{
	BadCFGNode	*tiles = loadCFG("data/tiles.txt");
	
	for (BadCFGNode *tile=tiles->child;tile;tile = tile->next)
	{
		TileClass	*tc = new TileClass;
		tc->sprite = findSprite(tile->value);
		tc->code = makeCode(getBadCFGValue(tile, "code", "????"));
		tileClass = (TileClass**)realloc(tileClass, sizeof(TileClass*)*
			(tileClasses + 1));
		tileClass[tileClasses++] = tc;
	}
}

void shutdownTiles()
{
	for (uint i=0;i<tileClasses;i++)
		delete tileClass[i];
	free(tileClass);
}

TileClass *findTileClass(uint code)
{
	for (uint i=0;i<tileClasses;i++)
		if (code == tileClass[i]->code)
			return tileClass[i];
	return NULL;
}

