# -*- coding: ascii -*-
#
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2003-2007 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: config.py,v 1.15 2007/04/10 14:45:38 shy Exp $
#

import __builtin__
import codecs

class Config(dict):

    def get(self, name, default=None):
        if isinstance(name, list):
            keylist = name
        else:
            keylist = [name]
        for key in keylist:
            if key in self:
                return self[key]
        return default

    def getint(self, name, default=None):
        value = self.get(name)
        if value:
            try:
                return int(value)
            except ValueError:
                pass
        return default

    def getfloat(self, name, default=None):
        value = self.get(name)
        if value:
            try:
                return float(value)
            except ValueError:
                pass
        return default

    def adjust(self, name, base, default=None):
        value = self.get(name)
        if value:
            try:
                if value.startswith('--'):
                    return int(value[1:])
                value = int(value)
            except (TypeError, ValueError):
                value = default
        if value is not None and value < 0:
            value = base + value
        return value

    def __str__(self):
        buf = []
        for item in self.iteritems():
            buf.append('%s,%s\n' % item)
        return ''.join(buf)


def open(path):
    f = __builtin__.open(path)
    buf = []
    for line in f:
        if not line.strip():
            continue
        buf.append(line)
    f.close()
    return new_config(buf)

def new_config(buf):
    dic = Config()
    charset = 'Shift_JIS' # default
    for line in buf:
        try:
            key, value = line.split(',', 1)
        except ValueError:
            continue
        if key.strip() == 'charset':
            try:
                codecs.lookup(charset)
            except:
                print 'Unsupported charset %s' % value.strip()
            else:
                charset = value.strip()
        elif key.strip() in ['refreshundeletemask', 'icon', 'cursor',
                             'shiori', 'makoto']:
            dic[key.strip()] = value.strip()
        else:
            dic[key.strip()] = unicode(value, charset, 'replace').strip()
    return dic

def null_config():
    return Config()
