# -*- coding: utf-8 -*-
#
#  bln.py - a easyballoon compatible Saori module for ninix
#  Copyright (C) 2002-2009 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

# TODO:
# - font.face
# - \l

import os
import random
import math
import time
import sys

if 'DISPLAY' in os.environ:
    if 'gtk' not in sys.modules:
        try:
            import pygtk
            pygtk.require('2.0')
        except ImportError:
            pass
    import gtk
    import gobject
    import pango
    import ninix.pix
else:
    gtk = None

import ninix.script
from ninix.dll import SAORI


class Saori(SAORI):

    def __init__(self):
        SAORI.__init__(self)
        self.blns = {}
        self.__sakura = None

    def need_ghost_backdoor(self, sakura):
        self.__sakura = sakura

    def check_import(self):
        if self.__sakura and gtk:
            return 1
        else:
            return 0

    def setup(self):
        self.blns = self.read_bln_txt(self.dir)
        if self.blns:
            return 1
        else:
            return 0

    def read_bln_txt(self, dir):
        blns = {}
        try:
            f = open(os.path.join(dir, 'bln.txt'), 'r')
            data = {}
            name = ''
            for line in f:
                line = line.strip()
                if not line:
                    continue
                if line.startswith('//'):
                    continue
                if '[' in line:
                    if name:
                        blns[name] = (data, {})
                    data = {}
                    start = line.find('[')
                    end = line.find(']')
                    if end < 0:
                        end = len(line)
                    name = line[start + 1:end]
                else:
                    if ',' in line:
                        key, value = [x.strip() for x in line.split(',', 1)]
                        data[key] = value
            if name:
                blns[name] = (data, {})
            return blns
        except:
            return None

    def finalize(self):
        for name in self.blns:
            data, bln = self.blns[name]
            for bln_id in bln.keys():
                if bln[bln_id]:
                    bln[bln_id].destroy()
                    del bln[bln_id]
        self.blns = {}
        return 1

    def execute(self, argument):
        if not argument:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'
        name = argument[0]
        if len(argument) >= 2:
            text = argument[1]
        else:
            text = ''
        if len(argument) >= 3:
            try:
                offset_x = int(argument[2])
            except:
                offset_x = 0
        else:
            offset_x = 0
        if len(argument) >= 4:
            try:
                offset_y = int(argument[3])
            except:
                offset_y = 0
        else:
            offset_y = 0
        if len(argument) >= 5:
            bln_id = argument[4]
        else:
            bln_id = ''
        if len(argument) >= 6 and argument[5] in ['1', '2']:
            update = int(argument[5])
        else:
            update = 0
        if name in self.blns:
            data, bln = self.blns[name]
            if bln_id in bln and update == 0:
                bln[bln_id].destroy()
                del bln[bln_id]
            if text:
                if update == 0 or bln_id not in bln:
                    bln[bln_id] = Balloon(self.__sakura, self.prefs, self.dir,
                                          data, text,
                                          offset_x, offset_y, name, bln_id)
                else:
                    bln[bln_id].update_script(text, update)
            self.blns[name] = (data, bln)
        elif name == 'clear':
            for name in self.blns:
                data, bln = self.blns[name]
                if bln_id in bln and \
                   bln[bln_id].get_state() != 'orusuban':
                    bln[bln_id].destroy()
                    del bln[bln_id]
                    self.blns[name] = (data, {})
        return None

class Balloon:

    def __init__(self, sakura, prefs, dir, data,
                 text, offset_x, offset_y, name, bln_id):
        self.dir = dir
        self.__sakura = sakura
        self.prefs = prefs
        self.dragged = 0
        self.name = name
        self.id = bln_id
        if 'position' not in data:
            self.position = 'sakura'
        else:
            self.position = data['position']
        self.window = gtk.Window(type=gtk.WINDOW_POPUP)
        self.window.connect('delete_event', self.delete)
        if 'clickerase' in data and data['clickerase'] == 'off':
            self.clickerase = 'off'
        else:
            self.clickerase = 'on'
        if 'dragmove.horizontal' in data and \
           data['dragmove.horizontal'] == 'on':
            self.dragmove_horizontal = 1
        else:
            self.dragmove_horizontal = 0
        if 'dragmove.vertical' in data and \
           data['dragmove.vertical'] == 'on':
            self.dragmove_vertical = 1
        else:
            self.dragmove_vertical = 0
        self.window.connect('button_press_event', self.button_press)
        self.window.connect('button_release_event', self.button_release)
        self.window.connect('motion_notify_event', self.motion_notify)
        self.window.connect('leave_notify_event', self.leave_notify)
        self.window.set_events(gtk.gdk.BUTTON_PRESS_MASK|
                               gtk.gdk.BUTTON_RELEASE_MASK|
                               gtk.gdk.POINTER_MOTION_MASK|
                               gtk.gdk.LEAVE_NOTIFY_MASK)
        left, top, scrn_w, scrn_h = ninix.pix.get_workarea()
        s0_x, s0_y, s0_w, s0_h = self.get_sakura_status('SurfaceSakura')
        s1_x, s1_y, s1_w, s1_h = self.get_sakura_status('SurfaceKero')
        b0_x, b0_y, b0_w, b0_h = self.get_sakura_status('BalloonSakura')
        b1_x, b1_y, b1_w, b1_h = self.get_sakura_status('BalloonKero')
        if s0_x + s0_w / 2 > left + scrn_w / 2:
            self.direction0 = 0 # left
        else:
            self.direction0 = 1 # right
        if s1_x + s1_w / 2 > left + scrn_w / 2:
            self.direction1 = 0 # left
        else:
            self.direction1 = 1 # right  
        if ((self.position == 'sakura' and self.direction0) or \
            (self.position == 'kero' and self.direction1)) and \
            'skin.right' in data:
            path = os.path.join(self.dir,
                                data['skin.right'].replace('\\', '/'))
        elif (self.position == 'sakura' or self.position == 'kero') and \
             'skin.left' in data:
            path = os.path.join(self.dir,
                                data['skin.left'].replace('\\', '/'))
        elif 'skin' in data:
            path = os.path.join(self.dir,
                                data['skin'].replace('\\', '/'))
        else:
            self.destroy()
            return
        try:
            balloon_pixbuf = ninix.pix.create_pixbuf_from_file(path)
        except:
            self.destroy()
            return
        self.x = left
        self.y = top
        self.scale = self.get_sakura_status('SurfaceScale') ## FIXME
        w = balloon_pixbuf.get_width()
        h = balloon_pixbuf.get_height()
        if self.scale != 100:
            w = max(1, int(w * self.scale / 100))
            h = max(1, int(h * self.scale / 100))
            balloon_pixbuf = balloon_pixbuf.scale_simple(
                w, h, gtk.gdk.INTERP_BILINEAR)
        balloon_pixmap, mask_pixmap = balloon_pixbuf.render_pixmap_and_mask(1)
        del balloon_pixbuf
        if self.position == 'lefttop':
            pass
        elif self.position == 'leftbottom':
            self.y = top + scrn_h - h
        elif self.position == 'righttop':
            self.x = left + scrn_w - w
        elif self.position == 'rightbottom':
            self.x = left + scrn_w - w
            self.y = top + scrn_h - h
        elif self.position == 'center':
            self.x = left + (scrn_w - w) / 2
            self.y = top + (scrn_h - h) / 2
        elif self.position == 'leftcenter':
            self.y = top + (scrn_h - h) / 2
        elif self.position == 'rightcenter':
            self.x = left + scrn_w -w
            self.y = top + (scrn_h - h) / 2
        elif self.position == 'centertop':
            self.x = left + (scrn_w - w) / 2
        elif self.position == 'centerbottom':
            self.x = left + (scrn_w - w) / 2
            self.y = top + scrn_h - h
        elif self.position == 'sakura':
            if self.direction0: # right
                self.x = s0_x + s0_w
            else:
                self.x = s0_x - w
            self.y = s0_y
        elif self.position == 'kero':
            if self.direction1: # right
                self.x = s1_x + s1_w
            else:
                self.x = s1_x - w
            self.y = s1_y
        elif self.position == 'sakurab':
            self.x = b0_x
            self.y = b0_y
        elif self.position == 'kerob':
            self.x = b1_x
            self.y = b1_y
        if 'offset.x' in data:
            if (self.position == 'sakura' and not self.direction0) or \
               (self.position == 'kero' and not self.direction1):
                self.x -= int(int(data['offset.x']) * self.scale / 100)
            else:
                self.x += int(int(data['offset.x']) * self.scale / 100)
        if 'offset.y' in data:
            self.y += int(int(data['offset.y']) * self.scale / 100)
        if 'offset.random' in data:
            self.x += int(int(data['offset.random']) * random.randrange(-1, 2) * self.scale / 100)
            self.y += int(int(data['offset.random']) * random.randrange(-1, 2) * self.scale / 100)
        if (self.position == 'sakura' and not self.direction0) or \
           (self.position == 'kero' and not self.direction1):
            self.x -= int(offset_x * self.scale / 100)
        else:
            self.x += int(offset_x * self.scale / 100)
        self.y += int(offset_y * self.scale / 100)
        self.window.move(self.x, self.y)
        gtk.gdk.flush()
        self.left = 0
        self.right = w
        self.top = 0
        self.bottom = h
        if 'disparea.left' in data:
            self.left = int(int(data['disparea.left']) * self.scale / 100)
        if 'disparea.right' in data:
            self.right = int(int(data['disparea.right']) * self.scale / 100)
        if 'disparea.top' in data:
            self.top = int(int(data['disparea.top']) * self.scale / 100)
        if 'disparea.bottom' in data:
            self.bottom = int(int(data['disparea.bottom']) * self.scale / 100)
        self.window.shape_combine_mask(mask_pixmap, 0, 0)
        self.script = None
        self.darea = gtk.DrawingArea()
        self.darea.set_events(gtk.gdk.EXPOSURE_MASK)
        self.darea.connect('expose_event', self.redraw)
        self.darea.set_size_request(w, h)
        self.darea.show()
        self.window.add(self.darea)
        self.darea.realize()
        self.surface_gc = self.darea.window.new_gc()
        self.darea.window.set_back_pixmap(balloon_pixmap, False)
        self.layout = None
        if text != 'noscript' and \
           (self.right - self.left) and (self.bottom - self.top):
            self.script = text
            if 'font.color' in data:
                fontcolor_r = int(data['font.color'][:2], 16)
                fontcolor_g = int(data['font.color'][2:4], 16)
                fontcolor_b = int(data['font.color'][4:6], 16)
                cmap = self.darea.get_colormap()
                self.surface_gc.foreground = cmap.alloc_color(
                    '#%02x%02x%02x' % (fontcolor_r, fontcolor_g, fontcolor_b))
            default_font_size = 12 # for Windows environment
            if 'font.size' in data:
                font_size = int(data['font.size'])
            else:
                font_size = default_font_size
            font_size = font_size * 3 / 4 # convert from Windows to GTK+
            font_size = font_size * self.scale / 100
            font_size *= pango.SCALE
            self.layout = pango.Layout(self.darea.get_pango_context())
            self.font_desc = pango.FontDescription()
            self.font_desc.set_family('Sans') # FIXME
            self.font_desc.set_size(font_size)
            if 'font.bold' in data and data['font.bold'] == 'on':
                self.font_desc.set_weight(pango.WEIGHT_BOLD)
            self.layout.set_font_description(self.font_desc)
            self.layout.set_wrap(pango.WRAP_CHAR)
            self.layout.set_width((self.right - self.left) * 1024)
        if 'slide.vx' in data:
            self.slide_vx = int(int(data['slide.vx']) * self.scale / 100)
        else:
            self.slide_vx = 0
        if 'slide.vy' in data:
            self.slide_vy = int(int(data['slide.vy']) * self.scale / 100)
        else:
            self.slide_vy = 0
        if 'slide.autostop' in data:
            self.slide_autostop = int(data['slide.autostop'])
        else:
            self.slide_autostop = 0
        if 'action.method' in data and \
           data['action.method'] in ['sinwave', 'vibrate']:
            action = data['action.method']
            ref0 = 0
            ref1 = 0
            ref2 = 0
            ref3 = 0
            if 'action.reference0' in data:
                ref0 = int(data['action.reference0'])
            if 'action.reference1' in data:
                ref1 = int(data['action.reference1'])
            if 'action.reference2' in data:
                ref2 = int(data['action.reference2'])
            if 'action.reference3' in data:
                ref3 = int(data['action.reference3'])
            if ref2:
                self.action = {'method': action,
                               'ref0': ref0,
                               'ref1': ref1,
                               'ref2': ref2,
                               'ref3': ref3}
            else:
                self.action = None
        else:
            self.action = None
        self.move_notify_time = None
        self.life_time = None
        self.state = ''
        if 'life' in data:
            life = data['life']
            if life == 'auto':
                self.life_time = 16000
            elif life in ['infinitely', '0']:
                pass
            elif life == 'orusuban':
                self.state = 'orusuban'
            else:
                try:
                    self.life_time = int(life)
                except:
                    pass
        else:
            self.life_time = 16000
        self.start_time = time.time()
        if 'startdelay' in data:
            self.startdelay = int(data['startdelay'])
        else:
            self.startdelay = 0
        self.nooverlap = 0
        if 'nooverlap' in data:
            self.nooverlap = 1
        self.talking = self.get_sakura_is_talking()
        self.move_notify_time = time.time()
        self.timeout_id = None
        self.visible = 0
        self.x_root = None
        self.y_root = None
        self.action_x = 0
        self.action_y = 0
        self.vx = 0
        self.vy = 0
        self.text_pos_x = self.left
        self.text_pos_y = self.top
        self.processed_script = None
        self.processed_text = ''
        self.text = ''
        self.script_wait = None
        self.quick_session = 0
        self.script_parser = ninix.script.Parser(error='loose')
        try:
            self.processed_script = self.script_parser.parse(self.script)
        except ninix.script.ParserError, e:
            self.processed_script = None
            print '-' * 50
            print e
            print self.script                                    
        self.timeout_id = gobject.timeout_add(10, self.do_idle_tasks)

    def update_script(self, text, mode):
        if text:
            if mode == 2 and self.script is not None:
                self.script = ''.join((self.script, text))
            else:
                self.script = text
            self.processed_script = None
            self.processed_text = ''
            self.text = ''
            self.script_wait = None
            self.quick_session = 0
            try:
                self.processed_script = self.script_parser.parse(self.script)
            except ninix.script.ParserError, e:
                self.processed_script = None
                print '-' * 50
                print e
                print self.script                                    

    def get_sakura_is_talking(self):
        talking = 0
        try:
            if self.__sakura.is_talking():
                talking = 1
        except:
            pass
        return talking

    def get_sakura_status(self, key):
        if key == 'SurfaceScale':
            return self.prefs.get('surface_scale')
        elif key == 'SurfaceSakura_Shown':
            if self.__sakura.surface_is_shown(0):
                s0_shown = 1
            else:
                s0_shown = 0
            return s0_shown
        elif key == 'SurfaceSakura':
            try:
                s0_x, s0_y = self.__sakura.get_surface_position(0)
                s0_w, s0_h = self.__sakura.get_surface_size(0)
            except:
                s0_x, s0_y = 0, 0
                s0_w, s0_h = 0, 0
            return s0_x, s0_y, s0_w, s0_h
        elif key == 'SurfaceKero_Shown':
            if self.__sakura.surface_is_shown(1):
                s1_shown = 1
            else:
                s1_shown = 0
            return s1_shown
        elif key == 'SurfaceKero':
            try:
                s1_x, s1_y = self.__sakura.get_surface_position(1)
                s1_w, s1_h = self.__sakura.get_surface_size(1)
            except:
                s1_x, s1_y = 0, 0
                s1_w, s1_h = 0, 0
            return s1_x, s1_y, s1_w, s1_h
        elif key == 'BalloonScale':
            if self.prefs.get('balloon_scalling'):
                return self.prefs.get('surface_scale')
            else:
                return 100
        elif key == 'BalloonSakura_Shown':
            if self.__sakura.balloon_is_shown(0):
                b0_shown = 1
            else:
                b0_shown = 0
            return b0_shown
        elif key == 'BalloonSakura':
            try:
                b0_x, b0_y = self.__sakura.get_balloon_position(0)
                b0_w, b0_h = self.__sakura.get_balloon_size(0)
            except:
                b0_x, b0_y = 0, 0
                b0_w, b0_h = 0, 0
            return b0_x, b0_y, b0_w, b0_h
        elif key == 'BalloonKero_Shown':
            if self.__sakura.balloon_is_shown(1):
                b1_shown = 1
            else:
                b1_shown = 0
            return b1_shown
        elif key == 'BalloonKero':
            try:
                b1_x, b1_y = self.__sakura.get_balloon_position(1)
                b1_w, b1_h = self.__sakura.get_balloon_size(1)
            except:
                b1_x, b1_y = 0, 0
                b1_w, b1_h = 0, 0
            return b1_x, b1_y, b1_w, b1_h
        else:
            return None

    def do_idle_tasks(self):
        if not self.window:
            return None
        s_scale = self.get_sakura_status('SurfaceScale')
        b_scale = self.get_sakura_status('BalloonScale')
        s0_shown = self.get_sakura_status('SurfaceSakura_Shown')
        s1_shown = self.get_sakura_status('SurfaceKero_Shown')
        b0_shown = self.get_sakura_status('BalloonSakura_Shown')
        b1_shown = self.get_sakura_status('BalloonKero_Shown')
        sakura_talking = self.get_sakura_is_talking()
        if self.state == 'orusuban':
            if self.visible:
                if s0_shown or s1_shown:
                    self.destroy()
                    return None
            else:
                if not s0_shown and not s1_shown:
                    self.start_time = time.time()
                    self.visible = 1
                    self.window.show()
                    self.life_time = 300000
        else:
            if self.visible:
                if self.position == 'sakura' and not s0_shown:
                    self.destroy()
                    return None
                if self.position == 'kero' and not s1_shown:
                    self.destroy()
                    return None
                if self.position == 'sakurab' and not b0_shown:
                    self.destroy()
                    return None
                if self.position == 'kerob' and not b1_shown:
                    self.destroy()
                    return None
                if self.nooverlap and \
                   not self.talking and sakura_talking:
                    self.destroy()
                    return None
            else:
                if time.time() - self.start_time >= self.startdelay * 0.001:
                    self.start_time = time.time()
                    self.visible = 1
                    self.window.show()
        if self.visible:
            if self.life_time:
                if time.time() - self.start_time >= self.life_time * 0.001 and \
                   not (self.processed_script or self.processed_text):
                    self.destroy()
                    return None
                else:
                    last_time = self.life_time * 0.001 + \
                                self.start_time - time.time()
            if self.action:
                if  self.action['method'] == 'sinwave':
                    offset = self.action['ref1'] \
                             * math.sin(2.0 * math.pi
                                        * float(int((time.time() - \
                                                     self.start_time) * 1000) \
                                                % self.action['ref2'])
                                        / self.action['ref2'])
                    if self.action['ref0']:
                        self.action_y = int(offset * self.scale / 100)
                    else:
                        self.action_x = int(offset * self.scale / 100)
                elif self.action['method'] == 'vibrate':
                    offset = (int((time.time() - self.start_time) * 1000) / \
                              self.action['ref2']) % 2
                    self.action_x = int(offset * self.action['ref0'] * self.scale / 100)
                    self.action_y = int(offset * self.action['ref1'] * self.scale / 100)
            if (self.slide_vx != 0 or self.slide_vy != 0) and \
                   self.slide_autostop > 0 and \
                   self.slide_autostop * 0.001 + 0.05 <= time.time() - self.start_time:
                self.vx = int((self.slide_autostop / 50.0 + 1) * self.slide_vx * self.scale / 100)
                if (self.position == 'sakura' and not self.direction0) or \
                   (self.position == 'kero' and not self.direction1):
                    self.vx = -self.vx
                self.slide_vx = 0
                self.vy = int((self.slide_autostop / 50.0 + 1) * self.slide_vy * self.scale / 100)
                self.slide_vy = 0
            if self.slide_vx != 0:
                self.vx = int(((time.time() - self.start_time) * self.slide_vx * self.scale / 100) / 50 * 1000.)
                if (self.position == 'sakura' and not self.direction0) or \
                   (self.position == 'kero' and not self.direction1):
                    self.vx = -self.vx
            if self.slide_vy != 0:
                self.vy = int(((time.time() - self.start_time) * self.slide_vy * self.scale / 100) / 50 * 1000.)
            self.window.move(int(self.x + self.action_x + self.vx),
                             int(self.y + self.action_y + self.vy))
            if self.processed_script or self.processed_text:
                self.interpret_script()
        if self.talking and not sakura_talking:
            self.talking = 0
        else:
            self.talking = sakura_talking
        return True

    def redraw(self, widget, event):
        x, y, w, h = event.area
        self.darea.window.clear()
        if self.layout:
            self.darea.window.draw_layout(self.surface_gc,
                                          self.left, self.top, self.layout)

    def get_state(self):
        return self.state

    def interpret_script(self):
        if self.script_wait is not None:
            if time.time() < self.script_wait:
                return
            self.script_wait = None
        if self.processed_text:
            if self.quick_session or self.state == 'orusuban':
                self.text = ''.join((self.text, self.processed_text))
                self.draw_text(self.text)
                self.processed_text = ''
            else:
                self.text = ''.join((self.text, self.processed_text[0]))
                self.draw_text(self.text)
                self.processed_text = self.processed_text[1:]
                self.script_wait = time.time() + 0.014
            return
        node = self.processed_script.pop(0)
        if node[0] == ninix.script.SCRIPT_TAG:
            name, args = node[1], node[2:]
            if name == r'\n':
                self.text = ''.join((self.text, '\n'))
                self.draw_text(self.text)
            elif name == r'\w':
                if args:
                    try:
                        amount = int(args[0]) * 0.05 - 0.01
                    except ValueError:
                        amount = 0
                else:
                    amount = 1 * 0.05 - 0.01
                if amount > 0:
                    self.script_wait = time.time() + amount
            elif name == r'\b':
                if args:
                    try:
                        amount = int(args[0])
                    except ValueError:
                        amount = 0
                else:
                    amount = 1
                if amount > 0:
                    self.text = self.text[:-amount]
            elif name == r'\c':
                self.text = ''
            elif name == r'\_q':
                self.quick_session = not self.quick_session
            elif name == r'\l':
                self.life_time = None
                self.update_script('', 2)
        elif node[0] == ninix.script.SCRIPT_TEXT:
            text = ''
            for chunk in node[1]:
                text = ''.join((text, chunk[1]))
            self.processed_text = text

    def draw_text(self, text):
        self.layout.set_text(text)
        self.darea.queue_draw()

    def button_press(self, window, event):
        self.x_root = event.x_root
        self.y_root = event.y_root
        if event.type == gtk.gdk._2BUTTON_PRESS:
            if self.scale != 100:
                x = int(event.x * 100 / self.scale)
                y = int(event.y * 100 / self.scale)
            else:
                x = int(event.x)
                y = int(event.y)
            self.__sakura.notify_event('OnEBMouseDoubleClick', self.name,
                                       x, y, self.id)
        return True

    def button_release(self, window, event):
        if self.dragged:
            self.dragged = 0
        self.x_root = None
        self.y_root = None
        if self.scale != 100:
            x = int(event.x * 100 / self.scale)
            y = int(event.y * 100 / self.scale)
        else:
            x = int(event.x)
            y = int(event.y)
        if event.type == gtk.gdk.BUTTON_RELEASE:
            if event.button == 1:
                self.__sakura.notify_event('OnEBMouseClick', self.name,
                                           x, y, self.id, 0)
            elif event.button == 3:
                self.__sakura.notify_event('OnEBMouseClick', self.name,
                                           x, y, self.id, 1)
        if self.clickerase == 'on':
            self.destroy()
        return True

    def motion_notify(self, window, event):
        if self.x_root is not None and \
           self.y_root is not None:
            x_delta = int(event.x_root - self.x_root)
            y_delta = int(event.y_root - self.y_root)
            if event.state & gtk.gdk.BUTTON1_MASK:
                self.dragged = 1
                if self.dragmove_horizontal:
                    self.x += x_delta
                if self.dragmove_vertical:
                    self.y += y_delta
                self.window.move(int(self.x + self.action_x + self.vx),
                                 int(self.y + self.action_y + self.vy))
                self.x_root = event.x_root
                self.y_root = event.y_root
        if self.move_notify_time is None or \
           time.time() - self.move_notify_time > 500 * 0.001:
            if self.scale != 100:
                x = int(event.x * 100 / self.scale)
                y = int(event.y * 100 / self.scale)
            else:
                x = int(event.x)
                y = int(event.y)
            self.__sakura.notify_event('OnEBMouseMove', self.name,
                                       x, y, self.id)
            self.move_notify_time = time.time()
        return True

    def leave_notify(self, window, event):
        self.move_notify_time = None

    def delete(self, window, event):
        return True

    def destroy(self):
        self.visible = 0
        if self.window:
            self.window.destroy()
            self.window = None
        if self.timeout_id:
            gobject.source_remove(self.timeout_id)
            self.timeout_id = None
