/* Make various little popup dialogs ... error, info, question.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk 

 */

/*
#define DEBUG
 */

#include "ip.h"

#include "BITMAPS/stop.xpm"
#include "BITMAPS/info.xpm"
#include "BITMAPS/question.xpm"

#include "BITMAPS/automatic.xpm"
#include "BITMAPS/automatic1.xpm"
#include "BITMAPS/automatic2.xpm"
#include "BITMAPS/automatic3.xpm"

#define BOX_BROWSER (watch_string_get( "BROWSER", "mozilla" ))
#define BOX_BROWSER_REMOTE \
	(watch_string_get( "BROWSER_REMOTE", "-remote 'openURL(%s)'" ))

/* Find a window to use as dialog parent.
 */
static GtkWidget *
box_pick_parent( GtkWidget *par )
{	
	if( !par && mainw_window )
		/* NULL and main panel up, display there.
		 */
		return( mainw_window );
	else if( !par && !mainw_window )
		/* NULL and no main panel, display on tls.
		 */
		return( main_window_top );
	else 
		/* Use par!
		 */
		return( par );
}

/* Make the insides of a error, info or question dialog.
 */
static void
box_build( iDialog *idlg, 
	GtkWidget *work, char *s, GdkPixmap *image, GdkBitmap *mask )
{	
	GtkWidget *px;
	GtkWidget *hb;
	GtkWidget *lab;

	hb = gtk_hbox_new( FALSE, 0 );
	gtk_container_border_width( GTK_CONTAINER( hb ), 10 );
	gtk_container_add( GTK_CONTAINER( work ), hb );
	gtk_widget_show( hb );

	px = gtk_pixmap_new( image, mask );
        gtk_box_pack_start( GTK_BOX( hb ), px, FALSE, FALSE, 2 );
	gtk_widget_show( px );

	lab = gtk_label_new( s );
        gtk_label_set_justify( GTK_LABEL( lab ), GTK_JUSTIFY_LEFT );
        gtk_box_pack_start( GTK_BOX( hb ), lab, FALSE, FALSE, 2 );
	gtk_widget_show( lab );
}

/* Make an error dialog.
 */
/*VARARGS2*/
void
box_error( GtkWidget *par, const char *fmt, ... )
{
	va_list ap;
	char buf[ 10000 ];
	static GdkPixmap *px = NULL;
	static GdkBitmap *mask = NULL;
	GtkWidget *idlg;

        va_start( ap, fmt );
	(void) im_vsnprintf( buf, 10000, fmt, ap );
        va_end( ap );

	if( !px )
		px = gdk_pixmap_create_from_xpm_d( main_window_gdk,
			&mask, NULL, stop_xpm );

	idlg = idialog_new();
	iwindow_set_title( IWINDOW( idlg ), IP_NAME " error" );
	idialog_set_build( IDIALOG( idlg ), 
		(iWindowBuildFn) box_build, buf, px, mask );
	idialog_set_callbacks( IDIALOG( idlg ), NULL, NULL, NULL, NULL, NULL );
	idialog_add_ok( IDIALOG( idlg ), iwindow_true_cb, "OK" );
	idialog_set_parent( IDIALOG( idlg ), box_pick_parent( par ) );
	iwindow_build( IWINDOW( idlg ) );

	gtk_widget_show( GTK_WIDGET( idlg ) );
}

/* Display error_string in an error dialog. Do nothing if error_string is 
 * "". If we are asked to pop up on main_window_top and there is a 
 * main_window, pop up on that instead. 
 */
void
box_alert( GtkWidget *par )
{	
	if( error_string && strcmp( error_string, "" ) != 0 ) {
		if( !main_window_gdk )
			/* No X, just print.
			 */
			fprintf( stderr, "%s\n", error_string );
		else 
			box_error( par, "%s", error_string );
	}
}

/* Make the insides of a info dialog ... add a "don't show me again" toggle.
 */
static void
box_build_toggle( iDialog *idlg, 
	GtkWidget *work, char *s, GdkPixmap *image, GdkBitmap *mask )
{	
	GtkWidget *px;
	GtkWidget *hb;
	GtkWidget *lab;
	GtkWidget *tog;

	hb = gtk_hbox_new( FALSE, 0 );
	gtk_container_border_width( GTK_CONTAINER( hb ), 10 );
	gtk_container_add( GTK_CONTAINER( work ), hb );
	gtk_widget_show( hb );

	px = gtk_pixmap_new( image, mask );
        gtk_box_pack_start( GTK_BOX( hb ), px, FALSE, FALSE, 2 );
	gtk_widget_show( px );

	lab = gtk_label_new( s );
        gtk_label_set_justify( GTK_LABEL( lab ), GTK_JUSTIFY_LEFT );
        gtk_box_pack_start( GTK_BOX( hb ), lab, FALSE, FALSE, 2 );
	gtk_widget_show( lab );

	tog = build_gtoggle( work, "Don't show this dialog again" );
	gtk_widget_show( tog );
}

/* Make an information dialog.
 */
void
box_info( GtkWidget *par, const char *fmt, ... )
{
	va_list ap;
	char buf[10000];
	static GdkPixmap *px = NULL;
	static GdkBitmap *mask = NULL;
	GtkWidget *idlg;

        va_start( ap, fmt );
	(void) im_vsnprintf( buf, 10000, fmt, ap );
        va_end( ap );

	if( !px )
		px = gdk_pixmap_create_from_xpm_d( main_window_gdk,
			&mask, NULL, info_xpm );

	idlg = idialog_new();
	iwindow_set_title( IWINDOW( idlg ), IP_NAME " information" );
	idialog_set_build( IDIALOG( idlg ), 
		(iWindowBuildFn) box_build_toggle, buf, px, mask );
	idialog_set_callbacks( IDIALOG( idlg ), NULL, NULL, NULL, NULL, NULL );
	idialog_add_ok( IDIALOG( idlg ), iwindow_true_cb, "OK" );
	idialog_set_parent( IDIALOG( idlg ), box_pick_parent( par ) );
	iwindow_build( IWINDOW( idlg ) );

	gtk_widget_show( GTK_WIDGET( idlg ) );
}

static GdkPixmap *box_question_px = NULL;
static GdkBitmap *box_question_mask = NULL;

/* Pop up a `Are you sure?' window. 
 */
iDialog *
box_yesno( GtkWidget *par, 
	iWindowFn okcb, iWindowFn cancelcb, void *client, /* Call client */
	iWindowNotifyFn nfn, void *sys,			  /* Call parent */
	const char *yes_label, 
	const char *fmt, ... )
{
	va_list ap;
	char buf[ 4096 ];
	GtkWidget *idlg;

	/* Generate message.
	 */
	va_start( ap, fmt );
	(void) im_vsnprintf( buf, 4096, fmt, ap );
	va_end( ap );

	/* Load up pixmap.
	 */
	if( !box_question_px )
		box_question_px = gdk_pixmap_create_from_xpm_d( main_window_gdk,
			&box_question_mask, NULL, question_xpm );

	idlg = idialog_new();
	iwindow_set_title( IWINDOW( idlg ), IP_NAME " question" );
	idialog_set_build( IDIALOG( idlg ), 
		(iWindowBuildFn) box_build, buf, 
		box_question_px, box_question_mask );
	idialog_set_callbacks( IDIALOG( idlg ), 
		cancelcb, NULL, NULL, NULL, client );
	idialog_add_ok( IDIALOG( idlg ), okcb, yes_label );
	idialog_set_notify( IDIALOG( idlg ), nfn, sys );
	idialog_set_parent( IDIALOG( idlg ), box_pick_parent( par ) );
	iwindow_build( IWINDOW( idlg ) );

	gtk_widget_show( GTK_WIDGET( idlg ) );

	return( IDIALOG( idlg ) );
}

/* Pop up a `save'/`don't save'/`cancel' dialog.
 */
/*VARARGS3*/
void
box_savenosave( GtkWidget *par, 
	iWindowFn save, iWindowFn nosave, void *client, /* Call client */
	iWindowNotifyFn nfn, void *sys,			  /* Call parent */
	const char *fmt, ... )
{
	va_list ap;
	char buf[ 4096 ];
	GtkWidget *idlg;

	/* Generate message.
	 */
	va_start( ap, fmt );
	(void) im_vsnprintf( buf, 4096, fmt, ap );
	va_end( ap );

	/* Load up pixmap.
	 */
	if( !box_question_px )
		box_question_px = gdk_pixmap_create_from_xpm_d( main_window_gdk,
			&box_question_mask, NULL, question_xpm );

	idlg = idialog_new();
	iwindow_set_title( IWINDOW( idlg ), IP_NAME " save-nosave" );
	idialog_set_build( IDIALOG( idlg ), 
		(iWindowBuildFn) box_build, buf, 
		box_question_px, box_question_mask );
	idialog_set_callbacks( IDIALOG( idlg ), 
		iwindow_true_cb, NULL, NULL, NULL, client );
	idialog_add_ok( IDIALOG( idlg ), save, "Save" );
	idialog_add_ok( IDIALOG( idlg ), nosave, "Don't save" );
	idialog_set_notify( IDIALOG( idlg ), nfn, sys );
	idialog_set_parent( IDIALOG( idlg ), box_pick_parent( par ) );
	iwindow_build( IWINDOW( idlg ) );

	gtk_widget_show( GTK_WIDGET( idlg ) );
}

static GdkPixmap *about_px[4] = { NULL };
static GdkBitmap *about_msk[4] = { NULL };
static char *about_txt =
	IP_COPYRIGHT "\n"
	"\n"
	"nip comes with ABSOLUTELY NO WARRANTY.\n"
	"This is free software, and you are welcome to redistribute it\n"
	"under certain conditions, see http://www.gnu.org\n" 
	"\n"
	"Homepage: " VIPS_HOMEPAGE "\n"
	"Linked to VIPS library version: %s\n"
	"$VIPSHOME = %s\n"
	"$HOME = %s\n"
	"temp files in = %s\n";

typedef struct {
	GtkWidget *idlg;

	int timeout;
	int frame;
	int last_px;
	GtkWidget *map;
} About;

#define ABOUT(A) ((About *) (A))

/* Make the insides of an about box.
 */
static void
about_build( iDialog *idlg, GtkWidget *work, About *about )
{	
	GtkWidget *hb;
	GtkWidget *lab;

	hb = gtk_hbox_new( FALSE, 0 );
	gtk_container_border_width( GTK_CONTAINER( hb ), 10 );
	gtk_container_add( GTK_CONTAINER( work ), hb );
	gtk_widget_show( hb );

	about->map = gtk_pixmap_new( about_px[0], about_msk[0] );
        gtk_box_pack_start( GTK_BOX( hb ), about->map, FALSE, FALSE, 2 );
	gtk_widget_show( about->map );

	lab = gtk_label_new( "" );
	set_glabel( lab, about_txt,
		im_version_string(), 
		NN( getenv( "VIPSHOME" ) ),
		NN( getenv( "HOME" ) ),
		PATH_TMP );
        gtk_label_set_justify( GTK_LABEL( lab ), GTK_JUSTIFY_LEFT );
        gtk_box_pack_start( GTK_BOX( hb ), lab, FALSE, FALSE, 2 );
	gtk_widget_show( lab );
}

static int
about_timeout_cb( About *about )
{
	static int frames[] = { 
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		2, 1, 3, 1, 2, 1, 3, 1, 2, 1, 3, 1, 2, 1, 3
	};
	int n;

	n = frames[about->frame];
	if( n != about->last_px ) {
		gtk_pixmap_set( GTK_PIXMAP( about->map ), 
			about_px[n], about_msk[n] );
		about->last_px = n;
	}
	about->frame = (about->frame + 1) % IM_NUMBER( frames );

	/* Restart timer.
	 */
	return( TRUE );
}

void 
about_destroy_cb( iDialog *idlg, void *client )
{
	About *about = ABOUT( client );

	FREEFI( gtk_timeout_remove, about->timeout );
	FREE( about );
}

/* Pop up an "about" window.
 */
void
box_about( GtkWidget *par )
{
	static char **data[4] = { 
		automatic, automatic1, automatic2, automatic3 
	};

	int i;
	GtkWidget *idlg;
	About *about = IM_NEW( NULL, About );

	about->idlg = NULL;
	about->frame = 0;
	about->last_px = -1;
	about->map = NULL;

	if( !about_px[3] ) 
		for( i = 0; i < 4; i++ )
			about_px[i] = gdk_pixmap_create_from_xpm_d( 
				main_window_gdk, &about_msk[i], NULL, data[i] );

	about->idlg = idlg = idialog_new();
	iwindow_set_title( IWINDOW( idlg ), IP_NAME );
	idialog_set_build( IDIALOG( idlg ), 
		(iWindowBuildFn) about_build, about, NULL, NULL );
	idialog_set_callbacks( IDIALOG( idlg ), 
		NULL, NULL, NULL, about_destroy_cb, about );
	idialog_add_ok( IDIALOG( idlg ), iwindow_true_cb, "OK" );
	idialog_set_parent( IDIALOG( idlg ), box_pick_parent( par ) );
	iwindow_build( IWINDOW( idlg ) );
	about->timeout = gtk_timeout_add( 
		150, (GtkFunction) about_timeout_cb, about );

	gtk_widget_show( GTK_WIDGET( idlg ) );
}

/* A big list of all the help tags, plus the file and anchor they are defined
 * in. See makehelpindex.pl.
 */
static const char *box_helpindex[][2] = {
#include "helpindex.h"
};

/* Pop up a help window for a tag.
 */
void
box_help( GtkWidget *par, const char *name )
{
	int i;

	for( i = 0; i < IM_NUMBER( box_helpindex ); i++ )
		if( strcmp( name, box_helpindex[i][0] ) == 0 ) {
			BufInfo buf;
			char txt[512];

			buf_init_static( &buf, txt, 512 );
			buf_appendf( &buf, "file://%s/%s", 
				NIP_DOCPATH, box_helpindex[i][1] );
			box_url( par, buf_all( &buf ) );
			return;
		}

	box_error( par, "No indexed help page found for tag \"%s\"", name );
}

/* Callback from ItemFactory ... display help page.
 */
/*ARGSUSED*/
void
box_help_cb( gpointer callback_data, guint callback_action,
        GtkWidget *par )
{
	const char *str = GUINT_TO_POINTER( callback_action );

	box_help( par, str );
}

/* Name + caption dialog ... for new workspace / new column.
 */

static iDialogClass *stringset_parent_class = NULL;

void *
stringset_child_destroy( StringsetChild *ssc )
{
	ssc->ss->children = g_slist_remove( ssc->ss->children, ssc );

	FREE( ssc->label );
	FREE( ssc->text );
	FREE( ssc->tooltip );
	FREE( ssc );

	return( NULL );
}

StringsetChild *
stringset_child_new( Stringset *ss,
	const char *label, const char *text, const char *tooltip )
{
	StringsetChild *ssc = IM_NEW( NULL, StringsetChild );

	ssc->ss = ss;
	ssc->label = im_strdup( NULL, label );
	ssc->text = im_strdup( NULL, text );
	ssc->tooltip = im_strdup( NULL, tooltip );

	ss->children = g_slist_append( ss->children, ssc );

	return( ssc );
}

static void
stringset_destroy( GtkObject *object )
{
	Stringset *ss;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_STRINGSET( object ) );

	ss = STRINGSET( object );

	slist_map( ss->children,
		(SListMapFn) stringset_child_destroy, NULL );

	if( GTK_OBJECT_CLASS( stringset_parent_class )->destroy )
		GTK_OBJECT_CLASS( stringset_parent_class )->destroy( object );
}

static void *
stringset_build_set_default( StringsetChild *ssc, iDialog *idlg )
{
	idialog_set_default_entry( idlg, GTK_ENTRY( ssc->entry ) );

	return( NULL );
}

static void
stringset_build( GtkWidget *widget )
{
	Stringset *ss = STRINGSET( widget );
	iDialog *idlg = IDIALOG( widget );
	GSList *p;

#ifdef DEBUG
	printf( "stringset_build: %s\n", IWINDOW( ss )->title );
#endif /*DEBUG*/

	/* Call all builds in superclasses.
	 */
	if( IWINDOW_CLASS( stringset_parent_class )->build )
		IWINDOW_CLASS( stringset_parent_class )->build( widget );

	for( p = ss->children; p; p = p->next ) {
		StringsetChild *ssc = (StringsetChild *) p->data;

		ssc->entry = build_glabeltext3( idlg->work, ssc->label );
		if( ssc->text )
			set_gentry( ssc->entry, "%s", ssc->text );
		if( ssc->tooltip )
			set_tooltip( ssc->entry, "%s", ssc->tooltip );
	}

	/* Set defaults in reverse, so we get top item with focus.
	 */
	(void) slist_map_rev( ss->children,
		(SListMapFn) stringset_build_set_default, idlg );

	gtk_widget_show_all( idlg->work );
}

static void
stringset_class_init( StringsetClass *klass )
{
	GtkObjectClass *object_class;
	iWindowClass *iwindow_class;

	object_class = (GtkObjectClass *) klass;
	iwindow_class = (iWindowClass *) klass;

	object_class->destroy = stringset_destroy;
	iwindow_class->build = stringset_build;

	stringset_parent_class = gtk_type_class( TYPE_IDIALOG );
}

static void
stringset_init( Stringset *ss )
{
#ifdef DEBUG
	printf( "stringset_init: %s\n", IWINDOW( ss )->title );
#endif /*DEBUG*/

	ss->children = NULL;
}

GtkType
stringset_get_type( void )
{
	static GtkType stringset_type = 0;

	if( !stringset_type ) {
		static const GtkTypeInfo info = {
			"Stringset",
			sizeof( Stringset ),
			sizeof( StringsetClass ),
			(GtkClassInitFunc) stringset_class_init,
			(GtkObjectInitFunc) stringset_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		stringset_type = gtk_type_unique( TYPE_IDIALOG, &info );
	}

	return( stringset_type );
}

GtkWidget *
stringset_new( void )
{
	Stringset *ss = gtk_type_new( TYPE_STRINGSET );

	return( GTK_WIDGET( ss ) );
}

StringsetChild *
stringset_child_get( Stringset *ss, const char *label )
{
	GSList *p;

	for( p = ss->children; p; p = p->next ) {
		StringsetChild *ssc = (StringsetChild *) p->data;

		if( strcmp( label, ssc->label ) == 0 )
			return( ssc );
	}

	return( NULL );
}

/* Find dialog.
 */

static iDialogClass *find_parent_class = NULL;

static void
find_destroy( GtkObject *object )
{
	Find *find;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_FIND( object ) );

	find = FIND( object );

	/* My instance destroy stuff.
	 */

	if( GTK_OBJECT_CLASS( find_parent_class )->destroy )
		(*GTK_OBJECT_CLASS( find_parent_class )->destroy)( object );
}

static void
find_build( GtkWidget *widget )
{
	Find *find = FIND( widget );
	iDialog *idlg = IDIALOG( widget );

#ifdef DEBUG
	printf( "find_build: %s\n", IWINDOW( find )->title );
#endif /*DEBUG*/

	/* Call all builds in superclasses.
	 */
	if( IWINDOW_CLASS( find_parent_class )->build )
		(*IWINDOW_CLASS( find_parent_class )->build)( widget );

	find->search = build_glabeltext3( idlg->work, "Find" );
	find->csens = build_gtoggle( idlg->work, "Case sensitive" );
#ifdef HAVE_REGEXEC
	find->regexp = build_gtoggle( idlg->work, "Regular expression" );
#endif /*HAVE_REGEXEC*/
	find->fromtop = build_gtoggle( idlg->work, "Search from start" );
	idialog_set_default_entry( idlg, GTK_ENTRY( find->search ) );
	gtk_widget_show_all( idlg->work );
}

static void
find_class_init( FindClass *klass )
{
	GtkObjectClass *object_class;
	iWindowClass *iwindow_class;

	object_class = (GtkObjectClass *) klass;
	iwindow_class = (iWindowClass *) klass;

	object_class->destroy = find_destroy;
	iwindow_class->build = find_build;

	find_parent_class = gtk_type_class( TYPE_IDIALOG );
}

static void
find_init( Find *find )
{
#ifdef DEBUG
	printf( "find_init: %s\n", IWINDOW( find )->title );
#endif /*DEBUG*/

	idialog_set_pinup( IDIALOG( find ), TRUE );
}

GtkType
find_get_type( void )
{
	static GtkType find_type = 0;

	if( !find_type ) {
		static const GtkTypeInfo info = {
			"Find",
			sizeof( Find ),
			sizeof( FindClass ),
			(GtkClassInitFunc) find_class_init,
			(GtkObjectInitFunc) find_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		find_type = gtk_type_unique( TYPE_IDIALOG, &info );
	}

	return( find_type );
}

GtkWidget *
find_new( void )
{
	Find *find = gtk_type_new( TYPE_FIND );

	return( GTK_WIDGET( find ) );
}

/* Imageheader dialog.
 */

static iDialogClass *imageheader_parent_class = NULL;

static void
imageheader_destroy( GtkObject *object )
{
	Imageheader *imageheader;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_IMAGEHEADER( object ) );

	imageheader = IMAGEHEADER( object );

	/* My instance destroy stuff.
	 */
	FREESID( imageheader->changed_sid, imageheader->conv );
	FREEFO( gtk_object_unref, imageheader->conv );

	if( GTK_OBJECT_CLASS( imageheader_parent_class )->destroy )
		GTK_OBJECT_CLASS( imageheader_parent_class )->destroy( object );
}

static void
imageheader_refresh( Imageheader *imageheader )
{
	if( imageheader->conv && imageheader->conv->ii ) {
		IMAGE *im = imageinfo_get( FALSE, imageheader->conv->ii );

		set_glabel( imageheader->xsize, "%d", im->Xsize );
		set_glabel( imageheader->ysize, "%d", im->Ysize );
		set_glabel( imageheader->bands, "%d", im->Bands );
		set_glabel( imageheader->bbits, "%d", im->Bbits );
		set_glabel( imageheader->fmt, "%s", 
			im_BandFmt2char( im->BandFmt ) );
		set_glabel( imageheader->coding, "%s", 
			im_Coding2char( im->Coding ) );
		set_glabel( imageheader->type, "%s", 
			im_Type2char( im->Type ) );
		set_glabel( imageheader->xres, "%g", im->Xres );
		set_glabel( imageheader->yres, "%g", im->Yres );
		set_glabel( imageheader->xoff, "%d", im->Xoffset );
		set_glabel( imageheader->yoff, "%d", im->Yoffset );
		set_glabel( imageheader->filename, "%s", im->filename );

		gtk_text_freeze( GTK_TEXT( imageheader->history ) );
		gtk_editable_delete_text( GTK_EDITABLE( imageheader->history ),
			0, -1 );
		gtk_text_insert( GTK_TEXT( imageheader->history ),
			NULL, NULL, NULL, im->Hist, strlen( im->Hist ) );
		gtk_text_thaw( GTK_TEXT( imageheader->history ) );
	}
	else {
		set_glabel( imageheader->xsize, "--" );
		set_glabel( imageheader->ysize, "--" );
		set_glabel( imageheader->bands, "--" );
		set_glabel( imageheader->bbits, "--" );
		set_glabel( imageheader->fmt, "--" );
		set_glabel( imageheader->coding, "--" );
		set_glabel( imageheader->type, "--" );
		set_glabel( imageheader->xres, "--" );
		set_glabel( imageheader->yres, "--" );
		set_glabel( imageheader->xoff, "--" );
		set_glabel( imageheader->yoff, "--" );
		set_glabel( imageheader->filename, "--" );
		gtk_editable_delete_text( GTK_EDITABLE( imageheader->history ),
			0, -1 );
	}
}

static GtkWidget *
imageheader_label( GtkWidget *table, int row, const char *text )
{
	GtkWidget *label;

	label = gtk_label_new( text );
	gtk_misc_set_alignment( GTK_MISC( label ), 1.0, 0.5 );
	gtk_table_attach( GTK_TABLE( table ), label,
		0, 1, row, row + 1, 
		GTK_FILL, GTK_FILL, 0, 0 );
	label = gtk_label_new( text );
	gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
	gtk_table_attach( GTK_TABLE( table ), label,
		1, 2, row, row + 1, 
		GTK_FILL, GTK_FILL, 0, 0 );

	return( label );
}

static void
imageheader_build( GtkWidget *widget )
{
	Imageheader *imageheader = IMAGEHEADER( widget );
	iDialog *idlg = IDIALOG( widget );

	GtkWidget *table;
	GtkWidget *swin;
	GtkAdjustment *hadj;
	GtkAdjustment *vadj;

#ifdef DEBUG
	printf( "imageheader_build: %s\n", IWINDOW( imageheader )->title );
#endif /*DEBUG*/

	/* Call all builds in superclasses.
	 */
	if( IWINDOW_CLASS( imageheader_parent_class )->build )
		(*IWINDOW_CLASS( imageheader_parent_class )->build)( widget );

        table = gtk_table_new( 10, 2, FALSE );
        gtk_box_pack_start( GTK_BOX( idlg->work ), table, FALSE, FALSE, 2 );

	imageheader->xsize = imageheader_label( table, 0, "Xsize = " );
	imageheader->ysize = imageheader_label( table, 1, "Ysize = " );
	imageheader->bands = imageheader_label( table, 2, "Bands = " );
	imageheader->bbits = imageheader_label( table, 3, "Bbits = " );
	imageheader->fmt = imageheader_label( table, 4, "BandFmt = " );
	imageheader->coding = imageheader_label( table, 5, "Coding = " );
	imageheader->type = imageheader_label( table, 6, "Type = " );
	imageheader->xres = imageheader_label( table, 7, "Xres = " );
	imageheader->yres = imageheader_label( table, 8, "Yres = " );
	imageheader->xoff = imageheader_label( table, 9, "Xoffset = " );
	imageheader->yoff = imageheader_label( table, 10, "Yoffset = " );
	imageheader->filename = imageheader_label( table, 11, "filename = " );

	swin = gtk_scrolled_window_new( NULL, NULL );
	gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW( swin ),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC );
        gtk_box_pack_start( GTK_BOX( idlg->work ), swin, TRUE, TRUE, 2 );
	hadj = gtk_scrolled_window_get_hadjustment( 
		GTK_SCROLLED_WINDOW( swin ) );
	vadj = gtk_scrolled_window_get_vadjustment( 
		GTK_SCROLLED_WINDOW( swin ) );
	imageheader->history = gtk_text_new( hadj, vadj );
	gtk_text_set_editable( GTK_TEXT( imageheader->history ), FALSE );
	gtk_container_add( GTK_CONTAINER( swin ), imageheader->history );

	imageheader_refresh( imageheader );

	gtk_widget_show_all( idlg->work );
}

static void
imageheader_class_init( ImageheaderClass *klass )
{
	GtkObjectClass *object_class;
	iWindowClass *iwindow_class;

	object_class = (GtkObjectClass *) klass;
	iwindow_class = (iWindowClass *) klass;

	object_class->destroy = imageheader_destroy;
	iwindow_class->build = imageheader_build;

	imageheader_parent_class = gtk_type_class( TYPE_IDIALOG );
}

static void
imageheader_init( Imageheader *imageheader )
{
#ifdef DEBUG
	printf( "imageheader_init: %s\n", IWINDOW( imageheader )->title );
#endif /*DEBUG*/

	imageheader->conv = NULL;
	imageheader->changed_sid = 0;
}

GtkType
imageheader_get_type( void )
{
	static GtkType imageheader_type = 0;

	if( !imageheader_type ) {
		static const GtkTypeInfo info = {
			"Imageheader",
			sizeof( Imageheader ),
			sizeof( ImageheaderClass ),
			(GtkClassInitFunc) imageheader_class_init,
			(GtkObjectInitFunc) imageheader_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		imageheader_type = gtk_type_unique( TYPE_IDIALOG, &info );
	}

	return( imageheader_type );
}

/* Conversion has changed signal.
 */
static void
imageheader_conv_changed( Model *model, Imageheader *imageheader )
{
	assert( IS_MODEL( model ) );
	assert( IS_IMAGEHEADER( imageheader ) );

	imageheader_refresh( imageheader );
}

static void
imageheader_link( Imageheader *imageheader, Conversion *conv )
{
	imageheader->conv = conv;
	imageheader->changed_sid = gtk_signal_connect( GTK_OBJECT( conv ), 
		"changed", 
		GTK_SIGNAL_FUNC( imageheader_conv_changed ), imageheader );
	gtk_object_ref( GTK_OBJECT( conv ) );
	gtk_object_sink( GTK_OBJECT( conv ) );
}

GtkWidget *
imageheader_new( Conversion *conv )
{
	Imageheader *imageheader = gtk_type_new( TYPE_IMAGEHEADER );

	imageheader_link( imageheader, conv );

	return( GTK_WIDGET( imageheader ) );
}

/* Launch a viewer on a URL.
 */
void
box_url( GtkWidget *par, const char *url )
{
#ifdef HAVE_WINDOWS_H
	char url2[FILENAME_MAX];
	int v;
	
	expand_variables( url, url2 );
	v = (int) ShellExecute( NULL, "open", url2, NULL, NULL, SW_SHOWNORMAL );
	if( v <= 32 )
		box_error( par, "unable to open URL \"%s\"\n"
			"windows error code = %d", url, v );
#elif defined MAC_OSX
	static gboolean shown = FALSE;

	(void) systemf( "open %s", url );

	if( !shown ) {
		box_info( par, "opening URL:\n"
			"  %s\n"
			"This may take a few seconds.", url );
		shown = TRUE;
	}
#else /*unix-y*/
	static gboolean shown = FALSE;

	BufInfo buf;
	char txt[512];
	BufInfo buf2;
	char txt2[512];

	buf_init_static( &buf, txt, 512 );
	buf_appendf( &buf, "%s %s", BOX_BROWSER, BOX_BROWSER_REMOTE );
	buf_init_static( &buf2, txt2, 512 );
	buf_appendf( &buf2, buf_all( &buf ), url );

	if( systemf( "%s", buf_all( &buf2 ) ) )
		box_error( par, "Unable to open a browser window\n"
			"Attempted to launch browser with command:\n"
			"  %s\n"
			"You can change this command in the Preferences "
			"workspace", buf_all( &buf2 ) );
	else if( !shown ) {
		box_info( par, "%s window successfully opened for URL:\n"
			"  %s\n"
			"You may need to switch desktops to see the "
			"new window", 
			BOX_BROWSER, buf_all( &buf2 ) );

		/* Only show 1st time.
		 */
		shown = TRUE;
	}
#endif /*HAVE_WINDOWS_H*/
}

/* From an itemfactory menu.
 */
void
box_url_cb( gpointer callback_data, guint callback_action,
        GtkWidget *widget )
{
	GtkWidget *par = GTK_WIDGET( callback_data );
	const char *tag = (const char *) callback_action;
	BufInfo buf;
	char txt[512];

	buf_init_static( &buf, txt, 512 );
	buf_appendf( &buf, "file://%s/%s", NIP_DOCPATH, tag );

	box_url( par, buf_all( &buf ) );
}

