/* Manage display conversion parameters.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#define TYPE_CONVERSION (conversion_get_type())
#define CONVERSION( obj ) (GTK_CHECK_CAST( (obj), TYPE_CONVERSION, Conversion ))
#define CONVERSION_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), TYPE_CONVERSION, ConversionClass ))
#define IS_CONVERSION( obj ) (GTK_CHECK_TYPE( (obj), TYPE_CONVERSION ))
#define IS_CONVERSION_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_CONVERSION ))

struct _Conversion {
	Model parent_class;

	/* Image.
	 */
	Imageinfo *ii;		/* Underlying image */
	guint changed_sid;	/* Watch for "changed" on ii with this */
	REGION *reg;		/* Region for input from underlying image */

	Imageinfo *visual_ii;	/* Visualisation image .. eg. histplot */
	Imageinfo *display_ii;	/* Zoomed and colour converted for screen */
	REGION *ireg;		/* Region for input from repaint image */
	im_threadgroup_t *tg;	/* Threads we use for paint eval */

	/* Error handling ... if we see an im_prepare() error off this, we
	 * want to stop comptation until it's fixed.
	 */
	gboolean err;		/* Has there been an error from VIPS */
	char *errstr;		/* Copy of the error we got */

	/* Basic geometry.
	 */
	Rect underlay;		/* Size of underlying image (at 0,0) */
	Rect image;		/* Size of visualisation image (at 0,0) */
	Rect canvas;		/* Size of image we display (always at 0,0) */
	Rect visible;		/* hint ... visible region of display image */
	int mag;		/* -ve for shrink, +ve for expand */

	/* Visualisation controls.
	 */
	gboolean enabled;
	double scale;		/* Contrast/brightness */
	double offset;
	gboolean falsecolour;	/* False colour display on */
	gboolean type;		/* Interpret type field */

	/* Status bar controls.
	 */
	gboolean status;	/* Visible/not */

	/* Paintbox controls.
	 */
	gboolean paintbox;	/* Visible/not */
	PaintboxTool paintbox_tool;/* Current tool */
	PaintboxNib paintbox_nib;/* Current nib */
	Imageinfo *paintbox_ink;/* 1x1 pixel ink image */
	char *paintbox_font_name;/* Selected font name */
	GdkFont *paintbox_font;	/* Selected font */
	char *paintbox_text; 	/* Text to render */
	Imageinfo *paintbox_text_mask; /* As a bitmap */
	Rect paintbox_text_area; /* Text geometry */
};

typedef struct _ConversionClass {
	ModelClass parent_class;

	/* My methods.
	 */
} ConversionClass;

GtkType conversion_get_type( void );
Conversion *conversion_new( Imageinfo *ii );

void conversion_error_set( Conversion *conv );

void conversion_refresh( Conversion *conv );
void conversion_set_image( Conversion *conv, Imageinfo *ii );
gboolean conversion_refresh_text( Conversion *conv );

double conversion_dmag( int mag );
int conversion_double( int mag );
int conversion_halve( int mag );

void conversion_disp_to_im( Conversion *conv, 
	int dx, int dy, int *ix, int *iy );
void conversion_im_to_disp( Conversion *conv, 
	int ix, int iy, int *dx, int *dy );
void conversion_disp_to_im_rect( Conversion *conv, Rect *dr, Rect *ir );
void conversion_im_to_disp_rect( Conversion *conv, Rect *ir, Rect *dr );
