/* run the display for an arrow in a workspace 
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ViewClass *parent_class = NULL;

static void
filenameview_destroy( GtkObject *object )
{
	Filenameview *filenameview;

#ifdef DEBUG
	printf( "filenameview_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_FILENAMEVIEW( object ) );

	filenameview = FILENAMEVIEW( object );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void 
filenameview_refresh( View *view )
{
	Filenameview *filenameview = FILENAMEVIEW( view );
	Filename *filename = FILENAME( view->model );

#ifdef DEBUG
	printf( "filenameview_refresh: " );
	row_name_print( HEAPMODEL( filename )->row );
	printf( "\n" );
#endif /*DEBUG*/

	set_glabel( filenameview->label, "Filename: %s", filename->value );

	VIEW_CLASS( parent_class )->refresh( view );
}

static void
filenameview_class_init( FilenameviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ViewClass *view_class = (ViewClass *) klass;

	parent_class = gtk_type_class( TYPE_VIEW );

	object_class->destroy = filenameview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	view_class->refresh = filenameview_refresh;
}

static void
filenameview_single_cb( GtkWidget *wid, Filenameview *filenameview )
{
	Filename *filename = FILENAME( VIEW( filenameview )->model );

	row_select( HEAPMODEL( filename )->row );
}

static void
filenameview_double_cb( GtkWidget *wid, Filenameview *filenameview )
{
	Filename *filename = FILENAME( VIEW( filenameview )->model );

	model_edit( wid, MODEL( filename ) );
}

static void
filenameview_init( Filenameview *filenameview )
{
	GtkWidget *eb;

#ifdef DEBUG
	printf( "filenameview_init\n" );
#endif /*DEBUG*/

        eb = gtk_event_box_new();
        gtk_box_pack_start( GTK_BOX( filenameview ), eb, FALSE, FALSE, 0 );
	filenameview->label = gtk_label_new( "" );
        gtk_misc_set_alignment( GTK_MISC( filenameview->label ), 0, 0.5 );
        gtk_misc_set_padding( GTK_MISC( filenameview->label ), 2, 0 );
        gtk_container_add( GTK_CONTAINER( eb ), filenameview->label );
	set_name( eb, "caption_widget" );

        doubleclick_add( GTK_WIDGET( eb ), FALSE,
                filenameview_single_cb, filenameview, 
		filenameview_double_cb, filenameview );

        gtk_widget_show_all( GTK_WIDGET( filenameview ) );
}

GtkType
filenameview_get_type( void )
{
	static GtkType filenameview_type = 0;

	if( !filenameview_type ) {
		static const GtkTypeInfo info = {
			"Filenameview",
			sizeof( Filenameview ),
			sizeof( FilenameviewClass ),
			(GtkClassInitFunc) filenameview_class_init,
			(GtkObjectInitFunc) filenameview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		filenameview_type = gtk_type_unique( TYPE_VIEW, &info );
	}

	return( filenameview_type );
}

View *
filenameview_new( void )
{
	Filenameview *filenameview = gtk_type_new( TYPE_FILENAMEVIEW );

	return( VIEW( filenameview ) );
}
