/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-1999.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/. 
 */

/* Added to make compile out of gtk+ src dir, remove this junk!
 */
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gtkmenubar2.h"

/*

> Havoc Pennington wrote:
> > John Cupitt <john.cupitt@ng-london.org.uk> writes:
> > > As far as I can see, I need to be able to refuse an allocation (I have
> > > more items than I can fit in), and make another requisition (I'll accept
> > > that width, but can I have more height please). 
> > 
> > It doesn't have this unless the container supports it. For example the
> > scrolled window container will sometimes give the child a second
> > allocation. So you could do some sort of custom container.
> 
> Hi, thanks for the reply ... I've made a version of gtkmenubar that
> wraps, by calling gtk_container_queue_resize( self ) inside the
> size_allocate method. Working out the geometry almost made my head
> explode :/

gtk_container_queue_resize() is an internal function, never use it directly.
instead, you either want gtk_widget_queue_resize (menu_bar->child) (this
pretty much amounts to gtk_container_queue_resize (menu_bar)) or
gtk_widget_queue_resize (menu_bar);

> It flickers like mad (my fault), but it does seem to work. Is this the
> approved technique, or is there a safer call?

i've got to have a look at your code to actually figure your exact needs.
the general rule of thumb is, always queue the resize on the widget that
actually changed, not its parents.
i.e. a GtkHBox would, when a new child is added to it, do
gtk_widget_queue_resize (new_child), instead of
gtk_widget_queue_resize (hbox), since resizing of the hbox will automatically
be taken into account when processing the resize needs of new_child.

how do you handle right justified menu items with the wrapping code btw?
(though there actually can only be *one* right justified item currently,
regardless of its visibility state even, another thing that needs fixing
with the menu code.)

> 
> John
> 

---
ciaoTJ
 */

/*
#include "gdk/gdkkeysyms.h"
#include "gtkbindings.h"
#include "gtkmain.h"
#include "gtkmenubar.h"
#include "gtkmenuitem.h"
 */

enum {
  ARG_0,
  ARG_SHADOW
};


#define BORDER_SPACING  0
#define CHILD_SPACING  0

static GtkMenuShellClass *parent_class = NULL;

static void gtk_menu_bar2_class_init    (GtkMenuBar2Class *klass);
static void gtk_menu_bar2_init          (GtkMenuBar2      *menu_bar2);
static void gtk_menu_bar2_set_arg       (GtkObject      *object,
					GtkArg         *arg,
					guint           arg_id);
static void gtk_menu_bar2_get_arg       (GtkObject      *object,
					GtkArg         *arg,
					guint           arg_id);
static void gtk_menu_bar2_size_request  (GtkWidget       *widget,
					GtkRequisition  *requisition);
static void gtk_menu_bar2_size_allocate (GtkWidget       *widget,
					GtkAllocation   *allocation);
static void gtk_menu_bar2_paint         (GtkWidget       *widget,
					GdkRectangle    *area);
static void gtk_menu_bar2_draw          (GtkWidget       *widget,
					GdkRectangle    *area);
static gint gtk_menu_bar2_expose        (GtkWidget       *widget,
					GdkEventExpose  *event);

GtkType
gtk_menu_bar2_get_type (void)
{
  static GtkType menu_bar2_type = 0;

  if (!menu_bar2_type)
    {
      static const GtkTypeInfo menu_bar2_info =
      {
	"GtkMenuBar2",
	sizeof (GtkMenuBar2),
	sizeof (GtkMenuBar2Class),
	(GtkClassInitFunc) gtk_menu_bar2_class_init,
	(GtkObjectInitFunc) gtk_menu_bar2_init,
	/* reserved_1 */ NULL,
        /* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      menu_bar2_type = gtk_type_unique (gtk_menu_shell_get_type (), &menu_bar2_info);
    }

  return menu_bar2_type;
}

static void
gtk_menu_bar2_class_init (GtkMenuBar2Class *class)
{
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkMenuShellClass *menu_shell_class;

  GtkBindingSet *binding_set;

  parent_class = gtk_type_class( GTK_TYPE_MENU_SHELL );

  object_class = (GtkObjectClass*) class;
  widget_class = (GtkWidgetClass*) class;
  menu_shell_class = (GtkMenuShellClass*) class;

  gtk_object_add_arg_type ("GtkMenuBar2::shadow", GTK_TYPE_SHADOW_TYPE, GTK_ARG_READWRITE, ARG_SHADOW);

  object_class->set_arg = gtk_menu_bar2_set_arg;
  object_class->get_arg = gtk_menu_bar2_get_arg;

  widget_class->draw = gtk_menu_bar2_draw;
  widget_class->size_request = gtk_menu_bar2_size_request;
  widget_class->size_allocate = gtk_menu_bar2_size_allocate;
  widget_class->expose_event = gtk_menu_bar2_expose;

  menu_shell_class->submenu_placement = GTK_LEFT_RIGHT;

  binding_set = gtk_binding_set_by_class (class);
  gtk_binding_entry_add_signal (binding_set,
				GDK_Left, 0,
				"move_current", 1,
				GTK_TYPE_MENU_DIRECTION_TYPE,
				GTK_MENU_DIR_PREV);
  gtk_binding_entry_add_signal (binding_set,
				GDK_Right, 0,
				"move_current", 1,
				GTK_TYPE_MENU_DIRECTION_TYPE,
				GTK_MENU_DIR_NEXT);
  gtk_binding_entry_add_signal (binding_set,
				GDK_Up, 0,
				"move_current", 1,
				GTK_TYPE_MENU_DIRECTION_TYPE,
				GTK_MENU_DIR_PARENT);
  gtk_binding_entry_add_signal (binding_set,
				GDK_Down, 0,
				"move_current", 1,
				GTK_TYPE_MENU_DIRECTION_TYPE,
				GTK_MENU_DIR_CHILD);
}

static void
gtk_menu_bar2_init (GtkMenuBar2 *menu_bar2)
{
  menu_bar2->shadow_type = GTK_SHADOW_OUT;
}

static void
gtk_menu_bar2_set_arg (GtkObject      *object,
		      GtkArg         *arg,
		      guint           arg_id)
{
  GtkMenuBar2 *menu_bar2;

  menu_bar2 = GTK_MENU_BAR2 (object);

  switch (arg_id)
    {
    case ARG_SHADOW:
      gtk_menu_bar2_set_shadow_type (menu_bar2, GTK_VALUE_ENUM (*arg));
      break;
    default:
      break;
    }
}

static void
gtk_menu_bar2_get_arg (GtkObject      *object,
		      GtkArg         *arg,
		      guint           arg_id)
{
  GtkMenuBar2 *menu_bar2;

  menu_bar2 = GTK_MENU_BAR2 (object);

  switch (arg_id)
    {
    case ARG_SHADOW:
      GTK_VALUE_ENUM (*arg) = menu_bar2->shadow_type;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}
 
GtkWidget*
gtk_menu_bar2_new (void)
{
  return GTK_WIDGET (gtk_type_new (gtk_menu_bar2_get_type ()));
}

void
gtk_menu_bar2_append (GtkMenuBar2 *menu_bar2,
		     GtkWidget  *child)
{
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_bar2), child);
}

void
gtk_menu_bar2_prepend (GtkMenuBar2 *menu_bar2,
		      GtkWidget  *child)
{
  gtk_menu_shell_prepend (GTK_MENU_SHELL (menu_bar2), child);
}

void
gtk_menu_bar2_insert (GtkMenuBar2 *menu_bar2,
		     GtkWidget  *child,
		     gint        position)
{
  gtk_menu_shell_insert (GTK_MENU_SHELL (menu_bar2), child, position);
}

static void
gtk_menu_bar2_size_request (GtkWidget      *widget,
			   GtkRequisition *requisition)
{
  GtkMenuBar2 *menu_bar2;
  GtkMenuShell *menu_shell;
  GtkWidget *child;
  GList *children;
  gint nchildren;
  GtkRequisition child_requisition;

  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_MENU_BAR2 (widget));
  g_return_if_fail (requisition != NULL);

  requisition->width = 0;
  requisition->height = 0;

  if (GTK_WIDGET_VISIBLE (widget))
    {
      menu_bar2 = GTK_MENU_BAR2 (widget);
      menu_shell = GTK_MENU_SHELL (widget);

      nchildren = 0;
      children = menu_shell->children;

      while (children)
	{
	  child = children->data;
	  children = children->next;

	  if (GTK_WIDGET_VISIBLE (child))
	    {
	      GTK_MENU_ITEM (child)->show_submenu_indicator = FALSE;
	      gtk_widget_size_request (child, &child_requisition);

	      requisition->width = MAX (requisition->width, child_requisition.width);
	      requisition->height += child_requisition.height;

	      nchildren += 1;
	    }
	}

      requisition->width += (GTK_CONTAINER (menu_bar2)->border_width +
			     widget->style->klass->xthickness +
			     BORDER_SPACING) * 2;
      requisition->height += (GTK_CONTAINER (menu_bar2)->border_width +
			      widget->style->klass->ythickness +
			      BORDER_SPACING) * 2;

      if (nchildren > 0)
	requisition->width += 2 * CHILD_SPACING * (nchildren - 1);
    }
}

static void
gtk_menu_bar2_size_allocate (GtkWidget     *widget,
			    GtkAllocation *allocation)
{
  GtkMenuBar2 *menu_bar2;
  GtkMenuShell *menu_shell;
  GtkWidget *child;
  GList *children;
  GtkAllocation child_allocation;
  GtkRequisition child_requisition;
  guint offset;
  
  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_MENU_BAR2 (widget));
  g_return_if_fail (allocation != NULL);

  menu_bar2 = GTK_MENU_BAR2 (widget);
  menu_shell = GTK_MENU_SHELL (widget);

  widget->allocation = *allocation;
  if (GTK_WIDGET_REALIZED (widget))
    gdk_window_move_resize (widget->window,
			    allocation->x, allocation->y,
			    allocation->width, allocation->height);

  if (menu_shell->children)
    {
      child_allocation.x = (GTK_CONTAINER (menu_bar2)->border_width +
			    widget->style->klass->xthickness +
			    BORDER_SPACING);
      offset = child_allocation.x; 	/* Window edge to menubar start */

      child_allocation.y = (GTK_CONTAINER (menu_bar2)->border_width +
			    widget->style->klass->ythickness +
			    BORDER_SPACING);
      child_allocation.width = MAX (1, (gint)allocation->width - offset * 2);

      children = menu_shell->children;
      while (children)
	{
	  child = children->data;
	  children = children->next;

	  gtk_widget_get_child_requisition (child, &child_requisition);

	  /* Support for the right justified help menu */
	  if ( (children == NULL) && (GTK_IS_MENU_ITEM(child))
	      && (GTK_MENU_ITEM(child)->right_justify)) 
	    {
	      child_allocation.x = allocation->width -
		  child_requisition.width - CHILD_SPACING - offset;
	      child_allocation.y = allocation->height -
		  child_requisition.height - CHILD_SPACING - offset;
	    }
	  if (GTK_WIDGET_VISIBLE (child))
	    {
	      child_allocation.height = child_requisition.height;

	      gtk_widget_size_allocate (child, &child_allocation);

	      child_allocation.y += child_allocation.height + CHILD_SPACING;
	    }
	}
    }
}

void
gtk_menu_bar2_set_shadow_type (GtkMenuBar2    *menu_bar2,
			      GtkShadowType  type)
{
  g_return_if_fail (menu_bar2 != NULL);
  g_return_if_fail (GTK_IS_MENU_BAR2 (menu_bar2));

  if ((GtkShadowType) menu_bar2->shadow_type != type)
    {
      menu_bar2->shadow_type = type;

      if (GTK_WIDGET_DRAWABLE (menu_bar2))
        {
          gtk_widget_queue_clear (GTK_WIDGET (menu_bar2));
        }
      gtk_widget_queue_resize (GTK_WIDGET (menu_bar2));
    }
}

static void
gtk_menu_bar2_paint (GtkWidget *widget, GdkRectangle *area)
{
  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_MENU_BAR2 (widget));

  if (GTK_WIDGET_DRAWABLE (widget))
    {
      gtk_paint_box (widget->style,
		     widget->window,
		     GTK_STATE_NORMAL,
		     GTK_MENU_BAR2 (widget)->shadow_type,
		     area, widget, "menubar",
		     0, 0,
		     -1,-1);
    }
}

static void
gtk_menu_bar2_draw (GtkWidget    *widget,
		   GdkRectangle *area)
{
  GtkMenuShell *menu_shell;
  GtkWidget *child;
  GdkRectangle child_area;
  GList *children;

  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_MENU_BAR2 (widget));
  g_return_if_fail (area != NULL);

  if (GTK_WIDGET_DRAWABLE (widget))
    {
      gtk_menu_bar2_paint (widget, area);

      menu_shell = GTK_MENU_SHELL (widget);

      children = menu_shell->children;
      while (children)
	{
	  child = children->data;
	  children = children->next;

	  if (gtk_widget_intersect (child, area, &child_area))
	    gtk_widget_draw (child, &child_area);
	}
    }
}

static gint
gtk_menu_bar2_expose (GtkWidget      *widget,
		     GdkEventExpose *event)
{
  GtkMenuShell *menu_shell;
  GdkEventExpose child_event;
  GList *children;
  GtkWidget *child;

  g_return_val_if_fail (widget != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_MENU_BAR2 (widget), FALSE);
  g_return_val_if_fail (event != NULL, FALSE);

  if (GTK_WIDGET_DRAWABLE (widget))
    {
      gtk_menu_bar2_paint (widget, &event->area);

      menu_shell = GTK_MENU_SHELL (widget);
      child_event = *event;

      children = menu_shell->children;
      while (children)
	{
	  child = children->data;
	  children = children->next;

	  if (GTK_WIDGET_NO_WINDOW (child) &&
	      gtk_widget_intersect (child, &event->area, &child_event.area))
	    gtk_widget_event (child, (GdkEvent*) &child_event);
	}
    }

  return FALSE;
}
