/* Imagedisplay widget stuff.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

*/

#define TYPE_IMAGEDISPLAY (imagedisplay_get_type())
#define IMAGEDISPLAY(obj) GTK_CHECK_CAST( obj, \
	imagedisplay_get_type(), Imagedisplay )
#define IMAGEDISPLAY_CLASS(klass)  GTK_CHECK_CLASS_CAST( klass, \
	imagedisplay_get_type(), ImagedisplayClass )
#define IS_IMAGEDISPLAY(obj) GTK_CHECK_TYPE( obj, imagedisplay_get_type() )

/* Track an image display canvas in one of these.
 */
struct _Imagedisplay {
	/* Drawing area we paint in.
	 */
	GtkDrawingArea parent_class;

	/* Geometry.
	 */
	Rect screen;		/* Section of DrawingArea displaying image */
	Rect visible;		/* Visible region of scrolling image */
	int border;		/* Width of focus border */

	/* Link to scrollbars.
	 */
	GtkAdjustment *hadj;
	GtkAdjustment *vadj;

	/* Image.
	 */
	Conversion *conv;	/* Conversion we display */
	guint changed_sid;	/* Signal we listen for conv changed with */
	guint ii_area_changed_sid;/* Watch for "area_changed" on ii with this */
	guint ii_destroy_sid;
	Imageinfo *ii;		/* The ii we connected the sigs to */

        /* Asynch and threaded repaint stuff.
         */
        int sheight;            /* Current repaint strip height */
	GSList *pending;	/* List of pending expose Rects */
	gboolean update;	/* On update list */

	/* Gcs used by paint, too. 
	 */
	GdkGC *back_gc;
	GdkGC *err_gc;
	GdkGC *xor_gc;
	GdkGC *top_gc;
	GdkGC *bottom_gc;
	GdkGC *scroll_gc;
};

/* Class structure.
 */
typedef struct _ImagedisplayClass {
	/* Drawing area we paint in.
	 */
	GtkDrawingAreaClass parent_class;

	/* Our signals ... expose event starts, background repaint happens.
	 * The pointer is to a Rect describing the expose. All canvas cods.
	 */
	void (*expose_start)( Imagedisplay *, gpointer );
	void (*repaint)( Imagedisplay *, gpointer );

	/* Virtual methods.
	 */
	void (*conversion_changed)( Imagedisplay * );
	void (*set_conversion)( Imagedisplay *, Conversion *conv );
	void (*area_changed)( Imagedisplay *, Rect *display );
} ImagedisplayClass;

void imagedisplay_set_conversion( Imagedisplay *id, Conversion *conv );
void imagedisplay_set_position( Imagedisplay *id, int x, int y );
void imagedisplay_set_size( Imagedisplay *id, int w, int h );
void imagedisplay_set_mag_position( Imagedisplay *id, 
	int scale, int ix, int iy );
void imagedisplay_set_mag( Imagedisplay *id, int mag );
void imagedisplay_set_hadj( Imagedisplay *id, GtkAdjustment *hadj );
void imagedisplay_set_vadj( Imagedisplay *id, GtkAdjustment *vadj );

guint imagedisplay_get_type( void );
Imagedisplay *imagedisplay_new( Conversion *conv,
	GtkAdjustment *hadj, GtkAdjustment *vadj );

GtkAdjustment *imagedisplay_get_hadj( Imagedisplay *id );
GtkAdjustment *imagedisplay_get_vadj( Imagedisplay *id );

void imagedisplay_emit_expose_start( Imagedisplay *id, Rect *expose );
void imagedisplay_emit_repaint( Imagedisplay *id, Rect *expose );

void imagedisplay_xev_to_disp( Imagedisplay *id, 
	int ex, int ey, int *dx, int *dy );
void imagedisplay_disp_to_xev( Imagedisplay *id, 
	int dx, int dy, int *ex, int *ey );
void imagedisplay_xev_to_disp_rect( Imagedisplay *id, Rect *er, Rect *dr );
void imagedisplay_disp_to_xev_rect( Imagedisplay *id, Rect *dr, Rect *er );
