/* All ip headers.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/* Enable heap sanity checks on every alloc ... very slow ... also see heap.c
#define DEBUG_HEAP
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <assert.h>
#include <time.h>
#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <math.h>
#include <memory.h>
#include <locale.h>
#include <setjmp.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_PWD_H
#include <pwd.h>
#endif /*HAVE_PWD_H*/
#ifdef HAVE_FNMATCH_H
#include <fnmatch.h>
#endif /*HAVE_FNMATCH_H*/
#ifdef HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif /*HAVE_SYS_PARAM_H*/
#include <sys/stat.h>
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif /*HAVE_SYS_TIME_H*/
#include <sys/types.h>
#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif /*HAVE_SYS_RESOURCE_H*/
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif /*HAVE_SYS_WAIT_H*/
#ifdef HAVE_DIRENT_H
#include <dirent.h>
#endif /*HAVE_DIRENT_H*/
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /*HAVE_UNISTD_H*/
#ifdef HAVE_REGEX_H
#include <regex.h>
#endif /*HAVE_REGEX_H*/
#ifdef HAVE_SYS_STATVFS_H
#include <sys/statvfs.h>
#endif /*HAVE_SYS_STATVFS_H*/
#ifdef HAVE_SYS_VFS_H
#include <sys/vfs.h>
extern int statfs();
#endif /*HAVE_SYS_VFS_H*/
#ifdef HAVE_SYS_MOUNT_H
#include <sys/mount.h>
#endif /*HAVE_SYS_MOUNT_H*/
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#endif /*HAVE_WINDOWS_H*/
#ifdef HAVE_FFTW
#include <fftw.h>
#endif /*HAVE_FFTW*/

/* Have to include glib before dmalloc ... dmalloc may be included by vips.h
 */
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <vips/vips.h>
#include <vips/history.h>
#include <vips/util.h>
#include <vips/list.h>
#include <vips/rect.h>
#include <vips/colour.h>
#include <vips/region.h>
#include <vips/thread.h>
#include <vips/threadgroup.h>
#include <vips/dispatch.h>
#include <vips/time.h>

#include <libxml/tree.h>
#include <libxml/parser.h>

/* Our general widgets.
 */
#include "gtkmenubar2.h"
#include "orderitem.h"
#include "orderlist.h"
#include "led.h"
#include "doubleclick.h"

/* Most of our #defines.
 */
#define NAMELEN (256)		/* Length of a file name */
#define PATHLEN PATH_MAX	/* Length of a path name */
#define MAXFILES (4000)		/* Max. no of files in path */
#define STACK_SIZE (1000)	/* Depth of eval stack */
#define LEN_LABEL (512)		/* Label on windows */
#define TABLE_SIZE (2133)	/* Size of large hash tables */
#define SMALL_TABLE_SIZE (5)	/* Size of small hash tables */
#define MAX_SYSTEM (50)		/* Max number of args we allow */
#define MAX_CSTACK (10)		/* Max number of cursors we stack */
#define MAX_STRSIZE (16384)	/* Size of text for user defs */
#define MAX_TRACE (1024)	/* Biggest thing we print in trace */
#define MAX_SSTACK (20)		/* Scope stack for parser */
#define _(A) (A)		/* Avoid i18l issues for now */
#define VIPS_HOMEPAGE "http://www.vips.ecs.soton.ac.uk"
#define IP_COPYRIGHT PACKAGE ": (c) 2003 The National Gallery"
#define NIP_DOCPATH "$VIPSHOME" IM_DIR_SEP_STR "share" IM_DIR_SEP_STR \
	"doc" IM_DIR_SEP_STR PACKAGE IM_DIR_SEP_STR "html"
#define VIPS_DOCPATH "$VIPSHOME" IM_DIR_SEP_STR "share" IM_DIR_SEP_STR \
	"doc" IM_DIR_SEP_STR "vips" IM_DIR_SEP_STR "html"
#define IP_NAME PACKAGE "-" VERSION
#define IP_SAVEDIR "$HOME" IM_DIR_SEP_STR "." IP_NAME
#define NAMESPACE VIPS_HOMEPAGE "/" PACKAGE 
				/* XML namespace */
#define FULL_NAMESPACE NAMESPACE "/" VERSION
				/* Namespace with version info */
#define MAX_LINELENGTH (120)	/* Max chars we display of value */

/* How much we decompile for error messages.
 */
#define MAX_ERROR_FRAG (100)

/* Handle broken mkdirs()
 */
#if HAVE_MKDIR
# if MKDIR_TAKES_ONE_ARG
   /* Mingw32 */
#  define mkdir(a,b) mkdir(a)
# endif
#else
# ifdef HAVE__MKDIR
   /* plain Win32 */
#  include <direct.h>
#  define mkdir(a,b) _mkdir(a)
# else
#  error "Don't know how to create a directory on this system."
# endif
#endif

/* win32 adds '_'.
 */
#ifdef HAVE_WINDOWS_H
#define popen(b,m) _popen(b,m)
#define pclose(f) _pclose(f)
#define mktemp(f) _mktemp(f)
#endif

/* Fwd ref these.
 */
typedef struct _BuiltinInfo BuiltinInfo;
typedef struct _Classmodel Classmodel;
typedef struct _Colour Colour;
typedef struct _Column Column;
typedef struct _Columnview Columnview;
typedef struct _Compile Compile;
typedef struct _Conversion Conversion;
typedef struct _Conversionview Conversionview;
typedef struct _Expr Expr;
typedef struct _Filemodel Filemodel;
typedef struct _Heap Heap;
typedef struct _HeapBlock HeapBlock;
typedef struct _Heapmodel Heapmodel;
typedef struct _Iarrow Iarrow;
typedef struct _Iimage Iimage;
typedef struct _Imagedisplay Imagedisplay;
typedef struct _Imageinfo Imageinfo;
typedef struct _Imagepresent Imagepresent;
typedef struct _Iregion Iregion;
typedef struct _Iregiongroup Iregiongroup;
typedef struct _Link Link;
typedef struct _LinkExpr LinkExpr;
typedef struct _Model Model;
typedef struct _Paintboxview Paintboxview;
typedef struct _ParseConst ParseConst;
typedef struct _ParseNode ParseNode;
typedef struct _Program Program;
typedef struct _Real Real;
typedef struct _Reduce Reduce;
typedef struct _Regionview Regionview;
typedef struct _Rhs Rhs;
typedef struct _Rhsview Rhsview;
typedef struct _Row Row;
typedef struct _Rowview Rowview;
typedef struct _Statusview Statusview;
typedef struct _Subcolumn Subcolumn;
typedef struct _Subcolumnview Subcolumnview;
typedef struct _SymTable SymTable;
typedef struct _Symbol Symbol;
typedef struct _Tool Tool;
typedef struct _Toolkit Toolkit;
typedef struct _Toolkitgroup Toolkitgroup;
typedef struct _Toolkitgroupview Toolkitgroupview;
typedef struct _Toolkitview Toolkitview;
typedef struct _Toolview Toolview;
typedef struct _Trace Trace;
typedef struct _View View;
typedef struct _Workspace Workspace;
typedef struct _Workspacegroup Workspacegroup;
typedef struct _Workspacegroupview Workspacegroupview;
typedef struct _Workspaceview Workspaceview;
typedef struct _iText iText;

/* container map function typedefs.
 */
typedef void *(*row_map_fn)( Row *, void *, void *, void * );
typedef void *(*symbol_map_fn)( Symbol *, void *, void *, void * );
typedef void *(*column_map_fn)( Column *, void * );
typedef void *(*model_map_fn)( Model *, void *, void * );
typedef void *(*model_map3_fn)( Model *, void *, void *, void * );
typedef void *(*model_map4_fn)( Model *, void *, void *, void *, void * );
typedef void *(*model_map5_fn)( Model *, void *, void *, void *, void *, 
	void * );
typedef void *(*view_map_fn)( View *, void *, void * );
typedef void *(*rowview_map_fn)( Rowview *, void * );
typedef void *(*workspace_map_fn)( Workspace *, void * );
typedef void *(*toolkit_map_fn)( Toolkit *, void *, void * );

/* Util stuff.
 */
#include "wild.h"
#include "path.h"
#include "util.h"
#include "gtkutil.h"
#include "iwindow.h"
#include "idialog.h"
#include "boxes.h"
#include "gtkfilesel2.h"	/* hacked to derive from idialog */
#include "filesel.h"
#include "imageinfo.h"
#include "imagedisplay.h"
#include "colourdisplay.h"
#include "imagepresent.h"
#include "imageview.h"
#include "tslider.h"

/* Basic ip includes (order important).
 */
#include "tree.h"
#include "heap.h"
#include "class.h"
#include "link.h"
#include "expr.h"
#include "model.h"
#include "paintboxview.h"
#include "conversion.h"
#include "heapmodel.h"
#include "classmodel.h"
#include "filemodel.h"
#include "symbol.h"
#include "workspace.h"
#include "workspacegroup.h"
#include "toolkitgroup.h"
#include "secret.h"
#include "action.h"
#include "reduce.h"
#include "view.h"
#include "spin.h"
#include "row.h"
#include "rowview.h"
#include "subcolumn.h"
#include "subcolumnview.h"
#include "rhs.h"
#include "rhsview.h"
#include "workspaceview.h"
#include "workspacegroupview.h"
#include "toolkitgroupview.h"
#include "column.h"
#include "columnview.h"
#include "toolkit.h"
#include "tool.h"
#include "toolkitview.h"
#include "toolview.h"
#include "watch.h"

/* Per module includes, any order
 */
#include "asynch.h"
#include "trace.h"
#include "program.h"
#include "conversionview.h"
#include "statusview.h"
#include "mainw.h"
#include "browse.h"
#include "builtin.h"
#include "command.h"
#include "compile.h"
#include "dump.h"
#include "graph.h"
#include "main.h"
#include "predicate.h"
#include "slider.h"
#include "filename.h"
#include "colour.h"
#include "real.h"
#include "realview.h"
#include "matrix.h"
#include "matrixview.h"
#include "option.h"
#include "optionview.h"
#include "iimage.h"
#include "iregion.h"
#include "iregiongroup.h"
#include "iarrow.h"
#include "iarrowview.h"
#include "sliderview.h"
#include "filenameview.h"
#include "colourview.h"
#include "iimageview.h"
#include "iregionview.h"
#include "iregiongroupview.h"
#include "regionview.h"
#include "table.h"
#include "itext.h"
#include "itextview.h"
#include "toggle.h"
#include "toggleview.h"
#include "vips_call.h"

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif /*WITH_DMALLOC*/

/* Global variables from parse.y.

	FIXME move to its own header ... parser.h?

 */

/* Our input stream can be attached to either a string or a FILE. 
 * Keep track of the state of play here.
 */
typedef struct {
	iOpenFile *of;		/* Non-NULL if we read from a file */
	char *str;		/* Non-NULL if we read from a string */
	char *strpos;		/* Position in string */

	char buf[MAX_STRSIZE];	/* Accumulate text of each definition here */
	int bwp;		/* Write point in the above */
	int bsp[MAX_SSTACK];	/* Start point stack */
	int bspsp;		/* Stack pointer */

	int lineno;		/* Current line number */
	int charno;		/* Character in line */
	int pcharno;		/* Characters in previous line */
	int charpos;		/* Characters read by lex so far */

	int oldchar;            /* unget buffer, -1 for no unget */
} InputState;

extern InputState input_state;

/* Function declarations for parse.y.
 */
void yyerror( const char *fmt, ... );	/* Error during processing of expr */
extern int yyleng;			/* lex stuff */

/* Lex gathers tokens here for workspace.c
 */
extern BufInfo lex_text;

/* Attach input for lex.
 */
void attach_input_file( iOpenFile *of );
void attach_input_string( const char *str );
int ip_input( void );
void ip_unput( int ch );
gboolean is_EOF( void );

/* Parse stuff.
 */

/* Order and number important ... see table in parse_rhs()
 */
typedef enum {
	PARSE_RHS = 0,		/* eg. "a + b" */
	PARSE_PARAMS,		/* eg. "a b = a + b" */
	PARSE_SUPER 		/* eg. "fred c d" */
} ParseRhsSyntax;

gboolean parse_toplevel( Toolkit *kit, int pos );
gboolean parse_onedef( Toolkit *kit, int pos );
gboolean parse_rhs( Expr *expr, ParseRhsSyntax syntax, gboolean optimise );

extern Symbol *last_top_sym;

