/* run the display for a option in a workspace 
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ViewClass *parent_class = NULL;

static void
optionview_destroy( GtkObject *object )
{
	Optionview *optionview;

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_OPTIONVIEW( object ) );

	optionview = OPTIONVIEW( object );

	/* My instance destroy stuff.
	 */

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* Change to a optionview widget ... update the model. 
 */
/*ARGSUSED*/
static void
optionview_change_cb( GtkWidget *wid, Optionview *optionview )
{
	Option *option = OPTION( VIEW( optionview )->model );
	Classmodel *classmodel = CLASSMODEL( option );

	const int nvalue = get_goption( optionview->options );

	if( option->value != nvalue ) {
		option->value = nvalue;

		classmodel_update( classmodel );
		symbol_recalculate_all();
	}
}

static void 
optionview_refresh( View *view )
{
	Optionview *optionview = OPTIONVIEW( view );
	Option *option = OPTION( view->model );

	GtkWidget *pane, *item;
	GSList *p;
	int nitems, i;

#ifdef DEBUG
	printf( "optionview_refresh\n" );
#endif /*DEBUG*/

	/* New menu.
	 */
	pane = gtk_menu_new();
	for( p = option->labels, i = 0; p; p = p->next, i++ ) {
		item = gtk_menu_item_new_with_label( (char *) p->data );
		gtk_signal_connect( GTK_OBJECT( item ), "activate", 
			GTK_SIGNAL_FUNC( optionview_change_cb ), optionview );
		gtk_menu_append( GTK_MENU( pane ), item );
	}
	nitems = i;
	gtk_widget_show_all( GTK_WIDGET( pane ) );
	gtk_option_menu_set_menu( 
		GTK_OPTION_MENU( optionview->options ), pane );

	/* Set the start value for the symbol.
	 */
	i = IM_CLIP( 0, option->value, nitems - 1 );
	set_goption( optionview->options, i );

	set_glabel( optionview->caption, "%s", MODEL( option )->caption );

	VIEW_CLASS( parent_class )->refresh( view );
}

static void
optionview_class_init( OptionviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ViewClass *view_class = (ViewClass *) klass;

	parent_class = gtk_type_class( TYPE_VIEW );

	object_class->destroy = optionview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	view_class->refresh = optionview_refresh;
}

static void
optionview_init( Optionview *optionview )
{
	GtkWidget *hb;

        hb = gtk_hbox_new( FALSE, 0 );
        optionview->caption = gtk_label_new( "" );
        gtk_box_pack_start( GTK_BOX( hb ), 
		optionview->caption, FALSE, FALSE, 2 );
	optionview->options = gtk_option_menu_new();
        gtk_box_pack_start( GTK_BOX( hb ), 
		optionview->options, FALSE, FALSE, 2 );
        set_tooltip( optionview->options, "Left-click to change value" );

        gtk_box_pack_start( GTK_BOX( optionview ), hb, FALSE, FALSE, 0 );

        gtk_widget_show_all( GTK_WIDGET( optionview ) );
}

GtkType
optionview_get_type( void )
{
	static GtkType optionview_type = 0;

	if( !optionview_type ) {
		static const GtkTypeInfo sinfo = {
			"Optionview",
			sizeof( Optionview ),
			sizeof( OptionviewClass ),
			(GtkClassInitFunc) optionview_class_init,
			(GtkObjectInitFunc) optionview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		optionview_type = gtk_type_unique( TYPE_VIEW, &sinfo );
	}

	return( optionview_type );
}

View *
optionview_new( void )
{
	Optionview *optionview = gtk_type_new( TYPE_OPTIONVIEW );

	return( VIEW( optionview ) );
}
