/* Watch stuff in the prefs workspace.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your watch) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/* Abstract base class for something that watches a watch row.
 */

typedef struct _Watch Watch;

#define TYPE_WATCH (watch_get_type())
#define WATCH( obj ) (GTK_CHECK_CAST( (obj), TYPE_WATCH, Watch ))
#define WATCH_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), TYPE_WATCH, WatchClass ))
#define IS_WATCH( obj ) (GTK_CHECK_TYPE( (obj), TYPE_WATCH ))
#define IS_WATCH_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_WATCH ))

struct _Watch {
	GtkObject parent_class;

	char *name;			/* Name of symbol */
	Row *row;			/* Row we watch */
	gboolean ok;			/* Value read OK on last change */

	guint destroy_sid;		/* Listen for events */
	guint changed_sid;
};

typedef struct _WatchClass {
	GtkObjectClass parent_class;

	/* Update value from row.
	 */
	gboolean (*update)( Watch * );

	/* Get a pointer to value.
	 */
	void *(*get_value)( Watch * );
} WatchClass;

GtkType watch_get_type( void );

/* A watch that watches something with an int value.
 */

typedef struct _WatchInt WatchInt;

#define TYPE_WATCH_INT (watch_int_get_type())
#define WATCH_INT( obj ) \
	(GTK_CHECK_CAST( (obj), TYPE_WATCH_INT, WatchInt ))
#define WATCH_INT_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), \
		TYPE_WATCH_INT, WatchIntClass ))
#define IS_WATCH_INT( obj ) (GTK_CHECK_TYPE( (obj), TYPE_WATCH_INT ))
#define IS_WATCH_INT_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_WATCH_INT ))

struct _WatchInt {
	Watch parent_class;

	int value;
};

typedef struct _WatchIntClass {
	WatchClass parent_class;

} WatchIntClass;

GtkType watch_int_get_type( void );
int watch_int_get( const char *name, int fallback );

/* A watch that watches something with a double value.
 */

typedef struct _WatchDouble WatchDouble;

#define TYPE_WATCH_DOUBLE (watch_double_get_type())
#define WATCH_DOUBLE( obj ) \
	(GTK_CHECK_CAST( (obj), TYPE_WATCH_DOUBLE, WatchDouble ))
#define WATCH_DOUBLE_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), \
		TYPE_WATCH_DOUBLE, WatchDoubleClass ))
#define IS_WATCH_DOUBLE( obj ) \
	(GTK_CHECK_TYPE( (obj), TYPE_WATCH_DOUBLE ))
#define IS_WATCH_DOUBLE_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_WATCH_DOUBLE ))

struct _WatchDouble {
	Watch parent_class;

	double value;
};

typedef struct _WatchDoubleClass {
	WatchClass parent_class;

} WatchDoubleClass;

GtkType watch_double_get_type( void );
double watch_double_get( const char *name, double fallback );

/* A watch that watches a path.
 */

typedef struct _WatchPath WatchPath;

#define TYPE_WATCH_PATH (watch_path_get_type())
#define WATCH_PATH( obj ) \
	(GTK_CHECK_CAST( (obj), TYPE_WATCH_PATH, WatchPath ))
#define WATCH_PATH_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), \
		TYPE_WATCH_PATH, WatchPathClass ))
#define IS_WATCH_PATH( obj ) \
	(GTK_CHECK_TYPE( (obj), TYPE_WATCH_PATH ))
#define IS_WATCH_PATH_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_WATCH_PATH ))

struct _WatchPath {
	Watch parent_class;

	GSList *value;
};

typedef struct _WatchPathClass {
	WatchClass parent_class;

} WatchPathClass;

GtkType watch_path_get_type( void );
GSList *watch_path_get( const char *name, GSList *fallback );

typedef struct _WatchBool WatchBool;

#define TYPE_WATCH_BOOL (watch_bool_get_type())
#define WATCH_BOOL( obj ) \
	(GTK_CHECK_CAST( (obj), TYPE_WATCH_BOOL, WatchBool ))
#define WATCH_BOOL_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), \
		TYPE_WATCH_BOOL, WatchBoolClass ))
#define IS_WATCH_BOOL( obj ) \
	(GTK_CHECK_TYPE( (obj), TYPE_WATCH_BOOL ))
#define IS_WATCH_BOOL_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_WATCH_BOOL ))

struct _WatchBool {
	Watch parent_class;

	gboolean value;
};

typedef struct _WatchBoolClass {
	WatchClass parent_class;

} WatchBoolClass;

GtkType watch_bool_get_type( void );
gboolean watch_bool_get( const char *name, gboolean fallback );

typedef struct _WatchString WatchString;

#define TYPE_WATCH_STRING (watch_string_get_type())
#define WATCH_STRING( obj ) \
	(GTK_CHECK_CAST( (obj), TYPE_WATCH_STRING, WatchString ))
#define WATCH_STRING_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), \
		TYPE_WATCH_STRING, WatchStringClass ))
#define IS_WATCH_STRING( obj ) \
	(GTK_CHECK_TYPE( (obj), TYPE_WATCH_STRING ))
#define IS_WATCH_STRING_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_WATCH_STRING ))

struct _WatchString {
	Watch parent_class;

	char *value;
};

typedef struct _WatchStringClass {
	WatchClass parent_class;

} WatchStringClass;

GtkType watch_string_get_type( void );
const char *watch_string_get( const char *name, const char *fallback );
