#ifndef __NJAMD_FE_UTIL_ERR_H__
#define __NJAMD_FE_UTIL_ERR_H__

#include <fe/njamd.h>

#define perrfn(ret, fn, file, line, format, args...) \
	err(ret, "ERROR in function %s: %s: %i:\n" format, fn, file, line, ## args)

void err(int ret, const char* format, ...);
void verr(int ret, const char* format, va_list args);
void warn(const char* format, ...);
void vwarn(const char* format, va_list args);

#endif /* __NJAMD_FE_UTIL_ERR_H__ */
