
/**
 * @file public.h
 *
 * Functions exported publicly
 */
#ifndef __NJ_LIB_PUBLIC_H__
#define __NJ_LIB_PUBLIC_H__

#include <config.h>
#include <signal.h>

/* From public.c */
#ifdef HAVE_POSIX_SIGACTION
void __nj_public_signals_dispatch(int sig, siginfo_t *info, void *arg);
#else
void  __nj_public_signals_dispatch(int sig);
#endif

void __nj_ptr_info(nj_addr_t ptr);
    
/**@{ @name Callstack placeholder symbols */
void __nj_public_init();
void __nj_public_end();
void __nj_pthread_exit_start();
void __nj_pthread_exit_end();
void __nj_exit_start();
void __nj_exit_end();

/*@}*/

#endif /* public.h */
// vim:ts=4
