#include <fe/njamd.h>
#include <fe/fe.h>
#include <fe/gui/gui.h>
#include <fe/gui/mainwin.h>
#include <fe/gui/msgbox.h>
#include <fe/gui/util.h>

static pid_t child = -1;
static NJGUI gui;

static void _njGUIStartDebugging(GtkWidget* widget, gpointer data);
static void _njGUIFileSelClose(GtkWidget* widget, gpointer data);
static void _njGUIFileSelDestroyed(GtkWidget* widget, gpointer data);

void njGUIStart(int argc, char* argv[], NJOPTIONS* opts)
{
	gtk_init(&argc, &argv);

	njGUICreateMainWin(&gui);

	gtk_widget_show_all(gui.window);

	gtk_main();
}

void njGUIStartDebugging(GtkWidget* w, gpointer data)
{
	GtkWidget* fileSelWidget;
	GtkFileSelection* fileSel;

	if (child != -1) {
		njGUIMessageBox(gui.window, "Another process is already running!",
			NJAPPNAME, NJMB_OK);
		return;
	}

	fileSelWidget = gtk_file_selection_new(NJAPPNAME ": Select process");

	fileSel = GTK_FILE_SELECTION(fileSelWidget);

	gtk_signal_connect(GTK_OBJECT(fileSel->ok_button), "clicked",
		GTK_SIGNAL_FUNC(_njGUIStartDebugging), (gpointer) fileSel);
	gtk_signal_connect(GTK_OBJECT(fileSel->ok_button), "clicked",
		GTK_SIGNAL_FUNC(_njGUIFileSelClose), (gpointer) fileSel);
	gtk_signal_connect(GTK_OBJECT(fileSel->cancel_button), "clicked",
		GTK_SIGNAL_FUNC(_njGUIFileSelClose), (gpointer) fileSel);
	gtk_signal_connect(GTK_OBJECT(fileSel), "destroy",
		GTK_SIGNAL_FUNC(_njGUIFileSelDestroyed), (gpointer) gui.window);

	njCenterWindow(fileSelWidget, gui.window);
	njSetModal(fileSelWidget, gui.window, TRUE);

	gtk_widget_show(fileSelWidget);
}

void njGUIStopDebugging(GtkWidget* w, gpointer data)
{
	if (child == -1) {
		njGUIMessageBox(gui.window, "No process is running!", NJAPPNAME,
			NJMB_OK);
		return;
	}

	/* do stuff */

	child = -1;
}

void njGUIExitProgram(GtkWidget* w, gpointer data)
{
	exit((int) data);
}

void njGUICut(GtkWidget* w, gpointer data)
{
}

void njGUICopy(GtkWidget* w, gpointer data)
{
}

void njGUIPaste(GtkWidget* w, gpointer data)
{
}

void njGUIAbout(GtkWidget* w, gpointer data)
{
}

static void _njGUIStartDebugging(GtkWidget* widget, gpointer data)
{
	GtkFileSelection* fileSel = (GtkFileSelection*) data;
	gchar* filename = gtk_file_selection_get_filename(fileSel);

	printf("%s\n", filename);
}

static void _njGUIFileSelClose(GtkWidget* widget, gpointer data)
{
	gtk_widget_destroy((GtkWidget*) data);
}

static void _njGUIFileSelDestroyed(GtkWidget* widget, gpointer data)
{
	njSetModal(widget, (GtkWidget*) data, FALSE);
}
