// 
// Copyright (c) 2004-2006 Jaroslaw Kowalski <jaak@jkowalski.net>
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions 
// are met:
// 
// * Redistributions of source code must retain the above copyright notice, 
//   this list of conditions and the following disclaimer. 
// 
// * Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the following disclaimer in the documentation
//   and/or other materials provided with the distribution. 
// 
// * Neither the name of Jaroslaw Kowalski nor the names of its 
//   contributors may be used to endorse or promote products derived from this
//   software without specific prior written permission. 
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.
// 

using System;

namespace NLog
{
    /// <summary>
    /// Marks class as a layout renderer and assigns a format string to it.
    /// </summary>
    [AttributeUsage(AttributeTargets.Class)]
    public sealed class LayoutRendererAttribute: Attribute
    {
        private string _formatString;
        private bool _ignoresPadding = false;
        private bool _usingLogEventInfo = false;

        /// <summary>
        /// Creates a new instance of <see cref="LayoutRendererAttribute"/>
        /// and assigns the <see cref="FormatString"/> to the specified value.
        /// </summary>
        /// <param name="formatString"></param>
        public LayoutRendererAttribute(string formatString)
        {
            _formatString = formatString;
        }

        /// <summary>
        /// The format string that can be used to invoke the layout renderer.
        /// </summary>
        public string FormatString
        {
            get { return _formatString; }
        }

        /// <summary>
        /// Marks the specified layout renderer as ignoring padding (used mostly for
        /// documentation generation).
        /// </summary>
        public bool IgnoresPadding
        {
            get { return _ignoresPadding; }
            set { _ignoresPadding = value; }
        }

        /// <summary>
        /// Marks the specified layout renderer as relying purely on the contents
        /// of <see cref="LogEventInfo"/> only and not on any other information (such as thread-
        /// </summary>
        public bool UsingLogEventInfo
        {
            get { return _usingLogEventInfo; }
            set { _usingLogEventInfo = value; }
        }
    }
}
