/************************************************************************
* edit.c
* nodau console note taker
* Copyright (C) Lisa Milne 2010 <lisa@ltmnet.com>
*
* edit.c is free software: you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* edit.c is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program.  If not, see <http://www.gnu.org/licenses/>
************************************************************************/

#include <unistd.h>
#include <ncurses.h>
#include <ctype.h>

#include "nodau.h"

/* local storage for note name and date */
static char* bname;
static char* bdate;

/* draw to the screen */
static void draw(char* data)
{
	/* clear the screen */
	clear();
	/* print the name and date in bold */
	attron(A_BOLD);
	printw("%s (%s):\n",bname,bdate);
	attroff(A_BOLD);
	/* print the note body */
	printw("%s",data);
	/* refresh the screen */
	refresh();
}

/* edit a note */
void edit(char* name, char* date, char* data)
{
	/* set the local data */
	bname = name;
	bdate = date;
	/* find the buffer length */
	int bl = strlen(data);
	/* create the buffer */
	char buffer[256];
	/* fill the buffer with 0's */
	memset(&buffer,0,256);

	/* if the note is too long, shorten it */
	if (bl > 255) {
		data[255] = 0;
		bl = 255;
	}

	/* put the note into the buffer */
	sprintf(buffer, "%s", data);

	/* init ncurses */
	initscr();
	/* no line buffering */
	cbreak();
	/* get all the keys */
	keypad(stdscr, TRUE);
	/* don't echo keypresses */
	noecho();

	/* still editing? */
	int quit = 0;

	/* character storage */
	int plch = 0;
	int lch = 0;
	int ch;

	/* while we are editing */
	while (!quit) {
		/* draw the screen */
		draw(buffer);
		/* set previous last char to last char */
		plch = lch;
		/* set last char to char */
		lch = ch;
		/* get char */
		ch = getch();
		/* if it's printable or newline */
		if (isprint(ch) || ch == '\n') {
			bl++;
			/* if the note is under 255 chars, add the char */
			if (bl < 255) {
				buffer[bl-1] = ch;
				buffer[bl] = 0;
			}
		/* backspace means delete a char */
		}else if (ch == 127 || ch == KEY_BACKSPACE) {
			/* if we've got one to delete */
			if (bl > 0) {
				bl--;
				buffer[bl] = 0;
			}
		}

		/* check for newline dot exit */
		if (plch == '\n' && lch == '.' && ch == '\n') {
			/* don't include the dot in the note */
			bl -= 3;
			buffer[bl] = 0;
			quit = 1;
		/* check for escape exit */
		}else if (ch == 27) {
			quit = 1;
		}
	}

	/* exit ncurses */
	endwin();

	/* save the note */
	db_update(name,buffer);

	/* let the user know */
	printf("%s saved\n",name);
}
