// @flow
/*
 * This file is auto-generated! Do not modify it directly.
 * To re-generate run 'make build'
 */
import shallowEqual from "../../utils/shallowEqual";

export function isArrayExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ArrayExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isAssignmentExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "AssignmentExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isBinaryExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "BinaryExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isInterpreterDirective(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "InterpreterDirective") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDirective(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "Directive") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDirectiveLiteral(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DirectiveLiteral") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isBlockStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "BlockStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isBreakStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "BreakStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isCallExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "CallExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isCatchClause(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "CatchClause") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isConditionalExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ConditionalExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isContinueStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ContinueStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDebuggerStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DebuggerStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDoWhileStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DoWhileStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEmptyStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "EmptyStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isExpressionStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ExpressionStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFile(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "File") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isForInStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ForInStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isForStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ForStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFunctionDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "FunctionDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFunctionExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "FunctionExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isIdentifier(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "Identifier") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isIfStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "IfStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isLabeledStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "LabeledStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isStringLiteral(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "StringLiteral") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isNumericLiteral(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "NumericLiteral") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isNullLiteral(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "NullLiteral") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isBooleanLiteral(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "BooleanLiteral") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isRegExpLiteral(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "RegExpLiteral") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isLogicalExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "LogicalExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isMemberExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "MemberExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isNewExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "NewExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isProgram(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "Program") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isObjectExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ObjectExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isObjectMethod(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ObjectMethod") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isObjectProperty(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ObjectProperty") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isRestElement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "RestElement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isReturnStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ReturnStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isSequenceExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "SequenceExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isParenthesizedExpression(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ParenthesizedExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isSwitchCase(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "SwitchCase") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isSwitchStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "SwitchStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isThisExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ThisExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isThrowStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ThrowStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTryStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TryStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isUnaryExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "UnaryExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isUpdateExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "UpdateExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isVariableDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "VariableDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isVariableDeclarator(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "VariableDeclarator") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isWhileStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "WhileStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isWithStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "WithStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isAssignmentPattern(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "AssignmentPattern") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isArrayPattern(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ArrayPattern") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isArrowFunctionExpression(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ArrowFunctionExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isClassBody(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ClassBody") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isClassExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ClassExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isClassDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ClassDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isExportAllDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ExportAllDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isExportDefaultDeclaration(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ExportDefaultDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isExportNamedDeclaration(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ExportNamedDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isExportSpecifier(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ExportSpecifier") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isForOfStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ForOfStatement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isImportDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ImportDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isImportDefaultSpecifier(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ImportDefaultSpecifier") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isImportNamespaceSpecifier(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ImportNamespaceSpecifier") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isImportSpecifier(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ImportSpecifier") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isMetaProperty(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "MetaProperty") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isClassMethod(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ClassMethod") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isObjectPattern(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ObjectPattern") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isSpreadElement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "SpreadElement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isSuper(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "Super") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTaggedTemplateExpression(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TaggedTemplateExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTemplateElement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TemplateElement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTemplateLiteral(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TemplateLiteral") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isYieldExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "YieldExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isAwaitExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "AwaitExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isImport(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "Import") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isBigIntLiteral(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "BigIntLiteral") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isExportNamespaceSpecifier(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ExportNamespaceSpecifier") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isOptionalMemberExpression(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "OptionalMemberExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isOptionalCallExpression(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "OptionalCallExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isAnyTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "AnyTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isArrayTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ArrayTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isBooleanTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "BooleanTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isBooleanLiteralTypeAnnotation(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "BooleanLiteralTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isNullLiteralTypeAnnotation(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "NullLiteralTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isClassImplements(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ClassImplements") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDeclareClass(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DeclareClass") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDeclareFunction(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DeclareFunction") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDeclareInterface(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DeclareInterface") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDeclareModule(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DeclareModule") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDeclareModuleExports(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DeclareModuleExports") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDeclareTypeAlias(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DeclareTypeAlias") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDeclareOpaqueType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DeclareOpaqueType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDeclareVariable(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DeclareVariable") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDeclareExportDeclaration(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DeclareExportDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDeclareExportAllDeclaration(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DeclareExportAllDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDeclaredPredicate(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DeclaredPredicate") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isExistsTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ExistsTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFunctionTypeAnnotation(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "FunctionTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFunctionTypeParam(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "FunctionTypeParam") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isGenericTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "GenericTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isInferredPredicate(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "InferredPredicate") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isInterfaceExtends(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "InterfaceExtends") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isInterfaceDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "InterfaceDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isInterfaceTypeAnnotation(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "InterfaceTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isIntersectionTypeAnnotation(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "IntersectionTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isMixedTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "MixedTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEmptyTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "EmptyTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isNullableTypeAnnotation(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "NullableTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isNumberLiteralTypeAnnotation(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "NumberLiteralTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isNumberTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "NumberTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isObjectTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ObjectTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isObjectTypeInternalSlot(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ObjectTypeInternalSlot") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isObjectTypeCallProperty(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ObjectTypeCallProperty") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isObjectTypeIndexer(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ObjectTypeIndexer") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isObjectTypeProperty(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ObjectTypeProperty") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isObjectTypeSpreadProperty(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ObjectTypeSpreadProperty") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isOpaqueType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "OpaqueType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isQualifiedTypeIdentifier(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "QualifiedTypeIdentifier") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isStringLiteralTypeAnnotation(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "StringLiteralTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isStringTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "StringTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isSymbolTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "SymbolTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isThisTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ThisTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTupleTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TupleTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTypeofTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TypeofTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTypeAlias(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TypeAlias") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTypeCastExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TypeCastExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTypeParameter(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TypeParameter") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTypeParameterDeclaration(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TypeParameterDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTypeParameterInstantiation(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TypeParameterInstantiation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isUnionTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "UnionTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isVariance(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "Variance") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isVoidTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "VoidTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEnumDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "EnumDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEnumBooleanBody(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "EnumBooleanBody") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEnumNumberBody(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "EnumNumberBody") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEnumStringBody(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "EnumStringBody") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEnumSymbolBody(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "EnumSymbolBody") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEnumBooleanMember(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "EnumBooleanMember") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEnumNumberMember(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "EnumNumberMember") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEnumStringMember(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "EnumStringMember") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEnumDefaultedMember(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "EnumDefaultedMember") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXAttribute(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXAttribute") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXClosingElement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXClosingElement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXElement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXElement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXEmptyExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXEmptyExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXExpressionContainer(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXExpressionContainer") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXSpreadChild(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXSpreadChild") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXIdentifier(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXIdentifier") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXMemberExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXMemberExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXNamespacedName(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXNamespacedName") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXOpeningElement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXOpeningElement") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXSpreadAttribute(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXSpreadAttribute") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXText(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXText") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXFragment(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXFragment") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXOpeningFragment(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXOpeningFragment") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSXClosingFragment(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "JSXClosingFragment") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isNoop(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "Noop") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isPlaceholder(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "Placeholder") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isV8IntrinsicIdentifier(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "V8IntrinsicIdentifier") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isArgumentPlaceholder(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ArgumentPlaceholder") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isBindExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "BindExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isClassProperty(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ClassProperty") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isPipelineTopicExpression(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "PipelineTopicExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isPipelineBareFunction(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "PipelineBareFunction") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isPipelinePrimaryTopicReference(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "PipelinePrimaryTopicReference") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isClassPrivateProperty(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ClassPrivateProperty") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isClassPrivateMethod(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ClassPrivateMethod") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isImportAttribute(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ImportAttribute") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDecorator(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "Decorator") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDoExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DoExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isExportDefaultSpecifier(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "ExportDefaultSpecifier") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isPrivateName(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "PrivateName") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isRecordExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "RecordExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTupleExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TupleExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDecimalLiteral(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "DecimalLiteral") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSParameterProperty(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSParameterProperty") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSDeclareFunction(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSDeclareFunction") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSDeclareMethod(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSDeclareMethod") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSQualifiedName(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSQualifiedName") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSCallSignatureDeclaration(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSCallSignatureDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSConstructSignatureDeclaration(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSConstructSignatureDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSPropertySignature(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSPropertySignature") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSMethodSignature(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSMethodSignature") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSIndexSignature(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSIndexSignature") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSAnyKeyword(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSAnyKeyword") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSBooleanKeyword(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSBooleanKeyword") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSBigIntKeyword(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSBigIntKeyword") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSNeverKeyword(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSNeverKeyword") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSNullKeyword(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSNullKeyword") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSNumberKeyword(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSNumberKeyword") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSObjectKeyword(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSObjectKeyword") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSStringKeyword(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSStringKeyword") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSSymbolKeyword(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSSymbolKeyword") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSUndefinedKeyword(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSUndefinedKeyword") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSUnknownKeyword(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSUnknownKeyword") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSVoidKeyword(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSVoidKeyword") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSThisType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSThisType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSFunctionType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSFunctionType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSConstructorType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSConstructorType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTypeReference(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSTypeReference") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTypePredicate(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSTypePredicate") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTypeQuery(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSTypeQuery") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTypeLiteral(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSTypeLiteral") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSArrayType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSArrayType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTupleType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSTupleType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSOptionalType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSOptionalType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSRestType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSRestType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSNamedTupleMember(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSNamedTupleMember") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSUnionType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSUnionType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSIntersectionType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSIntersectionType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSConditionalType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSConditionalType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSInferType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSInferType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSParenthesizedType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSParenthesizedType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTypeOperator(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSTypeOperator") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSIndexedAccessType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSIndexedAccessType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSMappedType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSMappedType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSLiteralType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSLiteralType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSExpressionWithTypeArguments(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSExpressionWithTypeArguments") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSInterfaceDeclaration(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSInterfaceDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSInterfaceBody(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSInterfaceBody") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTypeAliasDeclaration(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSTypeAliasDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSAsExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSAsExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTypeAssertion(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSTypeAssertion") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSEnumDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSEnumDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSEnumMember(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSEnumMember") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSModuleDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSModuleDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSModuleBlock(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSModuleBlock") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSImportType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSImportType") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSImportEqualsDeclaration(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSImportEqualsDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSExternalModuleReference(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSExternalModuleReference") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSNonNullExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSNonNullExpression") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSExportAssignment(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSExportAssignment") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSNamespaceExportDeclaration(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSNamespaceExportDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTypeAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSTypeAnnotation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTypeParameterInstantiation(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSTypeParameterInstantiation") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTypeParameterDeclaration(
  node: ?Object,
  opts?: Object,
): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSTypeParameterDeclaration") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTypeParameter(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "TSTypeParameter") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isExpression(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Expression" ||
    "ArrayExpression" === nodeType ||
    "AssignmentExpression" === nodeType ||
    "BinaryExpression" === nodeType ||
    "CallExpression" === nodeType ||
    "ConditionalExpression" === nodeType ||
    "FunctionExpression" === nodeType ||
    "Identifier" === nodeType ||
    "StringLiteral" === nodeType ||
    "NumericLiteral" === nodeType ||
    "NullLiteral" === nodeType ||
    "BooleanLiteral" === nodeType ||
    "RegExpLiteral" === nodeType ||
    "LogicalExpression" === nodeType ||
    "MemberExpression" === nodeType ||
    "NewExpression" === nodeType ||
    "ObjectExpression" === nodeType ||
    "SequenceExpression" === nodeType ||
    "ParenthesizedExpression" === nodeType ||
    "ThisExpression" === nodeType ||
    "UnaryExpression" === nodeType ||
    "UpdateExpression" === nodeType ||
    "ArrowFunctionExpression" === nodeType ||
    "ClassExpression" === nodeType ||
    "MetaProperty" === nodeType ||
    "Super" === nodeType ||
    "TaggedTemplateExpression" === nodeType ||
    "TemplateLiteral" === nodeType ||
    "YieldExpression" === nodeType ||
    "AwaitExpression" === nodeType ||
    "Import" === nodeType ||
    "BigIntLiteral" === nodeType ||
    "OptionalMemberExpression" === nodeType ||
    "OptionalCallExpression" === nodeType ||
    "TypeCastExpression" === nodeType ||
    "JSXElement" === nodeType ||
    "JSXFragment" === nodeType ||
    "BindExpression" === nodeType ||
    "PipelinePrimaryTopicReference" === nodeType ||
    "DoExpression" === nodeType ||
    "RecordExpression" === nodeType ||
    "TupleExpression" === nodeType ||
    "DecimalLiteral" === nodeType ||
    "TSAsExpression" === nodeType ||
    "TSTypeAssertion" === nodeType ||
    "TSNonNullExpression" === nodeType ||
    (nodeType === "Placeholder" &&
      ("Expression" === node.expectedNode ||
        "Identifier" === node.expectedNode ||
        "StringLiteral" === node.expectedNode))
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isBinary(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Binary" ||
    "BinaryExpression" === nodeType ||
    "LogicalExpression" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isScopable(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Scopable" ||
    "BlockStatement" === nodeType ||
    "CatchClause" === nodeType ||
    "DoWhileStatement" === nodeType ||
    "ForInStatement" === nodeType ||
    "ForStatement" === nodeType ||
    "FunctionDeclaration" === nodeType ||
    "FunctionExpression" === nodeType ||
    "Program" === nodeType ||
    "ObjectMethod" === nodeType ||
    "SwitchStatement" === nodeType ||
    "WhileStatement" === nodeType ||
    "ArrowFunctionExpression" === nodeType ||
    "ClassExpression" === nodeType ||
    "ClassDeclaration" === nodeType ||
    "ForOfStatement" === nodeType ||
    "ClassMethod" === nodeType ||
    "ClassPrivateMethod" === nodeType ||
    "TSModuleBlock" === nodeType ||
    (nodeType === "Placeholder" && "BlockStatement" === node.expectedNode)
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isBlockParent(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "BlockParent" ||
    "BlockStatement" === nodeType ||
    "CatchClause" === nodeType ||
    "DoWhileStatement" === nodeType ||
    "ForInStatement" === nodeType ||
    "ForStatement" === nodeType ||
    "FunctionDeclaration" === nodeType ||
    "FunctionExpression" === nodeType ||
    "Program" === nodeType ||
    "ObjectMethod" === nodeType ||
    "SwitchStatement" === nodeType ||
    "WhileStatement" === nodeType ||
    "ArrowFunctionExpression" === nodeType ||
    "ForOfStatement" === nodeType ||
    "ClassMethod" === nodeType ||
    "ClassPrivateMethod" === nodeType ||
    "TSModuleBlock" === nodeType ||
    (nodeType === "Placeholder" && "BlockStatement" === node.expectedNode)
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isBlock(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Block" ||
    "BlockStatement" === nodeType ||
    "Program" === nodeType ||
    "TSModuleBlock" === nodeType ||
    (nodeType === "Placeholder" && "BlockStatement" === node.expectedNode)
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Statement" ||
    "BlockStatement" === nodeType ||
    "BreakStatement" === nodeType ||
    "ContinueStatement" === nodeType ||
    "DebuggerStatement" === nodeType ||
    "DoWhileStatement" === nodeType ||
    "EmptyStatement" === nodeType ||
    "ExpressionStatement" === nodeType ||
    "ForInStatement" === nodeType ||
    "ForStatement" === nodeType ||
    "FunctionDeclaration" === nodeType ||
    "IfStatement" === nodeType ||
    "LabeledStatement" === nodeType ||
    "ReturnStatement" === nodeType ||
    "SwitchStatement" === nodeType ||
    "ThrowStatement" === nodeType ||
    "TryStatement" === nodeType ||
    "VariableDeclaration" === nodeType ||
    "WhileStatement" === nodeType ||
    "WithStatement" === nodeType ||
    "ClassDeclaration" === nodeType ||
    "ExportAllDeclaration" === nodeType ||
    "ExportDefaultDeclaration" === nodeType ||
    "ExportNamedDeclaration" === nodeType ||
    "ForOfStatement" === nodeType ||
    "ImportDeclaration" === nodeType ||
    "DeclareClass" === nodeType ||
    "DeclareFunction" === nodeType ||
    "DeclareInterface" === nodeType ||
    "DeclareModule" === nodeType ||
    "DeclareModuleExports" === nodeType ||
    "DeclareTypeAlias" === nodeType ||
    "DeclareOpaqueType" === nodeType ||
    "DeclareVariable" === nodeType ||
    "DeclareExportDeclaration" === nodeType ||
    "DeclareExportAllDeclaration" === nodeType ||
    "InterfaceDeclaration" === nodeType ||
    "OpaqueType" === nodeType ||
    "TypeAlias" === nodeType ||
    "EnumDeclaration" === nodeType ||
    "TSDeclareFunction" === nodeType ||
    "TSInterfaceDeclaration" === nodeType ||
    "TSTypeAliasDeclaration" === nodeType ||
    "TSEnumDeclaration" === nodeType ||
    "TSModuleDeclaration" === nodeType ||
    "TSImportEqualsDeclaration" === nodeType ||
    "TSExportAssignment" === nodeType ||
    "TSNamespaceExportDeclaration" === nodeType ||
    (nodeType === "Placeholder" &&
      ("Statement" === node.expectedNode ||
        "Declaration" === node.expectedNode ||
        "BlockStatement" === node.expectedNode))
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTerminatorless(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Terminatorless" ||
    "BreakStatement" === nodeType ||
    "ContinueStatement" === nodeType ||
    "ReturnStatement" === nodeType ||
    "ThrowStatement" === nodeType ||
    "YieldExpression" === nodeType ||
    "AwaitExpression" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isCompletionStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "CompletionStatement" ||
    "BreakStatement" === nodeType ||
    "ContinueStatement" === nodeType ||
    "ReturnStatement" === nodeType ||
    "ThrowStatement" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isConditional(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Conditional" ||
    "ConditionalExpression" === nodeType ||
    "IfStatement" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isLoop(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Loop" ||
    "DoWhileStatement" === nodeType ||
    "ForInStatement" === nodeType ||
    "ForStatement" === nodeType ||
    "WhileStatement" === nodeType ||
    "ForOfStatement" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isWhile(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "While" ||
    "DoWhileStatement" === nodeType ||
    "WhileStatement" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isExpressionWrapper(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "ExpressionWrapper" ||
    "ExpressionStatement" === nodeType ||
    "ParenthesizedExpression" === nodeType ||
    "TypeCastExpression" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFor(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "For" ||
    "ForInStatement" === nodeType ||
    "ForStatement" === nodeType ||
    "ForOfStatement" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isForXStatement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "ForXStatement" ||
    "ForInStatement" === nodeType ||
    "ForOfStatement" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFunction(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Function" ||
    "FunctionDeclaration" === nodeType ||
    "FunctionExpression" === nodeType ||
    "ObjectMethod" === nodeType ||
    "ArrowFunctionExpression" === nodeType ||
    "ClassMethod" === nodeType ||
    "ClassPrivateMethod" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFunctionParent(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "FunctionParent" ||
    "FunctionDeclaration" === nodeType ||
    "FunctionExpression" === nodeType ||
    "ObjectMethod" === nodeType ||
    "ArrowFunctionExpression" === nodeType ||
    "ClassMethod" === nodeType ||
    "ClassPrivateMethod" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isPureish(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Pureish" ||
    "FunctionDeclaration" === nodeType ||
    "FunctionExpression" === nodeType ||
    "StringLiteral" === nodeType ||
    "NumericLiteral" === nodeType ||
    "NullLiteral" === nodeType ||
    "BooleanLiteral" === nodeType ||
    "RegExpLiteral" === nodeType ||
    "ArrowFunctionExpression" === nodeType ||
    "BigIntLiteral" === nodeType ||
    "DecimalLiteral" === nodeType ||
    (nodeType === "Placeholder" && "StringLiteral" === node.expectedNode)
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Declaration" ||
    "FunctionDeclaration" === nodeType ||
    "VariableDeclaration" === nodeType ||
    "ClassDeclaration" === nodeType ||
    "ExportAllDeclaration" === nodeType ||
    "ExportDefaultDeclaration" === nodeType ||
    "ExportNamedDeclaration" === nodeType ||
    "ImportDeclaration" === nodeType ||
    "DeclareClass" === nodeType ||
    "DeclareFunction" === nodeType ||
    "DeclareInterface" === nodeType ||
    "DeclareModule" === nodeType ||
    "DeclareModuleExports" === nodeType ||
    "DeclareTypeAlias" === nodeType ||
    "DeclareOpaqueType" === nodeType ||
    "DeclareVariable" === nodeType ||
    "DeclareExportDeclaration" === nodeType ||
    "DeclareExportAllDeclaration" === nodeType ||
    "InterfaceDeclaration" === nodeType ||
    "OpaqueType" === nodeType ||
    "TypeAlias" === nodeType ||
    "EnumDeclaration" === nodeType ||
    "TSDeclareFunction" === nodeType ||
    "TSInterfaceDeclaration" === nodeType ||
    "TSTypeAliasDeclaration" === nodeType ||
    "TSEnumDeclaration" === nodeType ||
    "TSModuleDeclaration" === nodeType ||
    (nodeType === "Placeholder" && "Declaration" === node.expectedNode)
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isPatternLike(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "PatternLike" ||
    "Identifier" === nodeType ||
    "RestElement" === nodeType ||
    "AssignmentPattern" === nodeType ||
    "ArrayPattern" === nodeType ||
    "ObjectPattern" === nodeType ||
    (nodeType === "Placeholder" &&
      ("Pattern" === node.expectedNode || "Identifier" === node.expectedNode))
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isLVal(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "LVal" ||
    "Identifier" === nodeType ||
    "MemberExpression" === nodeType ||
    "RestElement" === nodeType ||
    "AssignmentPattern" === nodeType ||
    "ArrayPattern" === nodeType ||
    "ObjectPattern" === nodeType ||
    "TSParameterProperty" === nodeType ||
    (nodeType === "Placeholder" &&
      ("Pattern" === node.expectedNode || "Identifier" === node.expectedNode))
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSEntityName(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "TSEntityName" ||
    "Identifier" === nodeType ||
    "TSQualifiedName" === nodeType ||
    (nodeType === "Placeholder" && "Identifier" === node.expectedNode)
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isLiteral(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Literal" ||
    "StringLiteral" === nodeType ||
    "NumericLiteral" === nodeType ||
    "NullLiteral" === nodeType ||
    "BooleanLiteral" === nodeType ||
    "RegExpLiteral" === nodeType ||
    "TemplateLiteral" === nodeType ||
    "BigIntLiteral" === nodeType ||
    "DecimalLiteral" === nodeType ||
    (nodeType === "Placeholder" && "StringLiteral" === node.expectedNode)
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isImmutable(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Immutable" ||
    "StringLiteral" === nodeType ||
    "NumericLiteral" === nodeType ||
    "NullLiteral" === nodeType ||
    "BooleanLiteral" === nodeType ||
    "BigIntLiteral" === nodeType ||
    "JSXAttribute" === nodeType ||
    "JSXClosingElement" === nodeType ||
    "JSXElement" === nodeType ||
    "JSXExpressionContainer" === nodeType ||
    "JSXSpreadChild" === nodeType ||
    "JSXOpeningElement" === nodeType ||
    "JSXText" === nodeType ||
    "JSXFragment" === nodeType ||
    "JSXOpeningFragment" === nodeType ||
    "JSXClosingFragment" === nodeType ||
    "DecimalLiteral" === nodeType ||
    (nodeType === "Placeholder" && "StringLiteral" === node.expectedNode)
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isUserWhitespacable(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "UserWhitespacable" ||
    "ObjectMethod" === nodeType ||
    "ObjectProperty" === nodeType ||
    "ObjectTypeInternalSlot" === nodeType ||
    "ObjectTypeCallProperty" === nodeType ||
    "ObjectTypeIndexer" === nodeType ||
    "ObjectTypeProperty" === nodeType ||
    "ObjectTypeSpreadProperty" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isMethod(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Method" ||
    "ObjectMethod" === nodeType ||
    "ClassMethod" === nodeType ||
    "ClassPrivateMethod" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isObjectMember(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "ObjectMember" ||
    "ObjectMethod" === nodeType ||
    "ObjectProperty" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isProperty(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Property" ||
    "ObjectProperty" === nodeType ||
    "ClassProperty" === nodeType ||
    "ClassPrivateProperty" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isUnaryLike(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "UnaryLike" ||
    "UnaryExpression" === nodeType ||
    "SpreadElement" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isPattern(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Pattern" ||
    "AssignmentPattern" === nodeType ||
    "ArrayPattern" === nodeType ||
    "ObjectPattern" === nodeType ||
    (nodeType === "Placeholder" && "Pattern" === node.expectedNode)
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isClass(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Class" ||
    "ClassExpression" === nodeType ||
    "ClassDeclaration" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isModuleDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "ModuleDeclaration" ||
    "ExportAllDeclaration" === nodeType ||
    "ExportDefaultDeclaration" === nodeType ||
    "ExportNamedDeclaration" === nodeType ||
    "ImportDeclaration" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isExportDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "ExportDeclaration" ||
    "ExportAllDeclaration" === nodeType ||
    "ExportDefaultDeclaration" === nodeType ||
    "ExportNamedDeclaration" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isModuleSpecifier(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "ModuleSpecifier" ||
    "ExportSpecifier" === nodeType ||
    "ImportDefaultSpecifier" === nodeType ||
    "ImportNamespaceSpecifier" === nodeType ||
    "ImportSpecifier" === nodeType ||
    "ExportNamespaceSpecifier" === nodeType ||
    "ExportDefaultSpecifier" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFlow(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Flow" ||
    "AnyTypeAnnotation" === nodeType ||
    "ArrayTypeAnnotation" === nodeType ||
    "BooleanTypeAnnotation" === nodeType ||
    "BooleanLiteralTypeAnnotation" === nodeType ||
    "NullLiteralTypeAnnotation" === nodeType ||
    "ClassImplements" === nodeType ||
    "DeclareClass" === nodeType ||
    "DeclareFunction" === nodeType ||
    "DeclareInterface" === nodeType ||
    "DeclareModule" === nodeType ||
    "DeclareModuleExports" === nodeType ||
    "DeclareTypeAlias" === nodeType ||
    "DeclareOpaqueType" === nodeType ||
    "DeclareVariable" === nodeType ||
    "DeclareExportDeclaration" === nodeType ||
    "DeclareExportAllDeclaration" === nodeType ||
    "DeclaredPredicate" === nodeType ||
    "ExistsTypeAnnotation" === nodeType ||
    "FunctionTypeAnnotation" === nodeType ||
    "FunctionTypeParam" === nodeType ||
    "GenericTypeAnnotation" === nodeType ||
    "InferredPredicate" === nodeType ||
    "InterfaceExtends" === nodeType ||
    "InterfaceDeclaration" === nodeType ||
    "InterfaceTypeAnnotation" === nodeType ||
    "IntersectionTypeAnnotation" === nodeType ||
    "MixedTypeAnnotation" === nodeType ||
    "EmptyTypeAnnotation" === nodeType ||
    "NullableTypeAnnotation" === nodeType ||
    "NumberLiteralTypeAnnotation" === nodeType ||
    "NumberTypeAnnotation" === nodeType ||
    "ObjectTypeAnnotation" === nodeType ||
    "ObjectTypeInternalSlot" === nodeType ||
    "ObjectTypeCallProperty" === nodeType ||
    "ObjectTypeIndexer" === nodeType ||
    "ObjectTypeProperty" === nodeType ||
    "ObjectTypeSpreadProperty" === nodeType ||
    "OpaqueType" === nodeType ||
    "QualifiedTypeIdentifier" === nodeType ||
    "StringLiteralTypeAnnotation" === nodeType ||
    "StringTypeAnnotation" === nodeType ||
    "SymbolTypeAnnotation" === nodeType ||
    "ThisTypeAnnotation" === nodeType ||
    "TupleTypeAnnotation" === nodeType ||
    "TypeofTypeAnnotation" === nodeType ||
    "TypeAlias" === nodeType ||
    "TypeAnnotation" === nodeType ||
    "TypeCastExpression" === nodeType ||
    "TypeParameter" === nodeType ||
    "TypeParameterDeclaration" === nodeType ||
    "TypeParameterInstantiation" === nodeType ||
    "UnionTypeAnnotation" === nodeType ||
    "Variance" === nodeType ||
    "VoidTypeAnnotation" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFlowType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "FlowType" ||
    "AnyTypeAnnotation" === nodeType ||
    "ArrayTypeAnnotation" === nodeType ||
    "BooleanTypeAnnotation" === nodeType ||
    "BooleanLiteralTypeAnnotation" === nodeType ||
    "NullLiteralTypeAnnotation" === nodeType ||
    "ExistsTypeAnnotation" === nodeType ||
    "FunctionTypeAnnotation" === nodeType ||
    "GenericTypeAnnotation" === nodeType ||
    "InterfaceTypeAnnotation" === nodeType ||
    "IntersectionTypeAnnotation" === nodeType ||
    "MixedTypeAnnotation" === nodeType ||
    "EmptyTypeAnnotation" === nodeType ||
    "NullableTypeAnnotation" === nodeType ||
    "NumberLiteralTypeAnnotation" === nodeType ||
    "NumberTypeAnnotation" === nodeType ||
    "ObjectTypeAnnotation" === nodeType ||
    "StringLiteralTypeAnnotation" === nodeType ||
    "StringTypeAnnotation" === nodeType ||
    "SymbolTypeAnnotation" === nodeType ||
    "ThisTypeAnnotation" === nodeType ||
    "TupleTypeAnnotation" === nodeType ||
    "TypeofTypeAnnotation" === nodeType ||
    "UnionTypeAnnotation" === nodeType ||
    "VoidTypeAnnotation" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFlowBaseAnnotation(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "FlowBaseAnnotation" ||
    "AnyTypeAnnotation" === nodeType ||
    "BooleanTypeAnnotation" === nodeType ||
    "NullLiteralTypeAnnotation" === nodeType ||
    "MixedTypeAnnotation" === nodeType ||
    "EmptyTypeAnnotation" === nodeType ||
    "NumberTypeAnnotation" === nodeType ||
    "StringTypeAnnotation" === nodeType ||
    "SymbolTypeAnnotation" === nodeType ||
    "ThisTypeAnnotation" === nodeType ||
    "VoidTypeAnnotation" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFlowDeclaration(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "FlowDeclaration" ||
    "DeclareClass" === nodeType ||
    "DeclareFunction" === nodeType ||
    "DeclareInterface" === nodeType ||
    "DeclareModule" === nodeType ||
    "DeclareModuleExports" === nodeType ||
    "DeclareTypeAlias" === nodeType ||
    "DeclareOpaqueType" === nodeType ||
    "DeclareVariable" === nodeType ||
    "DeclareExportDeclaration" === nodeType ||
    "DeclareExportAllDeclaration" === nodeType ||
    "InterfaceDeclaration" === nodeType ||
    "OpaqueType" === nodeType ||
    "TypeAlias" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isFlowPredicate(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "FlowPredicate" ||
    "DeclaredPredicate" === nodeType ||
    "InferredPredicate" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEnumBody(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "EnumBody" ||
    "EnumBooleanBody" === nodeType ||
    "EnumNumberBody" === nodeType ||
    "EnumStringBody" === nodeType ||
    "EnumSymbolBody" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isEnumMember(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "EnumMember" ||
    "EnumBooleanMember" === nodeType ||
    "EnumNumberMember" === nodeType ||
    "EnumStringMember" === nodeType ||
    "EnumDefaultedMember" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isJSX(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "JSX" ||
    "JSXAttribute" === nodeType ||
    "JSXClosingElement" === nodeType ||
    "JSXElement" === nodeType ||
    "JSXEmptyExpression" === nodeType ||
    "JSXExpressionContainer" === nodeType ||
    "JSXSpreadChild" === nodeType ||
    "JSXIdentifier" === nodeType ||
    "JSXMemberExpression" === nodeType ||
    "JSXNamespacedName" === nodeType ||
    "JSXOpeningElement" === nodeType ||
    "JSXSpreadAttribute" === nodeType ||
    "JSXText" === nodeType ||
    "JSXFragment" === nodeType ||
    "JSXOpeningFragment" === nodeType ||
    "JSXClosingFragment" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isPrivate(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "Private" ||
    "ClassPrivateProperty" === nodeType ||
    "ClassPrivateMethod" === nodeType ||
    "PrivateName" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSTypeElement(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "TSTypeElement" ||
    "TSCallSignatureDeclaration" === nodeType ||
    "TSConstructSignatureDeclaration" === nodeType ||
    "TSPropertySignature" === nodeType ||
    "TSMethodSignature" === nodeType ||
    "TSIndexSignature" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "TSType" ||
    "TSAnyKeyword" === nodeType ||
    "TSBooleanKeyword" === nodeType ||
    "TSBigIntKeyword" === nodeType ||
    "TSNeverKeyword" === nodeType ||
    "TSNullKeyword" === nodeType ||
    "TSNumberKeyword" === nodeType ||
    "TSObjectKeyword" === nodeType ||
    "TSStringKeyword" === nodeType ||
    "TSSymbolKeyword" === nodeType ||
    "TSUndefinedKeyword" === nodeType ||
    "TSUnknownKeyword" === nodeType ||
    "TSVoidKeyword" === nodeType ||
    "TSThisType" === nodeType ||
    "TSFunctionType" === nodeType ||
    "TSConstructorType" === nodeType ||
    "TSTypeReference" === nodeType ||
    "TSTypePredicate" === nodeType ||
    "TSTypeQuery" === nodeType ||
    "TSTypeLiteral" === nodeType ||
    "TSArrayType" === nodeType ||
    "TSTupleType" === nodeType ||
    "TSOptionalType" === nodeType ||
    "TSRestType" === nodeType ||
    "TSUnionType" === nodeType ||
    "TSIntersectionType" === nodeType ||
    "TSConditionalType" === nodeType ||
    "TSInferType" === nodeType ||
    "TSParenthesizedType" === nodeType ||
    "TSTypeOperator" === nodeType ||
    "TSIndexedAccessType" === nodeType ||
    "TSMappedType" === nodeType ||
    "TSLiteralType" === nodeType ||
    "TSExpressionWithTypeArguments" === nodeType ||
    "TSImportType" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isTSBaseType(node: ?Object, opts?: Object): boolean {
  if (!node) return false;

  const nodeType = node.type;
  if (
    nodeType === "TSBaseType" ||
    "TSAnyKeyword" === nodeType ||
    "TSBooleanKeyword" === nodeType ||
    "TSBigIntKeyword" === nodeType ||
    "TSNeverKeyword" === nodeType ||
    "TSNullKeyword" === nodeType ||
    "TSNumberKeyword" === nodeType ||
    "TSObjectKeyword" === nodeType ||
    "TSStringKeyword" === nodeType ||
    "TSSymbolKeyword" === nodeType ||
    "TSUndefinedKeyword" === nodeType ||
    "TSUnknownKeyword" === nodeType ||
    "TSVoidKeyword" === nodeType ||
    "TSThisType" === nodeType ||
    "TSLiteralType" === nodeType
  ) {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isNumberLiteral(node: ?Object, opts?: Object): boolean {
  console.trace(
    "The node type NumberLiteral has been renamed to NumericLiteral",
  );
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "NumberLiteral") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isRegexLiteral(node: ?Object, opts?: Object): boolean {
  console.trace("The node type RegexLiteral has been renamed to RegExpLiteral");
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "RegexLiteral") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isRestProperty(node: ?Object, opts?: Object): boolean {
  console.trace("The node type RestProperty has been renamed to RestElement");
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "RestProperty") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
export function isSpreadProperty(node: ?Object, opts?: Object): boolean {
  console.trace(
    "The node type SpreadProperty has been renamed to SpreadElement",
  );
  if (!node) return false;

  const nodeType = node.type;
  if (nodeType === "SpreadProperty") {
    if (typeof opts === "undefined") {
      return true;
    } else {
      return shallowEqual(node, opts);
    }
  }

  return false;
}
