'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _fs = require('fs');

var _fs2 = _interopRequireDefault(_fs);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * The MIT License (MIT)
 * Copyright (c) 2015-present Dmitry Soshnikov <dmitry.soshnikov@gmail.com>
 */

var LLParserGeneratorDefault = require(ROOT + 'll/ll-parser-generator-default').default;
var RubyParserGeneratorTrait = require('../ruby-parser-generator-trait');

/**
 * Generic Ruby template for LL(1) parser.
 */
var RUBY_LL_PARSER_TEMPLATE = _fs2.default.readFileSync(__dirname + '/../templates/ll.template.rb', 'utf-8');

/**
 * LL parser generator for Ruby.
 */

var LLParserGeneratorRuby = function (_LLParserGeneratorDef) {
  _inherits(LLParserGeneratorRuby, _LLParserGeneratorDef);

  /**
   * Instance constructor.
   */
  function LLParserGeneratorRuby(_ref) {
    var _this;

    var grammar = _ref.grammar,
        outputFile = _ref.outputFile,
        _ref$options = _ref.options,
        options = _ref$options === undefined ? {} : _ref$options;

    _classCallCheck(this, LLParserGeneratorRuby);

    (_this = _possibleConstructorReturn(this, (LLParserGeneratorRuby.__proto__ || Object.getPrototypeOf(LLParserGeneratorRuby)).call(this, { grammar: grammar, outputFile: outputFile, options: options })), _this).setTemplate(RUBY_LL_PARSER_TEMPLATE);

    _this._lexHandlers = [];
    _this._productionHandlers = [];

    _this._parserClassName = _path2.default.basename(outputFile, _path2.default.extname(outputFile));

    // Trait provides methods for lex and production handlers.
    Object.assign(_this, RubyParserGeneratorTrait);
    return _this;
  }

  /**
   * Generates parser code.
   */


  _createClass(LLParserGeneratorRuby, [{
    key: 'generateParserData',
    value: function generateParserData() {
      _get(LLParserGeneratorRuby.prototype.__proto__ || Object.getPrototypeOf(LLParserGeneratorRuby.prototype), 'generateParserData', this).call(this);
      this.generateLexHandlers();
      this.generateProductionHandlers();
      this.generateParserClassName(this._parserClassName);
    }
  }]);

  return LLParserGeneratorRuby;
}(LLParserGeneratorDefault);

exports.default = LLParserGeneratorRuby;
;