# Contributing

From opening a bug report to creating a pull request: every contribution is
appreciated and welcome. If you're planning to implement a new feature or change
the api please create an issue first. This way we can ensure that your precious
work is not in vain.

## Issues

Most of the time, if webpack is not working correctly for you it is a simple configuration issue.

If you are still having difficulty after looking over your configuration carefully, please post
a question to [StackOverflow with the webpack tag](http://stackoverflow.com/tags/webpack). Questions
that include your webpack.config.js, relevant files, and the full error message are more likely to receive responses.

**If you have discovered a bug or have a feature suggestion, please [create an issue on GitHub](https://github.com/webpack/webpack/issues/new).**

Do you want to fix an issue?  Look at the issues with a tag of [X5: work required (PR / Help Wanted)](https://github.com/webpack/webpack/labels/X5%3A%20work%20required%20%28PR%20%2F%20Help%20Wanted%29).  Each issue should be tagged with a difficulty tag -

- D0: My First Commit (Contribution Difficulty)
- D1: Easy (Contribution Difficulty)
- D2: Medium (Contribution Difficulty)
- D3: Hard (Contribution Difficulty)

## Contributing to the webpack ecosystem

If you have created your own loader/plugin please include it on the relevant documentation pages:

- [List of loaders](https://webpack.js.org/loaders/) or [awesome-webpack](https://github.com/webpack-contrib/awesome-webpack#loaders)
- [List of plugins](https://webpack.js.org/plugins) or [awesome-webpack](https://github.com/webpack-contrib/awesome-webpack#webpack-plugins)

## Setup

[Setup your local webpack repository](_SETUP.md)

## Submitting Changes

After getting some feedback, push to your fork and submit a pull request. We
may suggest some changes or improvements or alternatives, but for small changes
your pull request should be accepted quickly.

Some things that will increase the chance that your pull request is accepted:

* [Write tests](./test/README.md)
* Follow the existing coding style
* Write a [good commit message](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html)

## Documentation

webpack is insanely feature rich and documentation is a huge time sink. We
greatly appreciate any time spent fixing typos or clarifying sections in the
documentation. [See a list of issues with the documentation tag.](https://github.com/webpack/webpack/labels/documentation)

## Discussions

Gitter is only for small questions. To discuss a subject in detail, please send a link to your forum or blog in the Gitter chat.
