# V8

> Stability: 2 - Stable

This module exposes events and interfaces specific to the version of [V8][]
built with Node.js.  These interfaces are subject to change by upstream and are
therefore not covered under the stability index.

## getHeapStatistics()
<!-- YAML
added: v1.0.0
-->

Returns an object with the following properties

```js
{
  total_heap_size: 7326976,
  total_heap_size_executable: 4194304,
  total_physical_size: 7326976,
  total_available_size: 1152656,
  used_heap_size: 3476208,
  heap_size_limit: 1535115264
}
```

## setFlagsFromString(string)
<!-- YAML
added: v1.0.0
-->

Set additional V8 command line flags.  Use with care; changing settings
after the VM has started may result in unpredictable behavior, including
crashes and data loss.  Or it may simply do nothing.

The V8 options available for a version of Node.js may be determined by running
`node --v8-options`.  An unofficial, community-maintained list of options
and their effects is available [here][].

Usage:

```js
// Print GC events to stdout for one minute.
const v8 = require('v8');
v8.setFlagsFromString('--trace_gc');
setTimeout(function() { v8.setFlagsFromString('--notrace_gc'); }, 60e3);
```

[V8]: https://developers.google.com/v8/
[here]: https://github.com/thlorenz/v8-flags/blob/master/flags-0.11.md
