'use strict';

const common = require('../common.js');
const assert = require('assert');

const bench = common.createBenchmark(main, {
  method: ['swap', 'destructure'],
  millions: [100]
});

function runSwapManual(n) {
  var i = 0, x, y, r;
  bench.start();
  for (; i < n; i++) {
    x = 1, y = 2;
    r = x;
    x = y;
    y = r;
    assert.strictEqual(x, 2);
    assert.strictEqual(y, 1);
  }
  bench.end(n / 1e6);
}

function runSwapDestructured(n) {
  var i = 0, x, y;
  bench.start();
  for (; i < n; i++) {
    x = 1, y = 2;
    [x, y] = [y, x];
    assert.strictEqual(x, 2);
    assert.strictEqual(y, 1);
  }
  bench.end(n / 1e6);
}

function main(conf) {
  const n = +conf.millions * 1e6;

  switch (conf.method) {
    case 'swap':
      runSwapManual(n);
      break;
    case 'destructure':
      runSwapDestructured(n);
      break;
    default:
      throw new Error('Unexpected method');
  }
}
