%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}

%global with_lfc  %{!?_without_lfc:1}%{?_without_lfc:0}
%global with_java %{!?_without_java:1}%{?_without_java:0}
%global with_gcj  %{!?_with_gcj:0}%{?_with_gcj:1}

%global pkgdir arc

Name:		nordugrid-arc
Version:	1.0.0
Release:	1%{?dist}
Summary:	ARC
Group:		System Environment/Daemons
License:	ASL 2.0
URL:		http://www.nordugrid.org/
Source:		%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Provides:	%{name}-libs = %{version}-%{release}
Obsoletes:	%{name}-libs < 1.0.0
Provides:	nordugrid-arc1 = 1.3.0
Obsoletes:	nordugrid-arc1 < 1.0.0
Provides:	nordugrid-arc-nox = 1.3.0
Obsoletes:	nordugrid-arc-nox < 1.3.0
#		Packages dropped without replacements
Obsoletes:	%{name}-httpsd < 0.8.2-1
Obsoletes:	%{name}-logger-server < 0.8.2-1
Obsoletes:	nordugrid-arc-nox-charon < 1.3.0
Obsoletes:	nordugrid-arc-nox-compiler < 1.3.0
Obsoletes:	nordugrid-arc-nox-delegation < 1.3.0
Obsoletes:	nordugrid-arc-nox-paul < 1.3.0
Obsoletes:	nordugrid-arc-nox-saml2sp < 1.3.0
Obsoletes:	nordugrid-arc-nox-slcs < 1.3.0

BuildRequires:	cppunit-devel
BuildRequires:	pkgconfig
%if %{?fedora}%{!?fedora:0} >= 12 || %{?rhel}%{!?rhel:0} >= 6
BuildRequires:	libuuid-devel
%else
BuildRequires:	e2fsprogs-devel
%endif
BuildRequires:	gettext
BuildRequires:	python-devel
BuildRequires:	glibmm24-devel
BuildRequires:	glib2-devel
BuildRequires:	libxml2-devel
BuildRequires:	openssl
BuildRequires:	openssl-devel
BuildRequires:	xmlsec1-devel >= 1.2.4
BuildRequires:	xmlsec1-openssl-devel >= 1.2.4
BuildRequires:	openldap-devel
BuildRequires:	globus-common-devel
BuildRequires:	globus-ftp-client-devel
BuildRequires:	globus-ftp-control-devel
BuildRequires:	globus-rls-client-devel
%if %{with_lfc}
BuildRequires:	lfc-devel
%endif
BuildRequires:	gridsite-devel
%if %{?suse_version}%{!?suse_version:0}
BuildRequires: libdb-4_5-devel
%else
BuildRequires: db4-devel
%endif
%if %{with_java}
BuildRequires:	java-devel
BuildRequires:	jpackage-utils
%if %{?fedora}%{!?fedora:0} == 3
BuildRequires:	libgcj-devel
%endif
%if %{with_gcj}
%if %{?fedora}%{!?fedora:0} >= 4 || %{?rhel}%{!?rhel:0} >= 5
BuildRequires:	java-gcj-compat-devel
%else
BuildRequires:	java-1.4.2-gcj-compat-devel
%endif
%endif
%endif
# Needed for LRMS testing during make check
BuildRequires:	perl(Test::Harness)
BuildRequires:	perl(Test::Simple)
BuildRequires:	mktemp
%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
# The compilation of the selinux module fails on Fedora 5
BuildRequires:	selinux-policy-devel
%endif

%define pyver %(python -c 'import sys; print sys.version[:3]')
%if "%{pyver}" < "2.4"
%define ifpy #
%else
%define ifpy %{nil}
%endif

%description
ARC

%package client
Summary:	ARC prototype clients
Group:		Applications/Internet
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}
Provides:	nordugrid-arc1-client = 1.3.0
Obsoletes:	nordugrid-arc1-client < 1.0.0
Provides:	nordugrid-arc-nox-client = 1.3.0
Obsoletes:	nordugrid-arc-nox-client < 1.3.0

%description client
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

For the regular user of any ARC-based computational grid,
this client package contains (or depends on) all packages
that are needed to submit jobs, query their status and
retrieve results.

%package hed
Summary:	ARC Hosting Environment Daemon
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Provides:	nordugrid-arc1-server = 1.3.0
Obsoletes:	nordugrid-arc1-server < 1.0.0
Provides:	nordugrid-arc-nox-hed = 1.3.0
Obsoletes:	nordugrid-arc-nox-hed < 1.3.0

Requires(post):		chkconfig
Requires(preun):	chkconfig
Requires(preun):	initscripts
Requires(postun):	initscripts

%description hed
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The ARC Hosting Environment Daemon (HED). This daemon presents a
site to other participants on the grid.  An intrinsic component
of any grid system is a mechanism allowing for the secure stateful
communication with remote environments. HED prepares for such an
environment and as such is the core of the ARC middleware. HED
was however written in a way, that represents typical grid
computing tasks (the sharing of CPU time or storage) to become
just one possible service between a user and a remote machine.
Many others are thinkable, and HED takes considerable effort
away from the respective implementors.

#%package charon
#Summary:	ARC charon service
#Group:		System Environment/Libraries
#Requires:	%{name} = %{version}-%{release}
#Requires:	%{name}-hed = %{version}-%{release}
#Provides:	nordugrid-arc-nox-charon = 1.3.0
#Obsoletes:	nordugrid-arc-nox-charon < 1.3.0
#
#%description charon
#The NorduGrid is a collaboration aiming at development, maintenance
#and support of the free Grid middleware, known as the Advanced
#Resource Connector (ARC).
#
#CHARON is a remote policy decision point service.  It accepts formatted
#policy decision request and return positive or negative response. When
#running a CHARON (within the HED), the TLS layer can be used for
#securing the communication, when the request or response  information
#are critical.

%package chelonia
Summary:	ARC chelonia service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Requires:	%{name}-python = %{version}-%{release}
Provides:	nordugrid-arc-nox-chelonia = 1.3.0
Obsoletes:	nordugrid-arc-nox-chelonia < 1.3.0

%description chelonia
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The NorduGrid storage service Chelonia consists of a set of SOAP based
services residing within HED. Together, the services provide a self-healing,
reliable, robust, scalable, resilient and consistent data storage system.

%package hopi
Summary:	ARC hopi service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Provides:	nordugrid-arc-nox-hopi = 1.3.0
Obsoletes:	nordugrid-arc-nox-hopi < 1.3.0

%description hopi
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The HOPI service provides a simple implementation of an http(s)
server. It supports GET and PUT operations. It can be used as a simple
file transfer service and it is usable via common web browsers and
other http(s) clients (e.g. wget).

%package isis
Summary:	ARC isis service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}
Provides:	nordugrid-arc-nox-isis = 1.3.0
Obsoletes:	nordugrid-arc-nox-isis < 1.3.0

%description isis
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

ISIS is the new ARC information system implemented within HED. ISIS
comes with P2P capabilities and a web-services interface. The new system
grants grid participants an increase in flexibility, robustness and it
also offers easier configuration and self-healing capability.

%package gridftpd
Summary:	ARC gridftp server
Group:		System Environment/Daemons
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-globus
Provides:	nordugrid-arc-nox-gridftp-server = 1.3.0
Obsoletes:	nordugrid-arc-nox-gridftp-server < 1.3.0

Requires(post):		chkconfig
Requires(preun):	chkconfig
Requires(preun):	initscripts
Requires(postun):	initscripts

%description gridftpd
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC gridftp server which has a plugin framework.
Current plugins include:

  fileplugin : Standard gridftp server based on Globus globus-ftp-control
  gaclplugin : Enhanced server with support for GACL authorization
  jobplugin  : Classical ARC job submission interface

%package cache-service
Summary:	ARC cache service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}
Provides:	nordugrid-arc-nox-cache-service = 1.3.0
Obsoletes:	nordugrid-arc-nox-cache-service < 1.3.0

Requires(post):		chkconfig
Requires(preun):	chkconfig
Requires(preun):	initscripts
Requires(postun):	initscripts

%description cache-service
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC cache service. It provides a way to perform
some operations on the A-REX cache remotely. It can be especially helpful
for data management within a pilot job framework.

%package aris
Summary:	ARC LDAP information service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	bdii
Provides:	%{name}-infoindex = %{version}-%{release}
Obsoletes:	%{name}-infoindex < 0.8.2-1
Provides:	%{name}-infosys-ldap = %{version}-%{release}
Obsoletes:	%{name}-infosys-ldap < 1.0.0
Provides:	nordugrid-arc-nox-ldap-infosys = 1.3.0
Obsoletes:	nordugrid-arc-nox-ldap-infosys < 1.3.0
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

Requires(post):		chkconfig
Requires(preun):	chkconfig
Requires(preun):	initscripts
Requires(postun):	initscripts

%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
Requires(post):		policycoreutils
Requires(postun):	policycoreutils
%if %{?fedora}%{!?fedora:0} >= 11 || %{?rhel}%{!?rhel:0} >= 6
Requires(post):		policycoreutils-python
Requires(postun):	policycoreutils-python
%endif
%endif

%description aris
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the LDAP based information system for ARC.
This package is not self-contained. it should be pulled in by either
nordugrid-arc-arex to be a part of a local information system or by
nordugrid-arc-egiis to be a part of a EGIIS service.

%package egiis
Summary:	ARC EGIIS service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-aris = %{version}-%{release}
Provides:	nordugrid-arc-nox-giis = 1.3.0
Obsoletes:	nordugrid-arc-nox-giis < 1.3.0

%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
Requires(post):		policycoreutils
Requires(postun):	policycoreutils
%endif

%description egiis
 The NorduGrid is a collaboration aiming at development, maintenance
 and support of the free Grid middleware, known as the Advanced Resource
 Connector (ARC).

 The EGIIS is the Information Index Service used by ARC, This service is
 used to set up a ldap-based server that local information systems register
 to.

%package ldap-monitor
Summary:	ARC LDAP monitor service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Provides:	%{name}-monitor = %{version}-%{release}
Obsoletes:	%{name}-monitor < 1.0.0
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description ldap-monitor
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the LDAP monitor system for ARC.
This package is self-contained. It is used to set up a web-based monitor
which pulls information from a EGIIS and shows it graphically.

%package ws-monitor
Summary:	ARC WS monitor service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description ws-monitor
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the WS monitor system for ARC.
This package is self-contained. It is used to set up a web-based monitor
which pulls information from ISIS and shows it graphically.

#%package slcs
#Summary:	ARC slcs service
#Group:		System Environment/Libraries
#Requires:	%{name} = %{version}-%{release}
#Requires:	%{name}-hed = %{version}-%{release}
#Provides:	nordugrid-arc-nox-slcs = 1.3.0
#Obsoletes:	nordugrid-arc-nox-slcs < 1.3.0
#
#%description slcs
#The NorduGrid is a collaboration aiming at development, maintenance
#and support of the free Grid middleware, known as the Advanced Resource
#Connector (ARC).
#
#ARC Short-lived credential service.

%package arex
Summary:	ARC Remote EXecution service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}
Requires:	mktemp
Requires:	python-twisted-core
Requires:	python-twisted-web
Requires:	%{name}-aris = %{version}-%{release}
Provides:	%{name}-grid-manager = %{version}-%{release}
Obsoletes:	%{name}-grid-manager < 1.0.0
Provides:	%{name}-server = %{version}-%{release}
Obsoletes:	%{name}-server < 1.0.0
Provides:	nordugrid-arc1-arex = 1.3.0
Obsoletes:	nordugrid-arc1-arex < 1.0.0
Provides:	nordugrid-arc-nox-arex = 1.3.0
Obsoletes:	nordugrid-arc-nox-arex < 1.3.0

Requires(post):		chkconfig
Requires(preun):	chkconfig
Requires(preun):	initscripts
Requires(postun):	initscripts

%description arex
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).

The ARC Remote EXecution service (AREX) represents those parts of
the middleware that is responsible for the execution of compute
jobs and the transfer of input or output data.


%package plugins-needed
Summary:	ARC base plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Provides:	nordugrid-arc1-plugins-base = 1.3.0
Obsoletes:	nordugrid-arc1-plugins-base < 1.0.0
Provides:	nordugrid-arc-nox-plugins-base = 1.3.0
Obsoletes:	nordugrid-arc-nox-plugins-base < 1.3.0
Provides:	nordugrid-arc-plugins-base = %{version}-%{release}
Obsoletes:	nordugrid-arc-plugins-base < 1.0.0-0.b2

%description plugins-needed
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).

ARC base plugins. This includes the Message Chain Components (MCCs) and
Data Manager Components (DMCs).

%package plugins-globus
Summary:	ARC Globus plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Provides:	nordugrid-arc1-plugins-globus = 1.3.0
Obsoletes:	nordugrid-arc1-plugins-globus < 1.0.0
Provides:	nordugrid-arc-nox-plugins-globus = 1.3.0
Obsoletes:	nordugrid-arc-nox-plugins-globus < 1.3.0

%description plugins-globus
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).

ARC Globus plugins. This includes the Globus dependent Data Manager
Components (DMCs).

%package devel
Summary:	ARC development files
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	glibmm24-devel
Requires:	glib2-devel
Requires:	libxml2-devel
Requires:	openssl-devel
Provides:	%{name}-libs-devel = %{version}-%{release}
Obsoletes:	%{name}-libs-devel < 1.0.0
Provides:	nordugrid-arc1-devel = 1.3.0
Obsoletes:	nordugrid-arc1-devel < 1.0.0
Provides:	nordugrid-arc-nox-devel = 1.3.0
Obsoletes:	nordugrid-arc-nox-devel < 1.3.0

%description devel
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).

The ARC middleware's core functionality, the Hosting Environment
Daemon (HED) can be extended for novel services. Considerable parts
of a regular installation of a regular installation of the NorduGrid
represent such modules.

%package python
Summary:	ARC Python wrapper
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	python
Requires:	fuse-python
Provides:	nordugrid-arc1-python = 1.3.0
Obsoletes:	nordugrid-arc1-python < 1.0.0
Provides:	nordugrid-arc-nox-python = 1.3.0
Obsoletes:	nordugrid-arc-nox-python < 1.3.0

%description python
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).

Developers with an interest to integrate the some functionality on
a remote site via an interface compatible with ARC, may find it
preferable to perform that remote invocation from within Python.
While today most services in ARC are associated with computation or
storage, there is no constraint on these applications.

%if %{with_java}
%package java
Summary:	ARC Java wrapper
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	java
Requires:	jpackage-utils
%if %{with_gcj}
Requires(post):		java-gcj-compat
Requires(postun):	java-gcj-compat
%endif
Provides:	nordugrid-arc1-java = 1.3.0
Obsoletes:	nordugrid-arc1-java < 1.0.0
Provides:	nordugrid-arc-nox-java = 1.3.0
Obsoletes:	nordugrid-arc-nox-java < 1.3.0

%description java
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).

Developers with an interest to integrate the some functionality on
a remote site via an interface compatible with ARC, may find it
preferable to perform that remote invocation from within Java.
While today most services in ARC are associated with computation or
storage, there is no constraint on these applications.
%endif

%package janitor
Summary:	ARC dynamic installation of runtime environments
Group:		Applications/Internet
Requires:	wget
Provides:	nordugrid-arc1-janitor = 1.3.0
Obsoletes:	nordugrid-arc1-janitor < 1.0.0
Provides:	nordugrid-arc-nox-janitor = 1.3.0
Obsoletes:	nordugrid-arc-nox-janitor < 1.3.0

%description janitor
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).

For grid computing, a major challenge is to keep the working environments
homogeneous between the sites.  To help this situation, runtime
environments have been developed. Those can be added to or removed from
a site, and this Janitor service helps automating this process.

The Janitor is a recent development and the community to prepare
catalogues of dynamically installable packages still needs to
evolve.

%package doxygen
Summary:	ARC API documentation
Group:		Documentation
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description doxygen
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).

Reference to the ARC programming API. It is prepared with doxygen.

%package gridmap-utils
Summary:	NorduGrid authorization tools
Group:		Applications/Internet
Requires:	perl(Crypt::SSLeay)
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description gridmap-utils
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).

This package contains the ARC authorization machinery.
A prominent tool distributed in this package is the nordugridmap
script to collect user information from the virtual organisations.

%package ca-utils
Summary:	NorduGrid authentication tools
Group:		Applications/Internet
Requires:	fetch-crl
Requires(post):	fetch-crl
Requires(post):	chkconfig
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description ca-utils
The NorduGrid is a collaboration aiming at development, maintenance
and support of the free Grid middleware, known as the Advanced
Resource Connector (ARC).

The nordugrid-arc-ca-utils packages has been obsoleted.
The functionality of the grid-update-crls tool is provided by the
fetch-crl tool in the fetch-crl package.

%prep
%setup -q

%if %{?fedora}%{!?fedora:0} <= 9 && %{?rhel}%{!?rhel:0} <= 5
# Older versions of SELinux does not have policy for open
cd selinux
sed -e 's/ open / /' -e /open/d -i %{name}-egiis.te
cd -
%endif

%build
%configure --disable-static \
%if ! %{with_java}
     --disable-java \
%endif
%if ! %{with_lfc}
     --disable-lfc \
%endif
     --disable-doc \
     --with-docdir=%{_docdir}/%{name}-%{version} \
     --disable-charon-service --disable-charon-client

make %{?_smp_mflags}

%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
cd selinux
make -f /usr/share/selinux/devel/Makefile
cd -
%endif

%check
make check

%install
rm -rf $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT

# Install Logrotate.
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d
install -p -m 644 debian/%{name}-arex.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-arex
install -p -m 644 debian/%{name}-gridftpd.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-gridftpd
install -p -m 644 debian/%{name}-aris.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-aris

find $RPM_BUILD_ROOT -type f -name \*.la -exec rm -fv '{}' ';'

# Turn off default enabling of the services
mkdir -p $RPM_BUILD_ROOT%{_initrddir}
sed -e 's/\(chkconfig: \)\w*/\1-/' \
    -e '/Default-Start/d' \
    -e 's/\(Default-Stop:\s*\).*/\10 1 2 3 4 5 6/' \
    -i $RPM_BUILD_ROOT%{_initrddir}/*

# Create log directory
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/arc

%find_lang %{name}

%if %{with_java} && %{with_gcj}
%{_bindir}/aot-compile-rpm
%endif

%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
cd selinux
mkdir -p $RPM_BUILD_ROOT%{_datadir}/selinux/packages/%{name}
install -p -m 644 %{name}-egiis.pp \
    $RPM_BUILD_ROOT%{_datadir}/selinux/packages/%{name}
cd -
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post hed
/sbin/chkconfig --add arched

%preun hed
if [ $1 = 0 ]; then
  service arched stop > /dev/null 2>&1
  /sbin/chkconfig --del arched
fi

%postun hed
if [ "$1" -ge "1" ]; then
  service arched condrestart > /dev/null 2>&1
fi
exit 0

%post arex
/sbin/chkconfig --add a-rex

%preun arex
if [ $1 = 0 ]; then
  service a-rex stop > /dev/null 2>&1
  /sbin/chkconfig --del a-rex
fi

%postun arex
if [ "$1" -ge "1" ]; then
  service a-rex condrestart > /dev/null 2>&1
fi
exit 0

%post gridftpd
/sbin/chkconfig --add gridftpd

%preun gridftpd
if [ $1 = 0 ]; then
  service gridftpd stop > /dev/null 2>&1
  /sbin/chkconfig --del gridftpd
fi

%postun gridftpd
if [ "$1" -ge "1" ]; then
  service gridftpd condrestart > /dev/null 2>&1
fi
exit 0

%post cache-service
/sbin/chkconfig --add cache-service

%preun cache-service
if [ $1 = 0 ]; then
  service cache-service stop > /dev/null 2>&1
  /sbin/chkconfig --del cache-service
fi

%postun cache-service
if [ "$1" -ge "1" ]; then
  service cache-service condrestart > /dev/null 2>&1
fi
exit 0

%post aris
/sbin/chkconfig --add grid-infosys
%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
semanage port -a -t ldap_port_t -p tcp 2135 2>/dev/null || :
%endif

%preun aris
if [ $1 = 0 ]; then
  service grid-infosys stop > /dev/null 2>&1
  /sbin/chkconfig --del grid-infosys
fi

%postun aris
if [ "$1" -ge "1" ]; then
  service grid-infosys condrestart > /dev/null 2>&1
fi
%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
if [ $1 -eq 0 ]; then
  semanage port -d -t ldap_port_t -p tcp 2135 2>/dev/null || :
fi
%endif

%post egiis
%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
/usr/sbin/semodule -i %{_datadir}/selinux/packages/%{name}/%{name}-egiis.pp > /dev/null 2>&1 || :
/sbin/restorecon %{_sbindir}/arc-infoindex-relay
%endif

%postun egiis
%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
if [ $1 -eq 0 ] ; then
  /usr/sbin/semodule -r %{name}-egiis > /dev/null 2>&1 || :
fi
%endif

%if %{with_java} && %{with_gcj}
%post java
[ -x %{_bindir}/rebuild-gcj-db ] && %{_bindir}/rebuild-gcj-db
%endif

%if %{with_java} && %{with_gcj}
%postun java
[ -x %{_bindir}/rebuild-gcj-db ] && %{_bindir}/rebuild-gcj-db
%endif

%post ca-utils
# Enable CRL updates via cron for backward compatibility
/sbin/chkconfig fetch-crl-cron on

%files -f %{name}.lang
%defattr(-,root,root,-)
%{_libdir}/libarcclient.so.*
%{_libdir}/libarccommon.so.*
%{_libdir}/libarccredential.so.*
%{_libdir}/libarccredentialstore.so.*
%{_libdir}/libarccrypto.so.*
%{_libdir}/libarcdata2.so.*
%{_libdir}/libarcdbxml.so.*
%{_libdir}/libarcloader.so.*
%{_libdir}/libarcmessage.so.*
%{_libdir}/libarcsecurity.so.*
%{_libdir}/libarcws.so.*
%{_libdir}/libarcwssecurity.so.*
%{_libdir}/libarcxmlsec.so.*
# We need to have libmodcrypto.so close to libarccrypto
%{_libdir}/%{pkgdir}/libmodcrypto.so
%{_libdir}/%{pkgdir}/libmodcrypto.apd
# We need to have libmodcredential.so close to libarccredential
%{_libdir}/%{pkgdir}/libmodcredential.so
%{_libdir}/%{pkgdir}/libmodcredential.apd
%{_libexecdir}/%{pkgdir}/arc-file-access
%{_bindir}/ngconfigtest
%doc %{_mandir}/man1/ngconfigtest.1*
%{_datadir}/%{pkgdir}/schema
%dir %{_datadir}/%{pkgdir}/perl
%dir %{_datadir}/%{pkgdir}
%doc README AUTHORS LICENSE

%files client
%defattr(-,root,root,-)
%{_bindir}/arccat
%{_bindir}/arcclean
%{_bindir}/arccp
#%{_bindir}/arcdecision
%{_bindir}/arcecho
%{_bindir}/arcget
%{_bindir}/arcinfo
%{_bindir}/arckill
%{_bindir}/arcls
%{_bindir}/arcmigrate
%{_bindir}/arcproxy
%{_bindir}/arcrenew
%{_bindir}/arcresub
%{_bindir}/arcresume
%{_bindir}/arcrm
%{_bindir}/arcslcs
%{_bindir}/arcsrmping
%{_bindir}/arcstat
%{_bindir}/arcsub
%{_bindir}/arcsync
%{_bindir}/arctest
%{_bindir}/arcwsrf
%{_bindir}/chelonia
%{_bindir}/isistest
%{_bindir}/perftest
%{_bindir}/saml_assertion_init
%{_bindir}/ngclient2arc
%config(noreplace) %{_sysconfdir}/%{pkgdir}/client.conf
%{_datadir}/%{pkgdir}/examples/client.conf
%{_datadir}/%{pkgdir}/examples/arc.conf.template
%doc %{_mandir}/man1/arccat.1*
%doc %{_mandir}/man1/arcclean.1*
%doc %{_mandir}/man1/arccp.1*
#%doc %{_mandir}/man1/arcdecision.1*
%doc %{_mandir}/man1/arcecho.1*
%doc %{_mandir}/man1/arcget.1*
%doc %{_mandir}/man1/arcinfo.1*
%doc %{_mandir}/man1/arckill.1*
%doc %{_mandir}/man1/arcls.1*
%doc %{_mandir}/man1/arcmigrate.1*
%doc %{_mandir}/man1/arcproxy.1*
%doc %{_mandir}/man1/arcrenew.1*
%doc %{_mandir}/man1/arcresub.1*
%doc %{_mandir}/man1/arcresume.1*
%doc %{_mandir}/man1/arcrm.1*
%doc %{_mandir}/man1/arcslcs.1*
%doc %{_mandir}/man1/arcstat.1*
%doc %{_mandir}/man1/arcsrmping.1*
%doc %{_mandir}/man1/arcsub.1*
%doc %{_mandir}/man1/arcsync.1*
%doc %{_mandir}/man1/arctest.1*
%doc %{_mandir}/man1/arcwsrf.1*
%doc %{_mandir}/man1/chelonia.1*
%doc %{_mandir}/man1/isistest.1*
%doc %{_mandir}/man1/perftest.1.gz
%doc %{_mandir}/man1/saml_assertion_init.1*
%doc %{_mandir}/man1/ngclient2arc.1*
#%doc %{_datadir}/%{pkgdir}/examples/charon/charon_client.xml.example
#%doc %{_datadir}/%{pkgdir}/examples/charon/charon_request.xml.example
%doc %{_datadir}/%{pkgdir}/examples/echo/echo.wsdl

%files hed
%defattr(-,root,root,-)
%{_initrddir}/arched
%{_sbindir}/arched
%{_libdir}/%{pkgdir}/libecho.so
%{_libdir}/%{pkgdir}/libecho.apd
%{_datadir}/%{pkgdir}/profiles
%{_datadir}/%{pkgdir}/examples/config
%doc %{_datadir}/%{pkgdir}/examples/echo/echo_service.xml.example
%doc %{_mandir}/man8/arched.8*
%doc %{_mandir}/man5/arc.conf.5*

#%files charon
#%defattr(-,root,root,-)
#%{_libdir}/%{pkgdir}/libcharon.so
#%{_libdir}/%{pkgdir}/libcharon.apd
#%doc %{_datadir}/%{pkgdir}/examples/charon/charon_policy_arc.xml.example
#%doc %{_datadir}/%{pkgdir}/examples/charon/charon_policy_xacml.xml.example
#%doc %{_datadir}/%{pkgdir}/examples/charon/charon_service.xml.example

%files chelonia
%defattr(-,root,root,-)
%{_bindir}/arcfs
%{python_sitearch}/storage
%doc %{_datadir}/%{pkgdir}/examples/storage_service.xml.example

%files hopi
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libhopi.so
%{_libdir}/%{pkgdir}/libhopi.apd
%doc %{_datadir}/%{pkgdir}/examples/hopi/hopi_service.xml.example

%files isis
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libisis.so
%{_libdir}/%{pkgdir}/libisis.apd

%files gridftpd
%defattr(-,root,root,-)
%{_initrddir}/gridftpd
%{_sbindir}/gridftpd
%{_libdir}/%{pkgdir}/jobplugin.*
%{_libdir}/%{pkgdir}/gaclplugin.*
%{_libdir}/%{pkgdir}/fileplugin.*
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-gridftpd

%files aris
%defattr(-,root,root,-)
%{_initrddir}/grid-infosys
%{_datadir}/%{pkgdir}/grid-infosys-bdii4
%{_datadir}/%{pkgdir}/grid-infosys-bdii5
%{_datadir}/%{pkgdir}/glue-generator.pl
%{_datadir}/%{pkgdir}/glite-info-provider-ldap
%{_datadir}/%{pkgdir}/ldap-schema
%{_datadir}/%{pkgdir}/grid-info-soft-register
%{_datadir}/%{pkgdir}/qju.pl
%{_datadir}/%{pkgdir}/cluster.pl
%{_datadir}/%{pkgdir}/se.pl
%{_datadir}/%{pkgdir}/LRMS.pm
%{_datadir}/%{pkgdir}/Shared.pm
%{_datadir}/%{pkgdir}/ConfigParser.pm
%{_datadir}/%{pkgdir}/config_parser_compat.sh
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-aris

%files egiis
%defattr(-,root,root,-)
%{_sbindir}/arc-infoindex-relay
%{_sbindir}/arc-infoindex-server
%{_libdir}/%{pkgdir}/arc-infoindex-slapd-wrapper.so
%{_libdir}/%{pkgdir}/arc-infoindex-slapd-wrapper.apd
%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
%{_datadir}/selinux/packages/%{name}
%endif

%files ldap-monitor
%defattr(-,root,root,-)
%{_datadir}/%{pkgdir}/ldap-monitor/*
%doc %{_mandir}/man7/ldap-monitor.7*

%files ws-monitor
%defattr(-,root,root,-)
%{_datadir}/%{pkgdir}/ws-monitor/*
%doc %{_mandir}/man7/ws-monitor.7*

#%files slcs
#%defattr(-,root,root,-)
#%{_libdir}/%{pkgdir}/libslcs.so
#%{_libdir}/%{pkgdir}/libslcs.apd

%files cache-service
%defattr(-,root,root,-)
%{_initrddir}/cache-service
%{_libdir}/%{pkgdir}/libcacheservice.so
%{_libdir}/%{pkgdir}/libcacheservice.apd

%files arex
%defattr(-,root,root,-)
%{_initrddir}/a-rex
%{_libexecdir}/%{pkgdir}/cache-clean
%{_libexecdir}/%{pkgdir}/cache-list
%{_libexecdir}/%{pkgdir}/jura
%{_libexecdir}/%{pkgdir}/downloader
%{_libexecdir}/%{pkgdir}/gm-jobs
%{_libexecdir}/%{pkgdir}/gm-kick
%{_libexecdir}/%{pkgdir}/smtp-send
%{_libexecdir}/%{pkgdir}/smtp-send.sh
%{_libexecdir}/%{pkgdir}/uploader
%{_libexecdir}/%{pkgdir}/inputcheck
%{_libexecdir}/%{pkgdir}/arc-ur-logger
%{_libexecdir}/%{pkgdir}/arc-ur-registrant
%{_datadir}/%{pkgdir}/cancel-*-job
%{_datadir}/%{pkgdir}/scan-*-job
%{_datadir}/%{pkgdir}/submit-*-job
%{_datadir}/%{pkgdir}/finish-condor-job
%{_libexecdir}/%{pkgdir}/DataStagingDelivery
%{_datadir}/%{pkgdir}/DGAuthplug.py*
%{_datadir}/%{pkgdir}/DGBridgeDataPlugin.py*
%{_datadir}/%{pkgdir}/DGLog2XML.py*
%{_libdir}/%{pkgdir}/libarex.so
%{_libdir}/%{pkgdir}/libarex.apd
%{_datadir}/%{pkgdir}/CEinfo.pl
%{_datadir}/%{pkgdir}/ARC0mod.pm
%{_datadir}/%{pkgdir}/FORKmod.pm
%{_datadir}/%{pkgdir}/Fork.pm
%{_datadir}/%{pkgdir}/SGEmod.pm
%{_datadir}/%{pkgdir}/SGE.pm
%{_datadir}/%{pkgdir}/LL.pm
%{_datadir}/%{pkgdir}/LSF.pm
%{_datadir}/%{pkgdir}/PBS.pm
%{_datadir}/%{pkgdir}/Condor.pm
%{_datadir}/%{pkgdir}/SLURM.pm
%{_datadir}/%{pkgdir}/GridFactory.pm
%{_datadir}/%{pkgdir}/DGBridge.pm
%{_datadir}/%{pkgdir}/XmlPrinter.pm
%{_datadir}/%{pkgdir}/InfosysHelper.pm
%{_datadir}/%{pkgdir}/LdifPrinter.pm
%{_datadir}/%{pkgdir}/GLUE2xmlPrinter.pm
%{_datadir}/%{pkgdir}/GLUE2ldifPrinter.pm
%{_datadir}/%{pkgdir}/NGldifPrinter.pm
%{_datadir}/%{pkgdir}/ARC0ClusterInfo.pm
%{_datadir}/%{pkgdir}/ARC1ClusterInfo.pm
%{_datadir}/%{pkgdir}/ConfigCentral.pm
%{_datadir}/%{pkgdir}/GMJobsInfo.pm
%{_datadir}/%{pkgdir}/HostInfo.pm
%{_datadir}/%{pkgdir}/RTEInfo.pm
%{_datadir}/%{pkgdir}/InfoChecker.pm
%{_datadir}/%{pkgdir}/IniParser.pm
%{_datadir}/%{pkgdir}/LRMSInfo.pm
%{_datadir}/%{pkgdir}/Sysinfo.pm
%{_datadir}/%{pkgdir}/LogUtils.pm
%{_datadir}/%{pkgdir}/condor_env.pm
%{_datadir}/%{pkgdir}/cancel_common.sh
%{_datadir}/%{pkgdir}/config_parser.sh
%{_datadir}/%{pkgdir}/configure-*-env.sh
%{_datadir}/%{pkgdir}/submit_common.sh
%{_datadir}/%{pkgdir}/scan_common.sh
%doc %{_mandir}/man1/cache-clean.1*
%doc %{_mandir}/man1/cache-list.1*
%doc %{_mandir}/man1/jura.1*
%doc %{_datadir}/%{pkgdir}/examples/a-rex/arex.xml.example
%doc %{_datadir}/%{pkgdir}/examples/a-rex/arex_minimalistic.xml.example
%doc %{_datadir}/%{pkgdir}/examples/a-rex/arex_secure.xml.example
%doc %{_datadir}/%{pkgdir}/examples/a-rex/arex_showcase.xml.example
%doc %{_datadir}/%{pkgdir}/examples/a-rex/arex_janitor.xml.example
%doc %{_datadir}/%{pkgdir}/examples/a-rex/arex_xmlonly.xml.example
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-arex
%dir %{_localstatedir}/log/arc

%files devel
%defattr(-,root,root,-)
%{_includedir}/%{pkgdir}
%{_libdir}/lib*.so
%{_bindir}/wsdl2hed
%doc %{_mandir}/man1/wsdl2hed.1*
%{_bindir}/arcplugin
%doc %{_mandir}/man1/arcplugin.1*
%{_libdir}/pkgconfig/arcbase.pc
%doc  src/hed/shc/arcpdp/*.xsd

%files plugins-needed
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libaccARC1.so
%{_libdir}/%{pkgdir}/libaccCREAM.so
%{_libdir}/%{pkgdir}/libaccBroker.so
%{_libdir}/%{pkgdir}/libaccJobDescriptionParser.so
#%{_libdir}/%{pkgdir}/libaccUNICORE.so
%{_libdir}/%{pkgdir}/libarcshc.so
%{_libdir}/%{pkgdir}/libdmcarc.so
%{_libdir}/%{pkgdir}/libdmcfile.so
%{_libdir}/%{pkgdir}/libdmchttp.so
%{_libdir}/%{pkgdir}/libdmcldap.so
%{_libdir}/%{pkgdir}/libdmcsrm.so
%{_libdir}/%{pkgdir}/libidentitymap.so
%{_libdir}/%{pkgdir}/libmcchttp.so
%{_libdir}/%{pkgdir}/libmccmsgvalidator.so
%{_libdir}/%{pkgdir}/libmccsoap.so
%{_libdir}/%{pkgdir}/libmcctcp.so
%{_libdir}/%{pkgdir}/libmcctls.so
%{_libdir}/%{pkgdir}/libaccARC1.apd
%{_libdir}/%{pkgdir}/libaccCREAM.apd
%{_libdir}/%{pkgdir}/libaccBroker.apd
%{_libdir}/%{pkgdir}/libaccJobDescriptionParser.apd
#%{_libdir}/%{pkgdir}/libaccUNICORE.apd
%{_libdir}/%{pkgdir}/libarcshc.apd
%{_libdir}/%{pkgdir}/libdmcarc.apd
%{_libdir}/%{pkgdir}/libdmcfile.apd
%{_libdir}/%{pkgdir}/libdmchttp.apd
%{_libdir}/%{pkgdir}/libdmcldap.apd
%{_libdir}/%{pkgdir}/libdmcsrm.apd
%{_libdir}/%{pkgdir}/libidentitymap.apd
%{_libdir}/%{pkgdir}/libmcchttp.apd
%{_libdir}/%{pkgdir}/libmccsoap.apd
%{_libdir}/%{pkgdir}/libmcctcp.apd
%{_libdir}/%{pkgdir}/libmccmsgvalidator.apd
%{_libdir}/%{pkgdir}/libmcctls.apd

%files plugins-globus
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libaccARC0.so
%{_libdir}/%{pkgdir}/libdmcgridftp.so
%{_libdir}/%{pkgdir}/libaccARC0.apd
%{_libdir}/%{pkgdir}/libdmcgridftp.apd
%if %{with_lfc}
%{_libdir}/%{pkgdir}/libdmclfc.so
%{_libdir}/%{pkgdir}/libdmclfc.apd
%endif
%{_libdir}/%{pkgdir}/libdmcrls.so
%{_libdir}/%{pkgdir}/libmccgsi.so
%{_libdir}/%{pkgdir}/libdmcrls.apd
%{_libdir}/%{pkgdir}/libmccgsi.apd
%{_libdir}/libarcglobusutils.so.*

%files python
%defattr(-,root,root,-)
%{python_sitearch}/_arc.so
%{python_sitearch}/arc.py*
%{python_sitearch}/arcom
%{python_sitearch}/cache
%{ifpy}%{python_sitearch}/echo_python
%{_libdir}/%{pkgdir}/libaccPythonBroker.so
%{_libdir}/%{pkgdir}/libaccPythonBroker.apd
%{ifpy}%{_libdir}/%{pkgdir}/libpythonservice.so
%{ifpy}%{_libdir}/%{pkgdir}/libpythonservice.apd
%doc %{_datadir}/%{pkgdir}/examples/PythonBroker/SampleBroker.py*

%if %{with_java}
%files java
%defattr(-,root,root,-)
%{_libdir}/java/libjarc.so
%{_libdir}/java/arc.jar
%{_libdir}/%{pkgdir}/libjavaservice.so
%{_libdir}/%{pkgdir}/libjavaservice.apd
%if %{with_gcj}
%{_libdir}/gcj/%{name}
%endif
%endif

%files janitor
%defattr(-,root,root,-)
%{_libexecdir}/%{pkgdir}/janitor
%{_datadir}/%{pkgdir}/janitor
%{_datadir}/%{pkgdir}/perl/Janitor
%doc %{_mandir}/man8/janitor.8*

%files doxygen
%defattr(-,root,root,-)
%doc src/doxygen/ARC1-API.pdf
%doc src/doxygen/ARC1-ChainComponents.pdf
%doc src/doxygen/ARC1-Services.pdf

%files gridmap-utils
%defattr(-,root,root,-)
%{_sbindir}/nordugridmap
%config(noreplace) %{_sysconfdir}/cron.d/nordugridmap
%doc src/utils/gridmap/nordugridmap.conf

%files ca-utils
%defattr(-,root,root,-)

%changelog
* Mon Apr 18 2011 Anders Waananen <waananen@nbi.dk> - 1.0.0-1
- Initial release
