import os
import re
import sys

class Config(object):
    """nose configuration. For internal use only.
    """

    def __init__(self, **kw):
        self.testMatch = re.compile(r'(?:^|[\b_\.%s-])[Tt]est' % os.sep)
        self.addPaths = True
        self.capture = True
        self.detailedErrors = False
        self.debugErrors = False
        self.debugFailures = False
        self.exclude = None
        self.includeExe = sys.platform=='win32'
        self.ignoreFiles = [ re.compile(r'^\.'),
                             re.compile(r'^_'),
                             re.compile(r'^setup\.py$')
                             ]
        self.include = None
        self.plugins = []
        self.srcDirs = ['lib', 'src']
        self.stopOnError = False
        self.tests = []
        self.verbosity = 1
        self.where = None
        self.update(kw)
        self._orig = self.__dict__.copy()
        
    def __str__(self):
        # FIXME -- in alpha order
        return repr(self.__dict__)

    def reset(self):
        self.__dict__.update(self._orig)

    def todict(self):
        return self.__dict__.copy()
        
    def update(self, d):
        self.__dict__.update(d)
