/****************************************************************************/
/* ##   ##         #####   #####  ##     **      NoSQL RDBMS - filemode     */
/* ###  ##        ####### ####### ##     **        $Revision: 1.1.1.1 $       */
/* #### ##        ###     ##   ## ##     ************************************/
/* #######  ####  #####   ##   ## ##     **   Carlo Strozzi (c) 1998-2000   */
/* ####### ######   ##### ## # ## ##     ************************************/
/* ## #### ##  ##     ### ##  ### ##     **           Written by            */
/* ##  ### ###### ####### ######  ###### **          Carlo Strozzi          */
/* ##   ##  ####   #####   #### # ###### **     e-mail: carlos@linux.it     */
/****************************************************************************/
/*  NoSQL RDBMS, Copyright (C) 1998 Carlo Strozzi.                          */
/*  This program comes with ABSOLUTELY NO WARRANTY; for details             */
/*  refer to the GNU General Public License.                                */
/****************************************************************************

   Print file permissions, in octal.

   Usage: filemode [-T|--table] file [ file ... ]

   This operator takes a list of file names on the command line and
   prints the associated file permissions, in octal, to STDOUT. If
   '-v' is specified, then also the file name is printed to STDOUT,
   in the format of a two-column NoSQL table. If no files are specified
   then a usage message is printed to STDERR. If any of the files cannot
   be found, an error is printed to STDERR and a non zero exit code is
   returned.

 ****************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <sys/stat.h>

int main( int argc, char **argv )
{
  int table = 0;
  int min_args = 1;
  int count = 0;
  int rc = 0;
  struct stat statbuf;

  if ( argc > 1 )
  {
    if ( !strcmp( argv[1], "-T" ) || !strcmp( argv[1], "--table" ) )
    {
      table = 1;
      min_args = 2;
      count++;
    }
  }

  if ( argc == min_args )
  {
    fprintf( stderr, "Usage: filemode [-T|--table] file[s]\n" );
    exit(1);
  }
  else
  {
    if ( table ) printf( "File\tMode\n----\t----\n" );

    while ( ++count < argc )
    {
      if ( stat( argv[count], &statbuf) < 0)
      {
        fprintf( stderr, "filemode: stat failure on %s\n", argv[count] );
        rc = 2;
      }
      else
      {
        if ( table )
          printf( "%s\t%04o\n", argv[count], statbuf.st_mode & 00007777 );
        else printf( "%04o\n", statbuf.st_mode & 00007777 );
      }
    }
  }
  exit(rc);
}

/* End of program */
