/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */


#ifndef __NB_NOTE_H__
#define __NB_NOTE_H__

#include <glib.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

enum {
	NOTE,
	PERSONAL,
	PROBLEM,
	TRICK,
	BOOKMARK
};
	
enum { 
	NONE,
	OPEN,
	SOLVED
};

typedef struct _exporttype exporttype;

struct _exporttype 
{
	gboolean note;
	gboolean personal;
	gboolean problem;
	gboolean trick;
	gboolean bookmark;
};

typedef struct _note 	note;

struct _note
{
	gchar * title;
	gchar * text;
	GDate * date;
	GDate * lastUpdate;
	int type;
	int status;
};

/* create a new note */
note 	* nb_note_new		(gchar * title,
				 gchar * text,
				 int type,
				 int status,
				 GDate * date,
				 GDate * lastupdate); 	

note	* nb_note_new_empty	(void);
note 	* nb_note_load_from_file (xmlDocPtr doc, xmlNodePtr cur);
GDate	* nb_note_load_date_from_file (xmlDocPtr doc, xmlNodePtr cur);

/* clear/load text */
void	nb_note_clear_text	(note * n);
gchar 	* nb_note_get_text_from_file (xmlDocPtr doc, xmlNodePtr cur);

/* set new title */
void 	nb_note_set_title	(note * n, gchar * title);

/* set new text */
void 	nb_note_set_text	(note * n, gchar * text);

/* set new type */
void	nb_note_set_type	(note * n, int type);

/* set new  status */
void 	nb_note_set_status	(note * n, int status);

xmlNodePtr	nb_note_get_new_pointer	(note * n, xmlNsPtr ns, int index);

/* return true if one of the note fieds matches the given query */
gboolean nb_note_matches_query (note * n, gchar * query); 

gboolean nb_note_matches_type (note * n, exporttype * etype);

gchar 	* nb_note_get_string_from_date	(GDate * date);

#endif
